/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.apiutil;

import com.netegrity.sdk.apiutil.SmApiConnection;
import com.netegrity.sdk.apiutil.SmApiConstants;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiObject;
import com.netegrity.sdk.apiutil.SmApiResult;
import java.net.InetAddress;
import java.util.Hashtable;

public class SmApiSession {
    private SmApiConnection m_ApiConnection = null;
    private String m_SessionSpec = null;

    public SmApiSession(SmApiConnection smApiConnection) {
        this.m_ApiConnection = smApiConnection;
        this.m_SessionSpec = "";
    }

    public SmApiSession(SmApiConnection smApiConnection, String string) {
        this.m_ApiConnection = smApiConnection;
        this.m_SessionSpec = string;
    }

    public SmApiConnection getApiConnection() {
        return this.m_ApiConnection;
    }

    public void setApiConnection(SmApiConnection smApiConnection) {
        this.m_ApiConnection = smApiConnection;
    }

    public SmApiResult login(String string, String string2, InetAddress inetAddress, int n) throws SmApiException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(3);
        hashtable.put(SmApiConstants.SMAPI_KEY_USER.toString(), string);
        hashtable.put(SmApiConstants.SMAPI_KEY_PASSWORD.toString(), string2);
        hashtable.put(SmApiConstants.SMAPI_KEY_IPADDRESS.toString(), inetAddress.toString());
        hashtable.put(SmApiConstants.SMAPI_KEY_CHALLENGE_REASON.toString(), new Integer(n));
        SmApiObject smApiObject = new SmApiObject(hashtable);
        SmApiResult smApiResult = this.m_ApiConnection.execute("", SmApiConstants.SMAPI_CMD_LOGIN, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        this.setSessionSpec(smApiResult.getMessage());
        return smApiResult;
    }

    public SmApiResult logout() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        SmApiResult smApiResult = this.m_ApiConnection.execute(this.getSessionSpec(), SmApiConstants.SMAPI_CMD_LOGOUT, smApiObject);
        return smApiResult;
    }

    public void setSessionSpec(String string) throws SmApiException {
        if (this.m_ApiConnection == null || !this.m_ApiConnection.isValidApiConnection()) {
            throw new SmApiException(SmApiResult.INVALID_AGENT_CONNECTION);
        }
        this.m_SessionSpec = string;
    }

    public String getSessionSpec() {
        return this.m_SessionSpec;
    }

    public int getLicenseInfo(String string) throws SmApiException {
        int n;
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_LICENSE_FEATURE.toString(), string);
        SmApiResult smApiResult = this.m_ApiConnection.execute(this.m_SessionSpec, SmApiConstants.SMAPI_CMD_LICENSE_INFO, smApiObject);
        if (!smApiResult.isSuccess()) {
            throw new SmApiException(smApiResult);
        }
        smApiObject = smApiResult.getDecoderObject();
        String string2 = (String)smApiObject.getProperty(SmApiConstants.SMAPI_KEY_LICENSE_DAYS_LEFT);
        if (string2 == null) {
            string2 = new String("0");
        }
        if ((n = Integer.parseInt(string2, 10)) >= 0) {
            return n;
        }
        return -1;
    }
}

