/*
 * Decompiled with CFR 0.152.
 */
package com.coreblox.corebloxcrypto;

import com.coreblox.corebloxcrypto.SessionParametersInterface;
import com.coreblox.corebloxcrypto.SpringAwareObject;
import java.io.File;
import java.io.IOException;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public enum Decrypter {
    INSTANCE;


    public String decryptServerSecret(String originalPass, String ciphertext) throws Exception {
        String decrpytedText = new String();
        decrpytedText = this.decryptString(ciphertext, originalPass);
        return decrpytedText;
    }

    private void decryptFile(File encryptedFile, String key, String decryptedFileName) throws IOException, Exception {
        String encryptedString = FileUtils.readFileToString((File)encryptedFile);
        String decryptedString = this.decryptString(encryptedString, key);
        FileUtils.writeStringToFile((File)new File(decryptedFileName), (String)decryptedString);
    }

    public String decryptString(String ciphertext, String key) throws Exception {
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)ciphertext)) {
            String decryptedVal = "";
            StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
            if (key.isEmpty()) {
                SessionParametersInterface sp = SpringAwareObject.getSessionParameters();
                if (sp == null || sp.getPassword() == null) {
                    throw new Exception("Empty Password");
                }
                encryptor.setPassword(sp.getPassword());
            } else {
                encryptor.setPassword(key);
            }
            encryptor.setProviderName("BC");
            encryptor.setAlgorithm("PBEWITHSHA256AND256BITAES-CBC-BC");
            if (Security.getProvider("BC") == null) {
                Logger.getLogger(Decrypter.class.getName()).log(Level.INFO, "Bouncy Castle provider is not available");
            } else {
                Logger.getLogger(Decrypter.class.getName()).log(Level.INFO, "Bouncy Castle provider is available");
                encryptor.setProvider(Security.getProvider("BC"));
            }
            Logger.getLogger(Decrypter.class.getName()).log(Level.INFO, "Decrypting Value");
            try {
                decryptedVal = PropertyValueEncryptionUtils.decrypt((String)ciphertext, (StringEncryptor)encryptor);
            }
            catch (Exception ex) {
                Logger.getLogger(Decrypter.class.getName()).log(Level.SEVERE, null, ex.getMessage());
                throw ex;
            }
            return decryptedVal;
        }
        return ciphertext;
    }

    public boolean isEncryptedValue(String value) {
        return PropertyValueEncryptionUtils.isEncryptedValue((String)value);
    }
}

