/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.apiutil;

import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmProperty;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SmApiObject {
    private static final int PASSWORD_POLICY_ERROR = 29;
    protected static final String MULTI_ATTR_SEPARATOR = "^";
    protected static final String SM_EMS_KEY_START = "<";
    protected static final String SM_EMS_KEY_END = ">\n";
    protected static final String SM_EMS_KEY_LIST_END = ">\n>\n";
    protected static final String SM_EMS_KEY_EQUALS = "=";
    protected static final String SM_EMS_KEY_COMMAND = "<command=";
    protected static final String SM_EMS_KEY_SESSIONSPEC = "<sessionspec=";
    protected static final String SM_EMS_KEY_PARAMS = "<params=";
    protected static final String SM_EMS_KEY_DN = "<dn=";
    protected static final String SM_EMS_KEY_ORGDN = "<orgdn=";
    protected static final String SM_EMS_KEY_DIROID = "<diroid=";
    protected static final String SM_EMS_KEY_REALMOID = "<realmoid=";
    protected static final String SM_EMS_KEY_CLASSID = "<classid=";
    protected static final String SM_EMS_KEY_STATUS = "<status=";
    protected static final String SM_EMS_KEY_PROPERTIES = "<properties=";
    protected static final String SM_EMS_KEY_PROPERTIES_END = "</properties>";
    protected static final String SM_EMS_KEY_OBJECTS = "<objects=";
    protected static final String SM_EMS_KEY_OBJECTS_END = "</objects>";
    protected static final String SM_EMS_KEY_MESSAGE = "<message=";
    protected static final String SM_EMS_KEY_OBJECT = "<object=";
    protected static final String SM_EMS_KEY_SEPARATOR = "\u001f\u001f";
    protected static final String SEPARATOR_COMMA = ",";
    private String m_szRealmOid = "";
    private String m_szDirOid = "";
    private String m_szPasswordAttr = "";
    private String m_szDn = "";
    private String m_szOrganizationDn = "";
    private int m_nClassId = 0;
    private Hashtable m_properties = new Hashtable();

    public SmApiObject() {
    }

    public SmApiObject(Hashtable hashtable) {
        this.m_properties = hashtable;
    }

    public SmApiObject(SmApiObject smApiObject) {
        this.m_szRealmOid = smApiObject.getRealmOid();
        this.m_szDirOid = smApiObject.getDirOid();
        this.m_szPasswordAttr = smApiObject.getPasswordAttr();
        this.m_szDn = smApiObject.getDn();
        this.m_properties = smApiObject.getProperties();
    }

    public Hashtable getProperties() {
        return this.m_properties;
    }

    public void setProperties(Hashtable hashtable) {
        this.m_properties = hashtable;
    }

    public String getDirOid() {
        return this.m_szDirOid;
    }

    public void setDirOid(String string) {
        this.m_szDirOid = string;
    }

    public String getPasswordAttr() {
        return this.m_szPasswordAttr;
    }

    public void setPasswordAttr(String string) {
        this.m_szPasswordAttr = string;
    }

    public String getDn() {
        return this.m_szDn;
    }

    public void setDn(String string) {
        this.m_szDn = string;
    }

    public String getOrganizationDn() {
        return this.m_szOrganizationDn;
    }

    public void setOrganizationDn(String string) {
        this.m_szOrganizationDn = string;
    }

    public String getRealmOid() {
        return this.m_szRealmOid;
    }

    public void setRealmOid(String string) {
        this.m_szRealmOid = string;
    }

    public int getClassId() {
        return this.m_nClassId;
    }

    public void setClassId(int n) {
        this.m_nClassId = n;
    }

    public void setProperty(Object object, Object object2) {
        this.m_properties.put(object.toString(), object2);
    }

    public Object getProperty(Object object) {
        return this.m_properties.get(object.toString());
    }

    public SmApiResult decode(String string) {
        int n = -1;
        this.m_properties.clear();
        String string2 = SM_EMS_KEY_STATUS;
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return SmApiResult.CORRUPT_BUFFER;
        }
        int n3 = string.indexOf(SM_EMS_KEY_END, n2);
        if (n3 == -1) {
            return SmApiResult.CORRUPT_BUFFER;
        }
        String string3 = string.substring(n2 += string2.length(), n3);
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return SmApiResult.CORRUPT_BUFFER;
        }
        String string4 = "";
        string2 = SM_EMS_KEY_MESSAGE;
        n2 = string.indexOf(string2, n3);
        if (n2 != -1) {
            n3 = string.indexOf(SM_EMS_KEY_END, n2);
            if (n3 == -1) {
                return SmApiResult.CORRUPT_BUFFER;
            }
            string4 = string.substring(n2 += string2.length(), n3);
        }
        this.fillObject(string, n3);
        return new SmApiResult(n, string4, this);
    }

    public String fillObject(String string, int n) {
        int n2 = n;
        String string2 = "";
        this.m_properties.clear();
        String string3 = SM_EMS_KEY_PROPERTIES;
        n = string.indexOf(string3, n);
        if (n != -1) {
            n += string3.length();
            n2 = string.indexOf(SM_EMS_KEY_LIST_END);
            if (n2 != -1) {
                this.getResultProperties(string.substring(n, n2));
            }
            this.updateProperties();
        }
        if ((n = string.indexOf(string3 = SM_EMS_KEY_OBJECTS, n)) != -1) {
            this.getResultObjects(string.substring(n += string3.length()));
        }
        return string2;
    }

    private void updateProperties() {
        String string = (String)this.m_properties.get("ObjectClassName");
        if (string != null && string.equals("AgentConfig")) {
            SmProperty[] smPropertyArray;
            Enumeration enumeration = this.m_properties.keys();
            Enumeration enumeration2 = this.m_properties.elements();
            ArrayList<SmProperty> arrayList = new ArrayList<SmProperty>();
            while (enumeration2.hasMoreElements()) {
                smPropertyArray = (SmProperty[])enumeration.nextElement();
                String string2 = (String)enumeration2.nextElement();
                if (smPropertyArray.equals("Oid") || smPropertyArray.equals("ObjectClassName") || smPropertyArray.equals("Name") || smPropertyArray.equals("Desc") || smPropertyArray.indexOf("_type") != -1) continue;
                Object v = this.m_properties.get((String)smPropertyArray + "_type");
                arrayList.add(new SmProperty((String)smPropertyArray, string2, Integer.parseInt(v.toString())));
                this.m_properties.remove(smPropertyArray);
                this.m_properties.remove((String)smPropertyArray + "_type");
            }
            smPropertyArray = arrayList.toArray(new SmProperty[arrayList.size()]);
            this.m_properties.put("AgentConfigProperties", smPropertyArray);
        }
    }

    private void getResultProperties(String string) {
        int n = string.indexOf(SM_EMS_KEY_START);
        while (n != -1) {
            int n2 = string.indexOf(SM_EMS_KEY_END, n += SM_EMS_KEY_START.length());
            if (n2 == -1) {
                n2 = string.length();
            }
            String string2 = string.substring(n, n2);
            this.addProperty(string2, this.m_properties);
            n = string.indexOf(SM_EMS_KEY_START, n2);
        }
    }

    private void getResultObjects(String string) {
        int n = string.indexOf(SM_EMS_KEY_START);
        int n2 = string.indexOf(SM_EMS_KEY_START);
        n2 = string.indexOf(SM_EMS_KEY_OBJECT);
        int n3 = 0;
        while (n2 != -1) {
            String string2 = "";
            String string3 = "0";
            String string4 = SM_EMS_KEY_DN;
            if ((n2 = string.indexOf(string4, n2)) != -1 && (n = string.indexOf(SM_EMS_KEY_END, n2 += string4.length())) != -1) {
                string2 = string.substring(n2, n);
            }
            if ((n2 = string.indexOf(string4 = SM_EMS_KEY_CLASSID, n2)) != -1 && (n = string.indexOf(SM_EMS_KEY_END, n2 += string4.length())) != -1) {
                string3 = string.substring(n2, n);
            }
            int n4 = 0;
            try {
                if (string3.length() > 0) {
                    n4 = Integer.parseInt(string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                n4 = 0;
            }
            SmApiObject smApiObject = new SmApiObject();
            if (string2.length() > 0) {
                smApiObject.setDn(string2);
            }
            smApiObject.setClassId(n4);
            n2 = string.indexOf(SM_EMS_KEY_PROPERTIES, n2);
            n = string.indexOf(SM_EMS_KEY_OBJECT, n2);
            if (n == -1) {
                n = string.length();
            }
            smApiObject.fillObject(string.substring(n2, n), 0);
            String string5 = "object#" + new Integer(n3).toString();
            this.m_properties.put(string5, smApiObject);
            ++n3;
            n2 = string.indexOf(SM_EMS_KEY_OBJECT, n);
        }
    }

    Hashtable addProperty(String string, Hashtable hashtable) {
        String string2 = "";
        String string3 = "";
        int n = string.indexOf(SM_EMS_KEY_EQUALS);
        String string4 = ";range=";
        int n2 = string.indexOf(string4);
        if (n2 != -1) {
            n = string.indexOf(SM_EMS_KEY_EQUALS, n + 1);
        }
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + SM_EMS_KEY_EQUALS.length());
        }
        if (string2.startsWith("<object#")) {
            String string5 = string3;
            Hashtable hashtable2 = new Hashtable();
            this.m_properties.put(string5, hashtable2);
            return hashtable2;
        }
        hashtable.put(string2, string3);
        return hashtable;
    }

    public StringBuffer encodeCommand(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(512);
        if (string.length() > 0) {
            stringBuffer.append(SM_EMS_KEY_SESSIONSPEC);
            stringBuffer.append(string);
            stringBuffer.append(SM_EMS_KEY_END);
        }
        if (this.m_szDirOid.length() > 0) {
            stringBuffer.append(SM_EMS_KEY_DIROID);
            stringBuffer.append(this.m_szDirOid);
            stringBuffer.append(SM_EMS_KEY_END);
        }
        if (this.m_szDn.length() > 0) {
            stringBuffer.append(SM_EMS_KEY_DN);
            stringBuffer.append(this.m_szDn);
            stringBuffer.append(SM_EMS_KEY_END);
        }
        if (this.m_szOrganizationDn.length() > 0) {
            stringBuffer.append(SM_EMS_KEY_ORGDN);
            stringBuffer.append(this.m_szOrganizationDn);
            stringBuffer.append(SM_EMS_KEY_END);
        }
        if (this.m_szRealmOid.length() > 0) {
            stringBuffer.append(SM_EMS_KEY_REALMOID);
            stringBuffer.append(this.m_szRealmOid);
            stringBuffer.append(SM_EMS_KEY_END);
        }
        stringBuffer.append(SM_EMS_KEY_CLASSID);
        stringBuffer.append(this.m_nClassId);
        stringBuffer.append(SM_EMS_KEY_END);
        stringBuffer.append(SM_EMS_KEY_COMMAND);
        stringBuffer.append(string2);
        stringBuffer.append(SM_EMS_KEY_END);
        if (this.m_properties.size() > 0) {
            stringBuffer.append(SM_EMS_KEY_PARAMS);
            Enumeration enumeration = this.m_properties.keys();
            Enumeration enumeration2 = this.m_properties.elements();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Object v = enumeration2.nextElement();
                this.encodeProperty(stringBuffer, string3, v);
            }
            stringBuffer.append(SM_EMS_KEY_END);
        }
        return stringBuffer;
    }

    private void encodeProperty(StringBuffer stringBuffer, String string, Object object) {
        if (object instanceof SmProperty[]) {
            SmProperty[] smPropertyArray = (SmProperty[])object;
            for (int i = 0; i < smPropertyArray.length; ++i) {
                this.encodeProperty(stringBuffer, smPropertyArray[i].getName(), smPropertyArray[i].getValue());
                this.encodeProperty(stringBuffer, smPropertyArray[i].getName() + "_type", new Integer(smPropertyArray[i].getType()));
            }
        } else {
            stringBuffer.append(SM_EMS_KEY_START);
            stringBuffer.append(string);
            stringBuffer.append(SM_EMS_KEY_EQUALS);
            stringBuffer.append(this.objToString(object));
            stringBuffer.append(SM_EMS_KEY_END);
        }
    }

    public static void copyProperty(Hashtable hashtable, Hashtable hashtable2) {
        hashtable2.clear();
        if (hashtable.size() < 1) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            hashtable2.put(enumeration.nextElement(), enumeration2.nextElement());
        }
    }

    public void readProperties(Hashtable hashtable) {
        SmApiObject.copyProperty(hashtable, this.m_properties);
    }

    public void writeProperties(Hashtable hashtable) {
        SmApiObject.copyProperty(this.m_properties, hashtable);
    }

    public void getPropsFromSepartor(Hashtable hashtable) {
        hashtable.clear();
        if (this.m_properties.size() < 1) {
            return;
        }
        Enumeration enumeration = this.m_properties.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = "";
            String string3 = "";
            int n = string.indexOf(SM_EMS_KEY_SEPARATOR);
            if (n == -1) continue;
            string2 = string.substring(0, n);
            string3 = string.substring(n + SM_EMS_KEY_SEPARATOR.length());
            hashtable.put(string2, string3);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        if (this.m_szDirOid.length() > 0) {
            stringBuffer.append(SM_EMS_KEY_DIROID);
            stringBuffer.append(this.m_szDirOid);
            stringBuffer.append(SM_EMS_KEY_END);
        }
        if (this.m_szDn.length() > 0) {
            stringBuffer.append(SM_EMS_KEY_DN);
            stringBuffer.append(this.m_szDn);
            stringBuffer.append(SM_EMS_KEY_END);
        }
        if (this.m_szOrganizationDn.length() > 0) {
            stringBuffer.append(SM_EMS_KEY_ORGDN);
            stringBuffer.append(this.m_szOrganizationDn);
            stringBuffer.append(SM_EMS_KEY_END);
        }
        if (this.m_szRealmOid.length() > 0) {
            stringBuffer.append(SM_EMS_KEY_REALMOID);
            stringBuffer.append(this.m_szRealmOid);
            stringBuffer.append(SM_EMS_KEY_END);
        }
        Enumeration enumeration = this.m_properties.keys();
        Enumeration enumeration2 = this.m_properties.elements();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            string = string.trim().toLowerCase();
            Object v = enumeration2.nextElement();
            if (string.compareTo("password") == 0 || string.compareTo("key") == 0 || string.compareTo("secret") == 0 || string.compareTo("oldpassword") == 0 || string.compareTo("userpassword") == 0 || string.compareTo(this.m_szPasswordAttr) == 0 || string.compareTo(this.m_szPasswordAttr.toLowerCase()) == 0) {
                stringBuffer.append(SM_EMS_KEY_START);
                stringBuffer.append(string);
                stringBuffer.append(SM_EMS_KEY_EQUALS);
                stringBuffer.append("** Not Shown **");
                stringBuffer.append(SM_EMS_KEY_END);
                continue;
            }
            this.encodeProperty(stringBuffer, string, v);
        }
        return stringBuffer.substring(0);
    }

    String objToString(Object object) {
        String string = null;
        string = object.getClass().isArray() ? this.arrayToString(object) : (object instanceof Vector ? this.vectorToString((Vector)object) : (object instanceof Enumeration ? this.enumerationToString((Enumeration)object) : (object instanceof Hashtable ? this.hashtableToString((Hashtable)object) : object.toString())));
        return string;
    }

    public String vectorToString(Vector vector) {
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            if (i > 0) {
                string = string + MULTI_ATTR_SEPARATOR;
            }
            string = string + vector.elementAt(i).toString();
        }
        return string;
    }

    public String enumerationToString(Enumeration enumeration) {
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(MULTI_ATTR_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public Vector stringToVector(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, MULTI_ATTR_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String arrayToString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(SEPARATOR_COMMA);
                    }
                    stringBuffer.append(nArray[i]);
                }
                return stringBuffer.toString();
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(SEPARATOR_COMMA);
                    }
                    stringBuffer.append(byArray[i]);
                }
                return stringBuffer.toString();
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(SEPARATOR_COMMA);
                    }
                    stringBuffer.append(lArray[i]);
                }
                return stringBuffer.toString();
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(SEPARATOR_COMMA);
                    }
                    stringBuffer.append(fArray[i]);
                }
                return stringBuffer.toString();
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(SEPARATOR_COMMA);
                    }
                    stringBuffer.append(dArray[i]);
                }
                return stringBuffer.toString();
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(SEPARATOR_COMMA);
                    }
                    stringBuffer.append(sArray[i]);
                }
                return stringBuffer.toString();
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                for (int i = 0; i < cArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(SEPARATOR_COMMA);
                    }
                    stringBuffer.append(cArray[i]);
                }
                return stringBuffer.toString();
            } else {
                if (clazz != Boolean.TYPE) throw new InternalError();
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(SEPARATOR_COMMA);
                    }
                    stringBuffer.append(blArray[i]);
                }
            }
            return stringBuffer.toString();
        } else {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(SEPARATOR_COMMA);
                }
                stringBuffer.append(this.objToString(objectArray[i]));
            }
        }
        return stringBuffer.toString();
    }

    public String hashtableToString(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            stringBuffer.append(k.toString());
            stringBuffer.append(SM_EMS_KEY_EQUALS);
            stringBuffer.append(hashtable.get(k).toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(SEPARATOR_COMMA);
        }
        return stringBuffer.toString();
    }
}

