/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.tunnel;

import com.ca.siteminder.rpc.tunnel.Registration;
import com.ca.siteminder.rpc.tunnel.XpsHostConfig;
import com.ca.siteminder.rpcutil.BeanUtil;
import com.ca.siteminder.rpcutil.CommandLineOptions;
import com.ca.smi18n.Smi18n;
import com.ca.smi18n.Xlate;
import java.io.File;

public class ReportServerRegistration {
    private static Xlate xlate = new Xlate("com.ca.siteminder.analyzer.smanalyzerBundle", Smi18n.SmGetAdminLocale());
    public String pshost;
    public int psport = 0;
    public String client;
    public String passphrase;
    public int fipsmode = 0;
    public String dir = ".";
    public boolean debug = false;
    static CommandLineOptions opts = new CommandLineOptions("regreportserver");

    public static void main(String[] stringArray) {
        xlate.printMessageToConsole(xlate.translate("SM-ALY-02001"));
        ReportServerRegistration reportServerRegistration = new ReportServerRegistration();
        boolean bl = opts.process(stringArray, (Object)reportServerRegistration);
        if (!bl) {
            return;
        }
        bl = ReportServerRegistration.checkDir(reportServerRegistration.dir);
        if (!bl) {
            return;
        }
        if (reportServerRegistration.debug) {
            BeanUtil.printFields((Object)reportServerRegistration);
        }
        if (reportServerRegistration.fipsmode < 0 || reportServerRegistration.fipsmode > 1) {
            xlate.printMessageToConsole("fipsmode=" + reportServerRegistration.fipsmode + xlate.translate("SM-ALY-02006"));
            return;
        }
        try {
            XpsHostConfig xpsHostConfig = Registration.run(reportServerRegistration.fipsmode, reportServerRegistration.pshost, reportServerRegistration.psport, "siteminder", reportServerRegistration.client, reportServerRegistration.passphrase);
            xpsHostConfig.saveToDir(reportServerRegistration.dir);
            xlate.printMessageToConsole(xlate.translate("SM-ALY-02010"));
        }
        catch (Exception exception) {
            xlate.printMessageToConsole(xlate.translate("SM-ALY-02007") + exception.getLocalizedMessage());
        }
    }

    static boolean checkDir(String string) {
        try {
            File file = new File(string);
            String string2 = file.getAbsolutePath();
            boolean bl = false;
            if (!file.exists()) {
                bl = file.mkdirs();
                if (!bl) {
                    throw new RuntimeException(xlate.translate("SM-ALY-02008") + string2);
                }
            } else if (!file.isDirectory()) {
                throw new RuntimeException(xlate.translate("SM-ALY-02009") + string2);
            }
            return true;
        }
        catch (Exception exception) {
            xlate.printMessageToConsole(exception.getMessage());
            return false;
        }
    }

    static {
        opts.addRequired("-pshost", xlate.translate("SM-ALY-02000"));
        opts.addOptional("-psport", xlate.translate("SM-ALY-02002"));
        opts.addRequired("-client", xlate.translate("SM-ALY-02003"));
        opts.addRequired("-passphrase", xlate.translate("SM-ALY-02004"));
        opts.addSwitch("-fipsmode", "1", xlate.translate("SM-ALY-02005"));
        opts.addOptional("-dir", null);
        opts.addSwitch("-debug", "true", null);
    }
}

