/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.analyzer.jdbc;

import com.ca.siteminder.analyzer.Analyzer;
import com.ca.siteminder.analyzer.Parameters;
import com.ca.siteminder.analyzer.RecordIterator;
import com.ca.siteminder.analyzer.jdbc.IteratorResultSet;
import com.ca.siteminder.analyzer.jdbc.POJOResultSetFactory;
import com.ca.siteminder.analyzer.jdbc.POJOResultSetMetaData;
import com.ca.siteminder.analyzer.rec.AgentRec;
import com.ca.siteminder.analyzer.rec.ApplObjRec;
import com.ca.siteminder.analyzer.rec.AuthSchemeRec;
import com.ca.siteminder.analyzer.rec.EpmApplRec;
import com.ca.siteminder.analyzer.rec.ObjRec;
import com.ca.siteminder.analyzer.rec.ProtectedResourcesRec;
import com.ca.siteminder.analyzer.rec.ResourceAuthSchemeRec;
import com.ca.siteminder.analyzer.rec.ResourceGroupRec;
import com.ca.siteminder.analyzer.rec.ResourceRec;
import com.ca.siteminder.analyzer.rec.ResourceUsersRec;
import com.ca.siteminder.analyzer.rec.RolePolicyRec;
import com.ca.siteminder.analyzer.rec.RoleRec;
import com.ca.siteminder.analyzer.rec.RoleResourceRec;
import com.ca.siteminder.analyzer.rec.RoleUserRec;
import com.ca.siteminder.analyzer.rec.UserApplicationRec;
import com.ca.siteminder.analyzer.rec.UserDNRec;
import com.ca.siteminder.analyzer.rec.UserDirRec;
import com.ca.siteminder.analyzer.rec.UserResourcesRec;
import com.ca.siteminder.analyzer.rec.UserRolesRec;
import com.ca.siteminder.rpc.tunnel.XpsHostConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolicyAnalyzerDataSource {
    public Analyzer analyzer;
    private static Map metadataCache = new HashMap();

    public ResultSet generateAgents(String string) {
        this.connect();
        Parameters parameters = this.analyzer.paramAgents(string);
        return this.getResultSet(parameters, AgentRec.class);
    }

    public ResultSet generateApplicationRoles(List list) {
        this.connect();
        Parameters parameters = this.analyzer.paramApplicationRoles(list);
        return this.getResultSet(parameters, RoleRec.class);
    }

    public ResultSet generateApplications(String string, Integer n) {
        this.connect();
        Parameters parameters = this.analyzer.paramApplications(string, n);
        return this.getResultSet(parameters, ObjRec.class);
    }

    public ResultSet generateAuthSchemes(Integer n, List list) {
        this.connect();
        Parameters parameters = this.analyzer.paramAuthSchemes(n, list);
        return this.getResultSet(parameters, AuthSchemeRec.class);
    }

    public ResultSet generateDomainUserdirs(Integer n, List list, List list2) {
        this.connect();
        Parameters parameters = this.analyzer.paramDomainUserdirs(n, list, list2);
        return this.getResultSet(parameters, ApplObjRec.class);
    }

    public ResultSet generateEpmApplications(String string, List list) {
        this.connect();
        Parameters parameters = this.analyzer.paramEpmApplications(string, list);
        return this.getResultSet(parameters, EpmApplRec.class);
    }

    public ResultSet generateProtectedResources(Boolean bl, String string, Integer n, List list) {
        this.connect();
        Parameters parameters = this.analyzer.paramProtectedResources(bl, string, n, list);
        return this.getResultSet(parameters, ProtectedResourcesRec.class);
    }

    public ResultSet generateResourceGroup(String string, Integer n, Boolean bl, List list, List list2, List list3) {
        this.connect();
        Parameters parameters = this.analyzer.paramResourceGroup(string, n, bl, list, list2, list3);
        return this.getResultSet(parameters, ResourceGroupRec.class);
    }

    public ResultSet generateResourcePolicies(String string, Integer n, List list) {
        this.connect();
        Parameters parameters = this.analyzer.paramResourcePolicies(string, n, list);
        return this.getResultSet(parameters, ResourceRec.class);
    }

    public ResultSet generateResourceRoles(String string, Boolean bl, List list, List list2, List list3, List list4) {
        this.connect();
        Parameters parameters = this.analyzer.paramResourceRoles(string, bl, list, list2, list3, list4);
        return this.getResultSet(parameters, RoleResourceRec.class);
    }

    public ResultSet generateResourceSchemes(String string, Integer n, Boolean bl, List list, List list2, List list3) {
        this.connect();
        Parameters parameters = this.analyzer.paramResourceSchemes(string, n, bl, list, list2, list3);
        return this.getResultSet(parameters, ResourceAuthSchemeRec.class);
    }

    public ResultSet generateResourceUsers(String string, String string2, Integer n, Integer n2, Boolean bl, List list, List list2, List list3, List list4) {
        this.connect();
        Parameters parameters = this.analyzer.paramResourceUsers(string, string2, n, n2, bl, list, list2, list3, list4);
        return this.getResultSet(parameters, ResourceUsersRec.class);
    }

    public ResultSet generateRolePolicies(List list, List list2) {
        this.connect();
        Parameters parameters = this.analyzer.paramRolePolicies(list, list2);
        return this.getResultSet(parameters, RolePolicyRec.class);
    }

    public ResultSet generateRoleResources(List list, List list2) {
        this.connect();
        Parameters parameters = this.analyzer.paramRoleResources(list, list2);
        return this.getResultSet(parameters, RoleResourceRec.class);
    }

    public ResultSet generateRoleUsers(String string, List list, List list2, List list3) {
        this.connect();
        Parameters parameters = this.analyzer.paramRoleUsers(string, list, list2, list3);
        return this.getResultSet(parameters, RoleUserRec.class);
    }

    public ResultSet generateSchemeResources(String string, Integer n, List list, List list2) {
        this.connect();
        Parameters parameters = this.analyzer.paramSchemeResources(string, n, list, list2);
        return this.getResultSet(parameters, ResourceAuthSchemeRec.class);
    }

    public ResultSet generateUserApplications(Integer n, List list, List list2, List list3) {
        this.connect();
        Parameters parameters = this.analyzer.paramUserApplications(n, list, list2, list3);
        return this.getResultSet(parameters, UserApplicationRec.class);
    }

    public ResultSet generateUserDir(String string, Integer n, List list) {
        this.connect();
        Parameters parameters = this.analyzer.paramUserDir(string, n, list);
        return this.getResultSet(parameters, UserDirRec.class);
    }

    public ResultSet generateUserDn(String string, Integer n, List list, List list2) {
        this.connect();
        Parameters parameters = this.analyzer.paramUserDn(string, n, list, list2);
        return this.getResultSet(parameters, UserDNRec.class);
    }

    public ResultSet generateUserResources(Integer n, List list, List list2, List list3) {
        this.connect();
        Parameters parameters = this.analyzer.paramUserResources(n, list, list2, list3);
        return this.getResultSet(parameters, UserResourcesRec.class);
    }

    public ResultSet generateUserRoles(List list, List list2, List list3, List list4) {
        this.connect();
        Parameters parameters = this.analyzer.paramUserRoles(list, list2, list3, list4);
        return this.getResultSet(parameters, UserRolesRec.class);
    }

    public ResultSet generateResourceGroup(String string, Integer n, List list, List list2, List list3) {
        return this.generateResourceGroup(string, n, Boolean.TRUE, list, list2, list3);
    }

    public ResultSet generateResourceRoles(String string, List list, List list2, List list3, List list4) {
        return this.generateResourceRoles(string, Boolean.TRUE, list, list2, list3, list4);
    }

    public ResultSet generateResourceSchemes(String string, Integer n, List list, List list2, List list3) {
        return this.generateResourceSchemes(string, n, Boolean.TRUE, list, list2, list3);
    }

    public ResultSet generateResourceUsers(String string, String string2, Integer n, Integer n2, List list, List list2, List list3, List list4) {
        return this.generateResourceUsers(string, string2, n, n2, Boolean.TRUE, list, list2, list3, list4);
    }

    public boolean connect(String string, String string2, String string3, int n) {
        this.analyzer = new Analyzer(string3, n, string, string2);
        return true;
    }

    private void connect() {
        if (this.analyzer == null) {
            this.analyzer = new Analyzer();
        }
    }

    public boolean connect5(int n, String string, int n2, String string2, String string3, String string4) {
        this.analyzer = new Analyzer(n, string, n2, string2, string3, string4);
        return true;
    }

    private ResultSet getResultSet(Parameters parameters, Class clazz) {
        POJOResultSetMetaData pOJOResultSetMetaData = (POJOResultSetMetaData)metadataCache.get(clazz);
        if (pOJOResultSetMetaData == null) {
            pOJOResultSetMetaData = PolicyAnalyzerDataSource.addMetaData(clazz);
        }
        RecordIterator recordIterator = this.analyzer.streamQuery(parameters);
        return new IteratorResultSet(pOJOResultSetMetaData, recordIterator);
    }

    private static POJOResultSetMetaData addMetaData(Class clazz) {
        POJOResultSetFactory pOJOResultSetFactory = new POJOResultSetFactory(clazz);
        pOJOResultSetFactory.setVerbose(true);
        POJOResultSetMetaData pOJOResultSetMetaData = pOJOResultSetFactory.getMetaData();
        metadataCache.put(clazz, pOJOResultSetMetaData);
        return pOJOResultSetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        PolicyAnalyzerDataSource policyAnalyzerDataSource = new PolicyAnalyzerDataSource();
        String string = "XpsHost.properties";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        XpsHostConfig xpsHostConfig = XpsHostConfig.restore(string);
        String string2 = xpsHostConfig.getPsIp();
        int n = xpsHostConfig.getPort();
        String string3 = xpsHostConfig.getUserPath();
        String string4 = xpsHostConfig.getTrustedHost();
        String string5 = xpsHostConfig.getSecret();
        int n2 = xpsHostConfig.getFIPS();
        policyAnalyzerDataSource.connect5(n2, string2, n, string3, string4, string5);
        try {
            PolicyAnalyzerDataSource.printResultSet("agents", policyAnalyzerDataSource.generateAgents("*"));
            PolicyAnalyzerDataSource.printResultSet("application roles", policyAnalyzerDataSource.generateApplicationRoles(null));
            PolicyAnalyzerDataSource.printResultSet("applications", policyAnalyzerDataSource.generateApplications(null, null));
            PolicyAnalyzerDataSource.printResultSet("auth schemes", policyAnalyzerDataSource.generateAuthSchemes(null, null));
            PolicyAnalyzerDataSource.printResultSet("epm apps", policyAnalyzerDataSource.generateEpmApplications(null, null));
            PolicyAnalyzerDataSource.printResultSet("generateRolePolicies", policyAnalyzerDataSource.generateRolePolicies(null, null));
            PolicyAnalyzerDataSource.printResultSet("protected resources", policyAnalyzerDataSource.generateProtectedResources(null, null, null, null));
            PolicyAnalyzerDataSource.printResultSet("user dn", policyAnalyzerDataSource.generateUserDn(null, null, null, null));
            PolicyAnalyzerDataSource.printResultSet("user roles", policyAnalyzerDataSource.generateUserRoles(null, null, null, null));
            List list = policyAnalyzerDataSource.analyzer.listProtectedResources(null, null, null, null);
            if (list.size() > 0) {
                ProtectedResourcesRec protectedResourcesRec = (ProtectedResourcesRec)list.get(0);
                String string6 = protectedResourcesRec.getResource();
                PolicyAnalyzerDataSource.printResultSet("generateResourcePolicies", policyAnalyzerDataSource.generateResourcePolicies(string6, null, null));
                PolicyAnalyzerDataSource.printResultSet("generateResourceRoles", policyAnalyzerDataSource.generateResourceRoles(string6, null, null, null, null));
                PolicyAnalyzerDataSource.printResultSet("generateResourceSchemes", policyAnalyzerDataSource.generateResourceSchemes(string6, null, null, null, null));
            }
        }
        finally {
            if (policyAnalyzerDataSource.analyzer != null) {
                policyAnalyzerDataSource.analyzer.disconnect();
            }
        }
    }

    static void printResultSet(String string, ResultSet resultSet) throws SQLException {
        System.out.println("\n*** " + string);
        int n = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            for (int i = 1; i <= n; ++i) {
                Object object = resultSet.getObject(i);
                if (i > 1) {
                    System.out.print('\t');
                }
                System.out.print(object);
            }
            System.out.println();
        }
    }
}

