/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.analyzer.jdbc;

import com.ca.siteminder.analyzer.jdbc.POJOResultSetColumn;
import com.ca.siteminder.analyzer.jdbc.POJOResultSetFactory;
import com.ca.smi18n.Smi18n;
import com.ca.smi18n.Xlate;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class POJOResultSetMetaData
implements ResultSetMetaData {
    private static Xlate xlate = new Xlate("com.ca.siteminder.analyzer.smanalyzerBundle", Smi18n.SmGetAdminLocale());
    private final POJOResultSetFactory factory;
    private final List pojoColumns;

    public POJOResultSetMetaData(POJOResultSetFactory pOJOResultSetFactory, List list) {
        this.factory = pOJOResultSetFactory;
        this.pojoColumns = list;
    }

    public Class domainClass() {
        return this.factory.domainClass();
    }

    public String domainClassName() {
        return POJOResultSetFactory.simpleNameOf(this.domainClass());
    }

    public POJOResultSetColumn columnAt(int n) throws SQLException {
        if (1 <= n && n <= this.getColumnCount()) {
            int n2 = n - 1;
            return (POJOResultSetColumn)this.pojoColumns.get(n2);
        }
        throw new SQLException(xlate.translate("SM-ALY-02053") + n);
    }

    public int findColumn(String string) throws SQLException {
        int n = -1;
        if (string != null) {
            for (int i = 0; i < this.pojoColumns.size(); ++i) {
                POJOResultSetColumn pOJOResultSetColumn = (POJOResultSetColumn)this.pojoColumns.get(i);
                if (!string.equalsIgnoreCase(pOJOResultSetColumn.name())) continue;
                n = i + 1;
                break;
            }
        }
        if (n < 0) {
            String string2 = xlate.formatMessage("SM-ALY-02054", new Object[]{string, this.domainClassName()});
            throw new SQLException(string2);
        }
        return n;
    }

    public POJOResultSetColumn columnWith(String string) throws SQLException {
        return this.columnAt(this.findColumn(string));
    }

    public int getColumnCount() {
        return this.pojoColumns.size();
    }

    public boolean isAutoIncrement(int n) {
        return false;
    }

    public boolean isCaseSensitive(int n) {
        return true;
    }

    public boolean isSearchable(int n) {
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        return this.columnAt(n).isCurrency();
    }

    public int isNullable(int n) throws SQLException {
        Class clazz = this.columnAt(n).memberType();
        return clazz.isPrimitive() ? 0 : 1;
    }

    public boolean isSigned(int n) throws SQLException {
        return POJOResultSetFactory.isNumberType(this.columnAt(n).memberType());
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return this.columnAt(n).displaySize();
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.columnAt(n).label();
    }

    public String getColumnName(int n) throws SQLException {
        return this.columnAt(n).name();
    }

    public String getSchemaName(int n) {
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        return this.columnAt(n).precision();
    }

    public int getScale(int n) throws SQLException {
        return this.columnAt(n).scale();
    }

    public String getTableName(int n) {
        return this.factory.getTableName();
    }

    public String getCatalogName(int n) {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        return this.columnAt(n).sqlType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.getColumnClassName(n);
    }

    public boolean isReadOnly(int n) {
        return true;
    }

    public boolean isWritable(int n) {
        return false;
    }

    public boolean isDefinitelyWritable(int n) {
        return false;
    }

    public String getColumnClassName(int n) throws SQLException {
        return this.columnAt(n).memberType().getName();
    }
}

