/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.analyzer.jdbc;

import com.ca.siteminder.analyzer.jdbc.POJOException;
import com.ca.siteminder.analyzer.jdbc.POJOFieldColumn;
import com.ca.siteminder.analyzer.jdbc.POJOMethodColumn;
import com.ca.siteminder.analyzer.jdbc.POJOResultSet;
import com.ca.siteminder.analyzer.jdbc.POJOResultSetColumn;
import com.ca.siteminder.analyzer.jdbc.POJOResultSetMetaData;
import com.ca.smi18n.Smi18n;
import com.ca.smi18n.Xlate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class POJOResultSetFactory {
    private static Xlate xlate = new Xlate("com.ca.siteminder.analyzer.smanalyzerBundle", Smi18n.SmGetAdminLocale());
    private boolean verbose = false;
    private static final Class[] NUMBER_TYPES = new Class[]{Number.class, Integer.TYPE, Long.TYPE, Short.TYPE, Byte.TYPE, Float.TYPE, Double.TYPE};
    private static final Class[] FLOAT_TYPES = new Class[]{Float.TYPE, Float.class};
    private static final Class[] DOUBLE_TYPES = new Class[]{Double.TYPE, Double.class};
    private static final Class[] INT_TYPES = new Class[]{Integer.TYPE, Integer.class};
    private static final Class[] LONG_TYPES = new Class[]{Long.TYPE, Long.class};
    private static final Class[] SHORT_TYPES = new Class[]{Short.TYPE, Short.class};
    private static final Class[] BYTE_TYPES = new Class[]{Byte.TYPE, Byte.class};
    private static final Class[] BOOLEAN_TYPES = new Class[]{Boolean.TYPE, Boolean.class};
    private static final Class[] CHAR_TYPES = new Class[]{Character.TYPE, Character.class};
    private static final int NOT_A_REPORTABLE_TYPE = 2000;
    protected final Class domainClass;
    private String tableName;
    private String[] specifiedExplicitMembers;
    private String[] specifiedIncludedMembers;
    private String[] specifiedExcludedMembers;
    private String[] specifiedIncludedMethodPrefixes = new String[]{"get"};
    private Set ignoredBaseClasses = new HashSet();
    private Map columnNames = new HashMap();
    private Map columnLabels = new HashMap();
    private Set currencyColumns = new HashSet();
    private Map columnDisplaySize = new HashMap();
    private Map columnPrecision = new HashMap();
    private Map columnScale = new HashMap();

    public POJOResultSetFactory(Class clazz) {
        this.domainClass = clazz;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    private void info(String string) {
    }

    public Class domainClass() {
        return this.domainClass;
    }

    public POJOResultSetMetaData getMetaData() throws POJOException {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = this.getIncludedMethodPrefixes();
        String[] stringArray2 = this.getExplicitMembers();
        if (stringArray2 != null && stringArray2.length > 0) {
            this.processExplicitMembers(stringArray2, arrayList, stringArray);
        } else {
            String[] stringArray3 = this.getIncludedMembers();
            String[] stringArray4 = this.getExcludedMembers();
            this.processClass(this.domainClass, arrayList, stringArray, stringArray3, stringArray4);
        }
        if (arrayList.size() == 0) {
            throw new POJOException(xlate.translate("SM-ALY-02052"));
        }
        return new POJOResultSetMetaData(this, arrayList);
    }

    public POJOResultSet createResultSet(List list) throws POJOException {
        POJOResultSetMetaData pOJOResultSetMetaData = this.getMetaData();
        return new POJOResultSet(pOJOResultSetMetaData, list);
    }

    public POJOResultSet createResultSet(Object[] objectArray) throws POJOException {
        return this.createResultSet(Arrays.asList(objectArray));
    }

    public POJOResultSet createResultSet(Collection collection) throws POJOException {
        List list = collection instanceof List ? (List)collection : new ArrayList(collection);
        return this.createResultSet(list);
    }

    public boolean isReportable(Class clazz) {
        boolean bl = false;
        if (clazz != Void.TYPE && clazz != Class.class && POJOResultSetFactory.sqlTypeOf(clazz) != 2000) {
            bl = true;
        }
        return bl;
    }

    public static int sqlTypeOf(Class clazz) {
        return POJOResultSetFactory.isInt(clazz) ? 4 : (POJOResultSetFactory.isLong(clazz) ? -5 : (POJOResultSetFactory.isFloat(clazz) ? 6 : (POJOResultSetFactory.isDouble(clazz) ? 8 : (POJOResultSetFactory.isShort(clazz) ? 5 : (POJOResultSetFactory.isChar(clazz) ? 1 : (POJOResultSetFactory.isBoolean(clazz) ? 16 : (POJOResultSetFactory.isByte(clazz) ? -6 : (String.class.isAssignableFrom(clazz) ? 12 : (Timestamp.class.isAssignableFrom(clazz) ? 93 : (Time.class.isAssignableFrom(clazz) ? 92 : (Date.class.isAssignableFrom(clazz) ? 91 : (Array.class.isAssignableFrom(clazz) ? 2003 : (Blob.class.isAssignableFrom(clazz) ? 2004 : (Clob.class.isAssignableFrom(clazz) ? 2005 : (Ref.class.isAssignableFrom(clazz) ? 2006 : (Struct.class.isAssignableFrom(clazz) ? 2002 : (BigDecimal.class.isAssignableFrom(clazz) ? 3 : 2000)))))))))))))))));
    }

    public boolean isReportable(Method method) {
        int n = method.getModifiers();
        return Modifier.isPublic(n) && !Modifier.isStatic(n) && this.isReportable(method.getReturnType()) && method.getParameterTypes().length == 0;
    }

    public boolean isReportable(Field field) {
        int n = field.getModifiers();
        return Modifier.isPublic(n) && !Modifier.isStatic(n) && !Modifier.isFinal(n) && this.isReportable(field.getType());
    }

    public boolean shouldReport(Field field) {
        return true;
    }

    public boolean shouldReport(Method method, String[] stringArray) {
        String string;
        boolean bl = stringArray == null ? true : (string = this.stripMatchingPrefix(method, stringArray)) != null;
        return bl;
    }

    public String[] getExplicitMembers() {
        return this.specifiedExplicitMembers;
    }

    public void setExplicitMembers(String[] stringArray) {
        this.specifiedExplicitMembers = stringArray;
    }

    public String[] getIncludedMembers() {
        return this.specifiedIncludedMembers;
    }

    public void setIncludedMembers(String[] stringArray) {
        this.specifiedIncludedMembers = stringArray;
    }

    public String[] getExcludedMembers() {
        return this.specifiedExcludedMembers;
    }

    public void setExcludedMembers(String[] stringArray) {
        this.specifiedExcludedMembers = stringArray;
    }

    public String[] getIncludedMethodPrefixes() {
        return this.specifiedIncludedMethodPrefixes;
    }

    public void setIncludedMethodPrefixes(String[] stringArray) {
        this.specifiedIncludedMethodPrefixes = stringArray;
    }

    public boolean isIgnoringBaseClass(Class clazz) {
        return clazz == Object.class || this.ignoredBaseClasses.contains(clazz.getName());
    }

    public void ignoreBaseClass(String string) {
        this.ignoredBaseClasses.add(string);
    }

    public void ignoreBaseClass(Class clazz) {
        this.ignoreBaseClass(clazz.getName());
    }

    public String getTableName() {
        String string = this.tableName;
        if (string == null) {
            string = POJOResultSetFactory.simpleNameOf(this.domainClass);
        }
        return string;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String defaultColumnNameOf(Field field) {
        return field.getName();
    }

    public String defaultColumnNameOf(Method method, String[] stringArray) {
        String string = this.stripMatchingPrefix(method, stringArray);
        if (string == null) {
            string = method.getName();
        }
        return string;
    }

    public String getMemberColumnName(String string) {
        return (String)this.columnNames.get(string);
    }

    public void setMemberColumnName(String string, String string2) {
        POJOResultSetFactory.update(this.columnNames, string, string2);
    }

    public String getMemberColumnLabel(String string) {
        return (String)this.columnLabels.get(string);
    }

    public void setMemberColumnLabel(String string, String string2) {
        POJOResultSetFactory.update(this.columnLabels, string, string2);
    }

    public boolean isCurrencyMember(String string) {
        return this.currencyColumns.contains(string);
    }

    public void setCurrencyMember(String string, boolean bl) {
        if (bl) {
            this.currencyColumns.add(string);
        } else {
            this.currencyColumns.remove(string);
        }
    }

    public int getMemberColumnDisplaySize(String string, Class clazz) {
        int n = 100;
        Integer n2 = (Integer)this.columnDisplaySize.get(string);
        if (n2 != null) {
            n = n2;
        } else if (POJOResultSetFactory.isInt(clazz) || POJOResultSetFactory.isShort(clazz)) {
            n = 7;
        } else if (POJOResultSetFactory.isByte(clazz)) {
            n = 4;
        } else if (POJOResultSetFactory.isChar(clazz)) {
            n = 2;
        } else if (POJOResultSetFactory.isLong(clazz)) {
            n = 12;
        } else if (POJOResultSetFactory.isRealType(clazz)) {
            n = this.getMemberColumnPrecision(string, clazz) + 1;
        }
        return n;
    }

    public void setMemberColumnDisplaySize(String string, int n) {
        POJOResultSetFactory.update(this.columnDisplaySize, string, new Integer(n));
    }

    public int getMemberColumnPrecision(String string, Class clazz) {
        int n = 0;
        Integer n2 = (Integer)this.columnPrecision.get(string);
        if (n2 != null) {
            n = n2;
        } else if (POJOResultSetFactory.isRealType(clazz)) {
            n = 6;
        }
        return n;
    }

    public void setMemberColumnPrecision(String string, int n) {
        POJOResultSetFactory.update(this.columnPrecision, string, new Integer(n));
    }

    public int getMemberColumnScale(String string, Class clazz) {
        int n = 0;
        Integer n2 = (Integer)this.columnScale.get(string);
        if (n2 != null) {
            n = n2;
        } else if (POJOResultSetFactory.isRealType(clazz)) {
            n = 2;
        }
        return n;
    }

    public void setMemberColumnScale(String string, int n) {
        POJOResultSetFactory.update(this.columnScale, string, new Integer(n));
    }

    public static boolean isRealType(Class clazz) {
        return POJOResultSetFactory.isFloat(clazz) || POJOResultSetFactory.isDouble(clazz);
    }

    public static boolean isIntegerType(Class clazz) {
        return POJOResultSetFactory.isInt(clazz) || POJOResultSetFactory.isLong(clazz) || POJOResultSetFactory.isShort(clazz) || POJOResultSetFactory.isByte(clazz);
    }

    public static boolean isDouble(Class clazz) {
        return POJOResultSetFactory.isType(clazz, DOUBLE_TYPES);
    }

    public static boolean isFloat(Class clazz) {
        return POJOResultSetFactory.isType(clazz, FLOAT_TYPES);
    }

    public static boolean isNumberType(Class clazz) {
        return POJOResultSetFactory.isType(clazz, NUMBER_TYPES);
    }

    public static boolean isLong(Class clazz) {
        return POJOResultSetFactory.isType(clazz, LONG_TYPES);
    }

    public static boolean isByte(Class clazz) {
        return POJOResultSetFactory.isType(clazz, BYTE_TYPES);
    }

    public static boolean isShort(Class clazz) {
        return POJOResultSetFactory.isType(clazz, SHORT_TYPES);
    }

    public static boolean isInt(Class clazz) {
        return POJOResultSetFactory.isType(clazz, INT_TYPES);
    }

    public static boolean isChar(Class clazz) {
        return POJOResultSetFactory.isType(clazz, CHAR_TYPES);
    }

    public static boolean isType(Class clazz, Class[] classArray) {
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isBoolean(Class clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    private void processClass(Class clazz, List list, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (clazz != null) {
            Class<?> clazz2;
            int n;
            Object object;
            this.info("processing " + clazz.getName());
            if (clazz.isInterface()) {
                object = clazz.getInterfaces();
                for (n = 0; n < ((Class<?>[])object).length; ++n) {
                    clazz2 = object[n];
                    if (this.isIgnoringBaseClass(clazz2)) continue;
                    this.processClass(clazz2, list, stringArray, stringArray2, stringArray3);
                }
            } else {
                object = clazz.getSuperclass();
                if (object != null && !this.isIgnoringBaseClass((Class)object)) {
                    this.processClass((Class)object, list, stringArray, stringArray2, stringArray3);
                }
            }
            object = clazz.getDeclaredFields();
            for (n = 0; n < ((Class<?>[])object).length; ++n) {
                clazz2 = object[n];
                this.processField((Field)((Object)clazz2), list, stringArray, stringArray2, stringArray3);
            }
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                this.processMethod(method, list, stringArray, stringArray2, stringArray3);
            }
        }
    }

    private void processExplicitMembers(String[] stringArray, List list, String[] stringArray2) {
        this.info("processing " + this.domainClass.getName());
        if (stringArray != null) {
            Class[] classArray = new Class[]{};
            String[] stringArray3 = null;
            String[] stringArray4 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null || string.length() <= 0) continue;
                try {
                    Method method = this.domainClass.getMethod(string, classArray);
                    this.processMethod(method, list, stringArray2, stringArray3, stringArray4);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        Field field = this.domainClass.getField(string);
                        this.processField(field, list, stringArray2, stringArray3, stringArray4);
                        continue;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void processField(Field field, List list, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        String string = field.getName();
        if (this.isReportable(field) && !this.hasMember(string, list) && (this.hasName(string, stringArray2) || this.shouldReport(field) && !this.hasName(string, stringArray3))) {
            POJOFieldColumn pOJOFieldColumn = new POJOFieldColumn(field, this);
            list.add(pOJOFieldColumn);
            this.info("included field: " + string);
        }
    }

    private void processMethod(Method method, List list, final String[] stringArray, String[] stringArray2, String[] stringArray3) {
        String string = method.getName();
        if (this.isReportable(method) && !this.hasMember(string, list) && (this.hasName(string, stringArray2) || this.shouldReport(method, stringArray) && !this.hasName(string, stringArray3))) {
            POJOMethodColumn pOJOMethodColumn = new POJOMethodColumn(method, this){

                public String defaultColumnName() {
                    return this.factory.defaultColumnNameOf(this.method, stringArray);
                }
            };
            list.add(pOJOMethodColumn);
            this.info("included method: " + string);
        }
    }

    private String stripMatchingPrefix(Method method, String[] stringArray) {
        String string = null;
        if (stringArray != null) {
            String string2 = method.getName();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (!string2.startsWith(string3)) continue;
                string = string2.substring(string3.length());
                break;
            }
        }
        return string;
    }

    private boolean hasName(String string, String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean hasMember(String string, List list) {
        return this.columnWith(string, list) != null;
    }

    private POJOResultSetColumn columnWith(String string, List list) {
        POJOResultSetColumn pOJOResultSetColumn = null;
        for (int i = 0; i < list.size(); ++i) {
            POJOResultSetColumn pOJOResultSetColumn2 = (POJOResultSetColumn)list.get(i);
            if (!string.equals(pOJOResultSetColumn2.memberName())) continue;
            pOJOResultSetColumn = pOJOResultSetColumn2;
            break;
        }
        return pOJOResultSetColumn;
    }

    public static String simpleNameOf(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static void update(Map map, String string, Object object) {
        if (object == null) {
            map.remove(string);
        } else {
            map.put(string, object);
        }
    }
}

