/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.analyzer;

import com.ca.siteminder.analyzer.AnalyzerConstants;
import com.ca.siteminder.analyzer.Parameters;
import com.ca.siteminder.analyzer.QueryRunner;
import com.ca.siteminder.analyzer.RecordIterator;
import com.ca.siteminder.analyzer.Registry;
import com.ca.siteminder.analyzer.ReportConsumer;
import com.ca.siteminder.analyzer.ReportProducer;
import com.ca.siteminder.analyzer.rec.Record;
import com.ca.siteminder.rpc.output.PrintFormatter;
import com.ca.siteminder.rpc.rpc.ContextConstants;
import com.ca.siteminder.rpc.rpc.RpcContext;
import com.ca.siteminder.rpc.tunnel.XpsHostConfig;
import com.ca.siteminder.rpc.type.Formatter;
import com.ca.siteminder.rpc.type.TypeRegistry;
import com.ca.smi18n.Smi18n;
import com.ca.smi18n.Xlate;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Analyzer
implements ContextConstants,
AnalyzerConstants {
    private static Xlate xlate = new Xlate("com.ca.siteminder.analyzer.smanalyzerBundle", Smi18n.SmGetAdminLocale());
    Registry reg = Registry.getInstance();
    RpcContext ctx;
    public ReportProducer producer;
    boolean isConnected = false;
    private static final Logger logger = Logger.getLogger(Analyzer.class);

    public String importClasses() {
        return this.ctx.importClasses();
    }

    static Parameters load(String string) {
        Parameters parameters = new Parameters();
        parameters.load(string);
        return parameters;
    }

    public void finalize() {
        this.disconnect();
    }

    public boolean connect(Map map) {
        if (this.isConnected) {
            return false;
        }
        this.ctx = new RpcContext((TypeRegistry)this.reg, map);
        this.producer = (ReportProducer)this.ctx.lookup(ReportProducer.class);
        this.isConnected = true;
        return true;
    }

    public boolean connect(String string, int n, String string2, String string3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string == null) {
            hashMap.put("local", "true");
        } else {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException(unknownHostException);
            }
            String string4 = inetAddress.getHostAddress();
            xlate.printMessageToConsole(xlate.translate("SM-ALY-02033") + string + " " + string4);
            hashMap.put("PS_IP", string4);
            hashMap.put("adminId", string2);
            hashMap.put("adminPwd", string3);
            if (n > 0) {
                hashMap.put("PS_AUPORT", new Integer(n));
            }
        }
        return this.connect(hashMap);
    }

    public boolean connect5(int n, String string, int n2, String string2, String string3, String string4) {
        logger.info((Object)xlate.formatMessage("SM-ALY-02031", new Object[]{string3, string}));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            logger.error((Object)xlate.formatMessage("SM-ALY-02031", new Object[]{string3, string}));
            throw new RuntimeException(unknownHostException);
        }
        String string5 = inetAddress.getHostAddress();
        hashMap.put("PS_IP", string5);
        hashMap.put("agentName", string3);
        hashMap.put("agentSecret", string4);
        hashMap.put("userId", string2);
        if (n2 > 0) {
            hashMap.put("PS_AUPORT", new Integer(n2));
        }
        hashMap.put("PS_FIPS", new Integer(n));
        boolean bl = this.connect(hashMap);
        if (!bl) {
            logger.error((Object)xlate.formatMessage("SM-ALY-02031", new Object[]{string3, string}));
        }
        return bl;
    }

    public void disconnect() {
        if (this.isConnected) {
            if (this.ctx != null) {
                this.ctx.release();
                this.ctx = null;
            }
            this.isConnected = false;
        }
    }

    public Analyzer() {
        this("XpsHost.properties");
    }

    public Analyzer(String string) {
        this(XpsHostConfig.restore(string).toMap());
    }

    public Analyzer(Map map) {
        this.connect(map);
    }

    public Analyzer(String string, String string2, String string3) {
        this.connect(string, 0, string2, string3);
    }

    public Analyzer(String string, int n, String string2, String string3) {
        this.connect(string, n, string2, string3);
    }

    public Analyzer(int n, String string, int n2, String string2, String string3, String string4) {
        this.connect5(n, string, n2, string2, string3, string4);
    }

    public RecordIterator streamQuery(Parameters parameters) {
        QueryRunner queryRunner = new QueryRunner(this, parameters);
        queryRunner.start();
        return queryRunner.consumer;
    }

    public RecordIterator streamQuery(Parameters parameters, int n) {
        QueryRunner queryRunner = new QueryRunner(this, parameters, n);
        queryRunner.start();
        return queryRunner.consumer;
    }

    public void print(PrintFormatter printFormatter, Object object) {
        this.reg.format((Formatter)printFormatter, object);
    }

    public int run(ReportConsumer reportConsumer, Parameters parameters) {
        logger.info((Object)xlate.formatMessage("SM-ALY-02029", new Object[]{parameters.getReportName()}));
        this.ctx.setCallback((Object)reportConsumer);
        return this.producer.produce(parameters.props);
    }

    public int run(ReportConsumer reportConsumer, String string) {
        Parameters parameters = Analyzer.load(string);
        return this.run(reportConsumer, parameters);
    }

    public List run(Parameters parameters) {
        class ReportList
        implements ReportConsumer {
            List list = new ArrayList();

            ReportList() {
            }

            public void addRecord(Record record) {
                this.list.add(record);
            }

            public void setProgress(int n) {
            }
        }
        ReportList reportList = new ReportList();
        this.run((ReportConsumer)reportList, parameters);
        return reportList.list;
    }

    public List run(String string) {
        Parameters parameters = Analyzer.load(string);
        return this.run(parameters);
    }

    public Parameters paramAgents(String string) {
        if (string == null) {
            string = "*";
        }
        Parameters parameters = new Parameters("agents");
        parameters.addProperty("agent_pattern", string);
        return parameters;
    }

    public int consumeAgents(ReportConsumer reportConsumer, String string) {
        Parameters parameters = this.paramAgents(string);
        return this.run(reportConsumer, parameters);
    }

    public List listAgents(String string) {
        Parameters parameters = this.paramAgents(string);
        return this.run(parameters);
    }

    public Iterator iterAgents(String string) {
        Parameters parameters = this.paramAgents(string);
        return this.streamQuery(parameters);
    }

    public Parameters paramApplicationRoles(List list) {
        Parameters parameters = new Parameters("application_roles");
        parameters.addProperties("application", list);
        return parameters;
    }

    public int consumeApplicationRoles(ReportConsumer reportConsumer, List list) {
        Parameters parameters = this.paramApplicationRoles(list);
        return this.run(reportConsumer, parameters);
    }

    public List listApplicationRoles(List list) {
        Parameters parameters = this.paramApplicationRoles(list);
        return this.run(parameters);
    }

    public Iterator iterApplicationRoles(List list) {
        Parameters parameters = this.paramApplicationRoles(list);
        return this.streamQuery(parameters);
    }

    public Parameters paramApplications(String string, Integer n) {
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("applications");
        parameters.addProperty("application_filter", string);
        parameters.addProperty("domain_appl", n);
        return parameters;
    }

    public int consumeApplications(ReportConsumer reportConsumer, String string, Integer n) {
        Parameters parameters = this.paramApplications(string, n);
        return this.run(reportConsumer, parameters);
    }

    public List listApplications(String string, Integer n) {
        Parameters parameters = this.paramApplications(string, n);
        return this.run(parameters);
    }

    public Iterator iterApplications(String string, Integer n) {
        Parameters parameters = this.paramApplications(string, n);
        return this.streamQuery(parameters);
    }

    public Parameters paramAuthSchemes(Integer n, List list) {
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("auth_schemes");
        parameters.addProperty("domain_appl", n);
        parameters.addProperties("application", list);
        return parameters;
    }

    public int consumeAuthSchemes(ReportConsumer reportConsumer, Integer n, List list) {
        Parameters parameters = this.paramAuthSchemes(n, list);
        return this.run(reportConsumer, parameters);
    }

    public List listAuthSchemes(Integer n, List list) {
        Parameters parameters = this.paramAuthSchemes(n, list);
        return this.run(parameters);
    }

    public Iterator iterAuthSchemes(Integer n, List list) {
        Parameters parameters = this.paramAuthSchemes(n, list);
        return this.streamQuery(parameters);
    }

    public Parameters paramDomainUserdirs(Integer n, List list, List list2) {
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("domain_userdirs");
        parameters.addProperty("domain_appl", n);
        parameters.addProperties("user_dir", list);
        parameters.addProperties("application", list2);
        return parameters;
    }

    public int consumeDomainUserdirs(ReportConsumer reportConsumer, Integer n, List list, List list2) {
        Parameters parameters = this.paramDomainUserdirs(n, list, list2);
        return this.run(reportConsumer, parameters);
    }

    public List listDomainUserdirs(Integer n, List list, List list2) {
        Parameters parameters = this.paramDomainUserdirs(n, list, list2);
        return this.run(parameters);
    }

    public Iterator iterDomainUserdirs(Integer n, List list, List list2) {
        Parameters parameters = this.paramDomainUserdirs(n, list, list2);
        return this.streamQuery(parameters);
    }

    public Parameters paramEpmApplications(String string, List list) {
        Parameters parameters = new Parameters("epm_applications");
        parameters.addProperty("application_filter", string);
        parameters.addProperties("application", list);
        return parameters;
    }

    public int consumeEpmApplications(ReportConsumer reportConsumer, String string, List list) {
        Parameters parameters = this.paramEpmApplications(string, list);
        return this.run(reportConsumer, parameters);
    }

    public List listEpmApplications(String string, List list) {
        Parameters parameters = this.paramEpmApplications(string, list);
        return this.run(parameters);
    }

    public Iterator iterEpmApplications(String string, List list) {
        Parameters parameters = this.paramEpmApplications(string, list);
        return this.streamQuery(parameters);
    }

    public Parameters paramProtectedResources(Boolean bl, String string, Integer n, List list) {
        if (bl == null) {
            bl = new Boolean(false);
        }
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("protected_resources");
        parameters.addProperty("include_disabled", bl);
        parameters.addProperty("resource_filter", string);
        parameters.addProperty("domain_appl", n);
        parameters.addProperties("application", list);
        return parameters;
    }

    public int consumeProtectedResources(ReportConsumer reportConsumer, Boolean bl, String string, Integer n, List list) {
        Parameters parameters = this.paramProtectedResources(bl, string, n, list);
        return this.run(reportConsumer, parameters);
    }

    public List listProtectedResources(Boolean bl, String string, Integer n, List list) {
        Parameters parameters = this.paramProtectedResources(bl, string, n, list);
        return this.run(parameters);
    }

    public Iterator iterProtectedResources(Boolean bl, String string, Integer n, List list) {
        Parameters parameters = this.paramProtectedResources(bl, string, n, list);
        return this.streamQuery(parameters);
    }

    public Parameters paramResourceFilterUsers(String string, String string2, Integer n, Integer n2, Boolean bl, List list, List list2, List list3, List list4) {
        if (n == null) {
            n = new Integer(600);
        }
        if (n2 == null) {
            n2 = new Integer(2);
        }
        if (bl == null) {
            bl = new Boolean(false);
        }
        Parameters parameters = new Parameters("resource_filter_users");
        parameters.addProperty("resource_filter", string);
        parameters.addProperty("user_filter", string2);
        parameters.addProperty("timeout", n);
        parameters.addProperty("domain_appl", n2);
        parameters.addProperty("is_resource_filter", bl);
        parameters.addProperties("rule", list);
        parameters.addProperties("user_dir", list2);
        parameters.addProperties("application", list3);
        parameters.addProperties("agent", list4);
        return parameters;
    }

    public int consumeResourceFilterUsers(ReportConsumer reportConsumer, String string, String string2, Integer n, Integer n2, Boolean bl, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramResourceFilterUsers(string, string2, n, n2, bl, list, list2, list3, list4);
        return this.run(reportConsumer, parameters);
    }

    public List listResourceFilterUsers(String string, String string2, Integer n, Integer n2, Boolean bl, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramResourceFilterUsers(string, string2, n, n2, bl, list, list2, list3, list4);
        return this.run(parameters);
    }

    public Iterator iterResourceFilterUsers(String string, String string2, Integer n, Integer n2, Boolean bl, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramResourceFilterUsers(string, string2, n, n2, bl, list, list2, list3, list4);
        return this.streamQuery(parameters);
    }

    public Parameters paramResourceGroup(String string, Integer n, Boolean bl, List list, List list2, List list3) {
        if (n == null) {
            n = new Integer(2);
        }
        if (bl == null) {
            bl = new Boolean(false);
        }
        Parameters parameters = new Parameters("resource_group");
        parameters.addProperty("resource", string);
        parameters.addProperty("domain_appl", n);
        parameters.addProperty("is_resource_filter", bl);
        parameters.addProperties("rule", list);
        parameters.addProperties("application", list2);
        parameters.addProperties("agent", list3);
        return parameters;
    }

    public int consumeResourceGroup(ReportConsumer reportConsumer, String string, Integer n, Boolean bl, List list, List list2, List list3) {
        Parameters parameters = this.paramResourceGroup(string, n, bl, list, list2, list3);
        return this.run(reportConsumer, parameters);
    }

    public List listResourceGroup(String string, Integer n, Boolean bl, List list, List list2, List list3) {
        Parameters parameters = this.paramResourceGroup(string, n, bl, list, list2, list3);
        return this.run(parameters);
    }

    public Iterator iterResourceGroup(String string, Integer n, Boolean bl, List list, List list2, List list3) {
        Parameters parameters = this.paramResourceGroup(string, n, bl, list, list2, list3);
        return this.streamQuery(parameters);
    }

    public Parameters paramResourcePolicies(String string, Integer n, List list) {
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("resource_policies");
        parameters.addProperty("resource_filter", string);
        parameters.addProperty("domain_appl", n);
        parameters.addProperties("application", list);
        return parameters;
    }

    public int consumeResourcePolicies(ReportConsumer reportConsumer, String string, Integer n, List list) {
        Parameters parameters = this.paramResourcePolicies(string, n, list);
        return this.run(reportConsumer, parameters);
    }

    public List listResourcePolicies(String string, Integer n, List list) {
        Parameters parameters = this.paramResourcePolicies(string, n, list);
        return this.run(parameters);
    }

    public Iterator iterResourcePolicies(String string, Integer n, List list) {
        Parameters parameters = this.paramResourcePolicies(string, n, list);
        return this.streamQuery(parameters);
    }

    public Parameters paramResourceRoles(String string, Boolean bl, List list, List list2, List list3, List list4) {
        if (bl == null) {
            bl = new Boolean(false);
        }
        Parameters parameters = new Parameters("resource_roles");
        parameters.addProperty("resource", string);
        parameters.addProperty("is_resource_filter", bl);
        parameters.addProperties("rule", list);
        parameters.addProperties("role", list2);
        parameters.addProperties("application", list3);
        parameters.addProperties("agent", list4);
        return parameters;
    }

    public int consumeResourceRoles(ReportConsumer reportConsumer, String string, Boolean bl, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramResourceRoles(string, bl, list, list2, list3, list4);
        return this.run(reportConsumer, parameters);
    }

    public List listResourceRoles(String string, Boolean bl, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramResourceRoles(string, bl, list, list2, list3, list4);
        return this.run(parameters);
    }

    public Iterator iterResourceRoles(String string, Boolean bl, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramResourceRoles(string, bl, list, list2, list3, list4);
        return this.streamQuery(parameters);
    }

    public Parameters paramResourceSchemes(String string, Integer n, Boolean bl, List list, List list2, List list3) {
        if (n == null) {
            n = new Integer(2);
        }
        if (bl == null) {
            bl = new Boolean(false);
        }
        Parameters parameters = new Parameters("resource_schemes");
        parameters.addProperty("resource", string);
        parameters.addProperty("domain_appl", n);
        parameters.addProperty("is_resource_filter", bl);
        parameters.addProperties("rule", list);
        parameters.addProperties("application", list2);
        parameters.addProperties("agent", list3);
        return parameters;
    }

    public int consumeResourceSchemes(ReportConsumer reportConsumer, String string, Integer n, Boolean bl, List list, List list2, List list3) {
        Parameters parameters = this.paramResourceSchemes(string, n, bl, list, list2, list3);
        return this.run(reportConsumer, parameters);
    }

    public List listResourceSchemes(String string, Integer n, Boolean bl, List list, List list2, List list3) {
        Parameters parameters = this.paramResourceSchemes(string, n, bl, list, list2, list3);
        return this.run(parameters);
    }

    public Iterator iterResourceSchemes(String string, Integer n, Boolean bl, List list, List list2, List list3) {
        Parameters parameters = this.paramResourceSchemes(string, n, bl, list, list2, list3);
        return this.streamQuery(parameters);
    }

    public Parameters paramResourceUsers(String string, String string2, Integer n, Integer n2, Boolean bl, List list, List list2, List list3, List list4) {
        if (n == null) {
            n = new Integer(600);
        }
        if (n2 == null) {
            n2 = new Integer(2);
        }
        if (bl == null) {
            bl = new Boolean(false);
        }
        Parameters parameters = new Parameters("resource_users");
        parameters.addProperty("resource", string);
        parameters.addProperty("user_filter", string2);
        parameters.addProperty("timeout", n);
        parameters.addProperty("domain_appl", n2);
        parameters.addProperty("is_resource_filter", bl);
        parameters.addProperties("rule", list);
        parameters.addProperties("user_dir", list2);
        parameters.addProperties("application", list3);
        parameters.addProperties("agent", list4);
        return parameters;
    }

    public int consumeResourceUsers(ReportConsumer reportConsumer, String string, String string2, Integer n, Integer n2, Boolean bl, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramResourceUsers(string, string2, n, n2, bl, list, list2, list3, list4);
        return this.run(reportConsumer, parameters);
    }

    public List listResourceUsers(String string, String string2, Integer n, Integer n2, Boolean bl, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramResourceUsers(string, string2, n, n2, bl, list, list2, list3, list4);
        return this.run(parameters);
    }

    public Iterator iterResourceUsers(String string, String string2, Integer n, Integer n2, Boolean bl, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramResourceUsers(string, string2, n, n2, bl, list, list2, list3, list4);
        return this.streamQuery(parameters);
    }

    public Parameters paramRolePolicies(List list, List list2) {
        Parameters parameters = new Parameters("role_policies");
        parameters.addProperties("role", list);
        parameters.addProperties("application", list2);
        return parameters;
    }

    public int consumeRolePolicies(ReportConsumer reportConsumer, List list, List list2) {
        Parameters parameters = this.paramRolePolicies(list, list2);
        return this.run(reportConsumer, parameters);
    }

    public List listRolePolicies(List list, List list2) {
        Parameters parameters = this.paramRolePolicies(list, list2);
        return this.run(parameters);
    }

    public Iterator iterRolePolicies(List list, List list2) {
        Parameters parameters = this.paramRolePolicies(list, list2);
        return this.streamQuery(parameters);
    }

    public Parameters paramRoleResources(List list, List list2) {
        Parameters parameters = new Parameters("role_resources");
        parameters.addProperties("role", list);
        parameters.addProperties("application", list2);
        return parameters;
    }

    public int consumeRoleResources(ReportConsumer reportConsumer, List list, List list2) {
        Parameters parameters = this.paramRoleResources(list, list2);
        return this.run(reportConsumer, parameters);
    }

    public List listRoleResources(List list, List list2) {
        Parameters parameters = this.paramRoleResources(list, list2);
        return this.run(parameters);
    }

    public Iterator iterRoleResources(List list, List list2) {
        Parameters parameters = this.paramRoleResources(list, list2);
        return this.streamQuery(parameters);
    }

    public Parameters paramRoleUsers(String string, List list, List list2, List list3) {
        Parameters parameters = new Parameters("role_users");
        parameters.addProperty("user_filter", string);
        parameters.addProperties("role", list);
        parameters.addProperties("application", list2);
        parameters.addProperties("user_dir", list3);
        return parameters;
    }

    public int consumeRoleUsers(ReportConsumer reportConsumer, String string, List list, List list2, List list3) {
        Parameters parameters = this.paramRoleUsers(string, list, list2, list3);
        return this.run(reportConsumer, parameters);
    }

    public List listRoleUsers(String string, List list, List list2, List list3) {
        Parameters parameters = this.paramRoleUsers(string, list, list2, list3);
        return this.run(parameters);
    }

    public Iterator iterRoleUsers(String string, List list, List list2, List list3) {
        Parameters parameters = this.paramRoleUsers(string, list, list2, list3);
        return this.streamQuery(parameters);
    }

    public Parameters paramSchemeResources(String string, Integer n, List list, List list2) {
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("scheme_resources");
        parameters.addProperty("resource_filter", string);
        parameters.addProperty("domain_appl", n);
        parameters.addProperties("auth_scheme", list);
        parameters.addProperties("application", list2);
        return parameters;
    }

    public int consumeSchemeResources(ReportConsumer reportConsumer, String string, Integer n, List list, List list2) {
        Parameters parameters = this.paramSchemeResources(string, n, list, list2);
        return this.run(reportConsumer, parameters);
    }

    public List listSchemeResources(String string, Integer n, List list, List list2) {
        Parameters parameters = this.paramSchemeResources(string, n, list, list2);
        return this.run(parameters);
    }

    public Iterator iterSchemeResources(String string, Integer n, List list, List list2) {
        Parameters parameters = this.paramSchemeResources(string, n, list, list2);
        return this.streamQuery(parameters);
    }

    public Parameters paramUserApplications(Integer n, List list, List list2, List list3) {
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("user_applications");
        parameters.addProperty("domain_appl", n);
        parameters.addProperties("user_dn", list);
        parameters.addProperties("user_dir", list2);
        parameters.addProperties("application", list3);
        return parameters;
    }

    public int consumeUserApplications(ReportConsumer reportConsumer, Integer n, List list, List list2, List list3) {
        Parameters parameters = this.paramUserApplications(n, list, list2, list3);
        return this.run(reportConsumer, parameters);
    }

    public List listUserApplications(Integer n, List list, List list2, List list3) {
        Parameters parameters = this.paramUserApplications(n, list, list2, list3);
        return this.run(parameters);
    }

    public Iterator iterUserApplications(Integer n, List list, List list2, List list3) {
        Parameters parameters = this.paramUserApplications(n, list, list2, list3);
        return this.streamQuery(parameters);
    }

    public Parameters paramUserDir(String string, Integer n, List list) {
        if (string == null) {
            string = "*";
        }
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("user_dir");
        parameters.addProperty("user_dir_filter", string);
        parameters.addProperty("domain_appl", n);
        parameters.addProperties("application", list);
        return parameters;
    }

    public int consumeUserDir(ReportConsumer reportConsumer, String string, Integer n, List list) {
        Parameters parameters = this.paramUserDir(string, n, list);
        return this.run(reportConsumer, parameters);
    }

    public List listUserDir(String string, Integer n, List list) {
        Parameters parameters = this.paramUserDir(string, n, list);
        return this.run(parameters);
    }

    public Iterator iterUserDir(String string, Integer n, List list) {
        Parameters parameters = this.paramUserDir(string, n, list);
        return this.streamQuery(parameters);
    }

    public Parameters paramUserDn(String string, Integer n, List list, List list2) {
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("user_dn");
        parameters.addProperty("user_filter", string);
        parameters.addProperty("domain_appl", n);
        parameters.addProperties("user_dir", list);
        parameters.addProperties("application", list2);
        return parameters;
    }

    public int consumeUserDn(ReportConsumer reportConsumer, String string, Integer n, List list, List list2) {
        Parameters parameters = this.paramUserDn(string, n, list, list2);
        return this.run(reportConsumer, parameters);
    }

    public List listUserDn(String string, Integer n, List list, List list2) {
        Parameters parameters = this.paramUserDn(string, n, list, list2);
        return this.run(parameters);
    }

    public Iterator iterUserDn(String string, Integer n, List list, List list2) {
        Parameters parameters = this.paramUserDn(string, n, list, list2);
        return this.streamQuery(parameters);
    }

    public Parameters paramUserResources(Integer n, List list, List list2, List list3) {
        if (n == null) {
            n = new Integer(2);
        }
        Parameters parameters = new Parameters("user_resources");
        parameters.addProperty("domain_appl", n);
        parameters.addProperties("user_dn", list);
        parameters.addProperties("user_dir", list2);
        parameters.addProperties("application", list3);
        return parameters;
    }

    public int consumeUserResources(ReportConsumer reportConsumer, Integer n, List list, List list2, List list3) {
        Parameters parameters = this.paramUserResources(n, list, list2, list3);
        return this.run(reportConsumer, parameters);
    }

    public List listUserResources(Integer n, List list, List list2, List list3) {
        Parameters parameters = this.paramUserResources(n, list, list2, list3);
        return this.run(parameters);
    }

    public Iterator iterUserResources(Integer n, List list, List list2, List list3) {
        Parameters parameters = this.paramUserResources(n, list, list2, list3);
        return this.streamQuery(parameters);
    }

    public Parameters paramUserRoles(List list, List list2, List list3, List list4) {
        Parameters parameters = new Parameters("user_roles");
        parameters.addProperties("user_dn", list);
        parameters.addProperties("user_dir", list2);
        parameters.addProperties("application", list3);
        parameters.addProperties("role", list4);
        return parameters;
    }

    public int consumeUserRoles(ReportConsumer reportConsumer, List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramUserRoles(list, list2, list3, list4);
        return this.run(reportConsumer, parameters);
    }

    public List listUserRoles(List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramUserRoles(list, list2, list3, list4);
        return this.run(parameters);
    }

    public Iterator iterUserRoles(List list, List list2, List list3, List list4) {
        Parameters parameters = this.paramUserRoles(list, list2, list3, list4);
        return this.streamQuery(parameters);
    }
}

