/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.util;

import com.netegrity.util.DataItem;
import com.netegrity.util.DigestSha256;
import com.netegrity.util.Utils;
import java.security.MessageDigest;
import java.util.Arrays;

public class DeriveKey {
    public static byte[] Fips140(DerivationType type, int wanted, byte[] secret, int secretSize, byte[] contribA, int contribASize, byte[] contribB, int contribBSize, byte[] other, int otherSize) {
        if (wanted <= 0 || secretSize <= 0 || null == secret || secret.length < secretSize || DerivationType.FIPS140_TLIAES == type && secretSize < 4) {
            return new byte[0];
        }
        byte[] outBuf = new byte[wanted];
        byte[] tempBuf = null;
        try {
            DataItem[] theBuffers = new DataItem[7];
            int index = 0;
            int theCounter = 1;
            byte[] counter = new byte[]{0, 0, 0, 1};
            theBuffers[index++] = new DataItem(counter, 0, counter.length);
            theBuffers[index++] = new DataItem(secret, 0, secretSize);
            byte[] purpose = new byte[]{(byte)(type.toInt() & 0xFF), (byte)(type.toInt() >>> 8 & 0xFF)};
            theBuffers[index++] = new DataItem(purpose, 0, purpose.length);
            if (null != contribA && contribASize > 0 && contribA.length >= contribASize) {
                theBuffers[index++] = new DataItem(contribA, 0, contribASize);
            }
            if (null != contribB && contribBSize > 0 && contribB.length >= contribBSize) {
                theBuffers[index++] = new DataItem(contribB, 0, contribBSize);
            }
            if (null != other && otherSize > 0 && other.length >= otherSize) {
                theBuffers[index++] = new DataItem(other, 0, otherSize);
            }
            DigestSha256 digester = new DigestSha256();
            int fullBlocks = wanted / digester.getDigestSize();
            int residue = wanted - fullBlocks * digester.getDigestSize();
            int outOffset = 0;
            for (int iter = 0; iter < fullBlocks; ++iter) {
                int status = digester.getMultiDigest(theBuffers, outBuf, outOffset);
                if (status <= 0) {
                    Utils.Zeroize(outBuf);
                    outBuf = null;
                    return new byte[0];
                }
                outOffset += status;
                counter[0] = (byte)(++theCounter >>> 24 & 0xFF);
                counter[1] = (byte)(theCounter >>> 16 & 0xFF);
                counter[2] = (byte)(theCounter >>> 8 & 0xFF);
                counter[3] = (byte)(theCounter & 0xFF);
            }
            if (residue > 0) {
                tempBuf = new byte[digester.getDigestSize()];
                int status = digester.getMultiDigest(theBuffers, tempBuf, 0);
                if (status > residue) {
                    System.arraycopy(tempBuf, 0, outBuf, outOffset, residue);
                } else {
                    Utils.Zeroize(outBuf);
                    outBuf = new byte[]{};
                }
                Utils.Zeroize(tempBuf);
                tempBuf = null;
            }
        }
        catch (Throwable th) {
            Utils.Zeroize(outBuf);
            Utils.Zeroize(tempBuf);
            outBuf = new byte[]{};
        }
        return outBuf;
    }

    public static byte[] Fips140Expand(DerivationType type, int wanted, byte[] seed, int seedSize) {
        return DeriveKey.Fips140(type, wanted, seed, seedSize, null, 0, null, 0, null, 0);
    }

    public static byte[] Legacy(DerivationType type, int wanted, byte[] seed, int seedSize) {
        if (wanted <= 0 || seedSize <= 0 || null == seed || seed.length < seedSize || DerivationType.LEGACY_MD5 != type && DerivationType.LEGACY_SHA1 != type) {
            return new byte[0];
        }
        byte[] outBuf = null;
        boolean digestBufAllocated = false;
        byte[] digestBuf = null;
        MessageDigest md = null;
        try {
            int digestSize = 20;
            if (DerivationType.LEGACY_MD5 == type) {
                digestSize = 16;
                md = MessageDigest.getInstance("MD5");
            } else if (DerivationType.LEGACY_SHA1 == type) {
                md = MessageDigest.getInstance("SHA-1");
            }
            if (null == md) {
                return new byte[0];
            }
            outBuf = new byte[wanted];
            if (digestSize > wanted) {
                digestBuf = new byte[digestSize];
                digestBufAllocated = true;
            } else {
                digestBuf = outBuf;
                digestBufAllocated = false;
            }
            if (digestBufAllocated) {
                Utils.Zeroize(digestBuf);
                digestBuf = null;
                digestBufAllocated = false;
            }
        }
        catch (Throwable th) {
            outBuf = new byte[]{};
            th.printStackTrace();
        }
        if (null != md) {
            md.reset();
        }
        return outBuf;
    }

    private static void dumpBuf(String tag, byte[] buf) {
        System.out.println(tag + " had " + Utils.toHexString(buf));
    }

    public static void main(String[] args) {
        try {
            byte[] secret = new byte[]{115, 101, 99, 114, 101, 116, 32, 115, 101, 101, 100};
            byte[] expectBasic = new byte[]{-63, 60, -94, 107, -66, 63, -42, -21, 45, 55};
            byte[] basicKey = DeriveKey.Fips140Expand(DerivationType.FIPS140_EXPANDKEY, expectBasic.length, secret, secret.length);
            if (null == basicKey) {
                System.out.println("  could not derive basic key.");
            } else if (!Arrays.equals(expectBasic, basicKey)) {
                System.out.println("  basic key derivation result not as expected:");
                DeriveKey.dumpBuf("basic key", basicKey);
                DeriveKey.dumpBuf(" expected", expectBasic);
            } else {
                System.out.println("  basic key derivation test passed.");
            }
            byte[] contribA = new byte[]{99, 111, 110, 116, 114, 105, 98, 65};
            byte[] contribB = new byte[]{99, 111, 110, 116, 114, 105, 98, 66};
            byte[] other = new byte[]{111, 116, 104, 101, 114};
            byte[] expectLong = new byte[]{7, -21, 2, 68, 79, -36, 51, 123, -48, 33, 38, 127, 71, -35, 86, -78, -53, -35, 61, 51, -26, 71, 54, 124, -103, -109, 61, 61, -68, -29, -122, 72, 114, 11, -124, -97, -74, -42, -105, 46, 6, -51, 20, 83, 109, 98, -17, 31, 90, 30, 40, -114, 120, 76, 44, 34, -92, -13, 124, 16, -87, 78, 119, -20, 100, 75, 99, 21, 23, -121};
            byte[] longKey = DeriveKey.Fips140(DerivationType.FIPS140_TLIAES, expectLong.length, secret, secret.length, contribA, contribA.length, contribB, contribB.length, other, other.length);
            if (null == longKey) {
                System.out.println("  could not derive long key.");
            } else if (!Arrays.equals(expectLong, longKey)) {
                System.out.println("  long key derivation result not as expected:");
                DeriveKey.dumpBuf("long key", longKey);
                DeriveKey.dumpBuf("expected", expectLong);
            } else {
                System.out.println("  long key derivation test passed.");
            }
            byte[] interopSecret = new byte[]{102, 105, 114, 101, 119, 97, 108, 108};
            byte[] interopA = new byte[]{-15, -111, -65, 23, 17, 123, 57, -113, 59, 42, 59, 84, -76, 103, 75, -40};
            byte[] interopB = new byte[]{-3, -95, -69, 84, 73, 112, -90, 108, -36, -18, 29, -52, 76, -128, -103, 79};
            byte[] expectInterop = new byte[]{55, -66, 118, 1, 101, 56, -123, 0, -54, 107, 60, -59, 78, -127, 68, -24};
            byte[] interopKey = DeriveKey.Fips140(DerivationType.FIPS140_TLIAES, expectInterop.length, interopSecret, interopSecret.length, interopA, interopA.length, interopB, interopB.length, null, 0);
            if (null == interopKey) {
                System.out.println("  could not derive interop key.");
            } else if (!Arrays.equals(expectInterop, interopKey)) {
                System.out.println("  interop key derivation result not as expected:");
                DeriveKey.dumpBuf("interop key", interopKey);
                DeriveKey.dumpBuf(" expected", expectInterop);
            } else {
                System.out.println("  interop key derivation test passed.");
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static class DerivationType {
        private final String m_name;
        private final int m_ordinal;
        public static final DerivationType DERIVE_ANY = new DerivationType("any", 0);
        public static final DerivationType RISKY_COPY = new DerivationType("copy", 1);
        public static final DerivationType LEGACY_MD5 = new DerivationType("legacy_MD5", 2);
        public static final DerivationType LEGACY_SHA1 = new DerivationType("legacy_SHA1", 3);
        public static final DerivationType FIPS140_GENERAL = new DerivationType("general", 4);
        public static final DerivationType FIPS140_AGENTAPI = new DerivationType("AgentAPI", 5);
        public static final DerivationType FIPS140_AGENTHOSTKEY = new DerivationType("AgentHostKey", 6);
        public static final DerivationType FIPS140_AGENTKEYS = new DerivationType("AgentKeys", 7);
        public static final DerivationType FIPS140_EXPANDKEY = new DerivationType("expansion", 8);
        public static final DerivationType FIPS140_FRAMEWORKAGENT = new DerivationType("FrameworkAgent", 9);
        public static final DerivationType FIPS140_KEYSTORE = new DerivationType("KeyStore", 10);
        public static final DerivationType FIPS140_POLICYSTORE = new DerivationType("PolicyStore", 11);
        public static final DerivationType FIPS140_TEASIZE = new DerivationType("forTEA", 12);
        public static final DerivationType FIPS140_TLIAES = new DerivationType("for TliAes", 13);
        public static final DerivationType FIPS140_XPSEXPORT = new DerivationType("XpsExport", 14);

        private DerivationType(String name, int ordinal) {
            this.m_name = name;
            this.m_ordinal = ordinal;
        }

        public int toInt() {
            return this.m_ordinal;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

