/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.management;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnection;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagementException;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagementResult;
import com.ca.siteminder.sdk.agentapi.management.SmAgentInstanceDef;
import com.ca.siteminder.sdk.agentapi.resources.SmManagementMessages;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliPacket;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimerTask;

public class SmAgentInstance
extends TimerTask
implements SmAgentApiConstants {
    private static final String CLASS_NAME = "SmAgentInstance";
    private static final String MESSAGES_CLASSNAME = SmManagementMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private static final String QUOTE_STRING = "\"";
    private SmAgentApiConnection m_connection = null;
    private SmAgentInstanceDef m_agentInstanceDef = null;

    public SmAgentInstance(SmAgentApiConnection connection, SmAgentInstanceDef agentInstanceDef) {
        this.m_connection = connection;
        this.m_agentInstanceDef = agentInstanceDef;
    }

    String CreateGUID() {
        String strFullIpAddress = null;
        try {
            byte[] ipAddressByte = InetAddress.getLocalHost().getAddress();
            StringBuffer strIpAddress = new StringBuffer();
            for (int i2 = 0; i2 < ipAddressByte.length; ++i2) {
                int nIpAddressByte = 0xFF & ipAddressByte[i2];
                String tempAddress = Integer.toHexString(nIpAddressByte);
                if (tempAddress.length() < 2) {
                    tempAddress = "0" + tempAddress;
                }
                strIpAddress.append(tempAddress);
            }
            strFullIpAddress = this.Format(strIpAddress, 32);
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        Calendar cal = Calendar.getInstance();
        long lCurrentTime = cal.getTimeInMillis() / 65534L;
        SimpleDateFormat sdFormat = new SimpleDateFormat("SSSS");
        String strTime = sdFormat.format(cal.getTime());
        Random rand = new Random();
        String strRandomNumber1 = this.Format(new StringBuffer(String.valueOf(rand.nextInt(10000))), 4);
        String strRandomNumber2 = this.Format(new StringBuffer(String.valueOf(rand.nextInt(10000))), 4);
        String strRandomNumber3 = this.Format(new StringBuffer(String.valueOf(rand.nextInt(10000))), 4);
        String GUID = strFullIpAddress + "-" + strRandomNumber1 + "-" + String.valueOf(lCurrentTime) + "-" + strRandomNumber2 + "-" + strTime + strRandomNumber3;
        return GUID;
    }

    private String Format(StringBuffer strData, int Length) {
        StringBuffer strFullString = new StringBuffer();
        if (strData.length() < Length) {
            for (int i2 = 0; i2 < Length - strData.length(); ++i2) {
                strFullString.append(0);
            }
        }
        strFullString.append(strData);
        String strFinalString = strFullString.length() > Length ? strFullString.substring(0, Length) : strFullString.toString();
        return strFinalString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean readGUIDFromConfig(String strBufferGUID) {
        boolean result;
        block27: {
            String methodName = "readGUIDFromConfig";
            File configFile = new File(this.m_agentInstanceDef.getAgentIdFile());
            String absoluteName = configFile.getAbsolutePath();
            result = false;
            BufferedReader br = null;
            FileReader fr = null;
            if (!configFile.exists()) {
                if (strBufferGUID == null || strBufferGUID.trim().equals("")) {
                    if (this.writeGUIDIntoConfig(this.CreateGUID())) {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "readGUIDFromConfig", "Added GUID in config file: " + this.m_agentInstanceDef.getAgentGuid());
                        }
                        result = true;
                    } else if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "readGUIDFromConfig", "Unable to add GUID in config file: " + this.m_agentInstanceDef.getAgentGuid());
                    }
                    return result;
                }
            } else {
                if (!configFile.canRead()) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "readGUIDFromConfig", "Config file must be readable: " + absoluteName);
                    }
                    return result;
                }
                fr = new FileReader(configFile);
                br = new BufferedReader(fr);
                String strConfigData = null;
                while ((strConfigData = br.readLine()) != null) {
                    if (!strConfigData.trim().startsWith("GUID")) continue;
                    StringTokenizer strtok = new StringTokenizer(strConfigData, "=");
                    String strGuid = null;
                    while (strtok.hasMoreTokens()) {
                        strGuid = strtok.nextToken();
                    }
                    if (strGuid == null || strGuid.trim().equals("") || strGuid.trim().equalsIgnoreCase("GUID") || strGuid.length() <= 50) continue;
                    if (strGuid.startsWith(QUOTE_STRING) && strGuid.endsWith(QUOTE_STRING)) {
                        strGuid = strGuid.substring(QUOTE_STRING.length(), strGuid.length() - QUOTE_STRING.length());
                    }
                    if (strBufferGUID == null || strBufferGUID.trim().equals("")) {
                        this.m_agentInstanceDef.setAgentGuid(strGuid.trim());
                        result = true;
                        continue;
                    }
                    if (!strBufferGUID.equalsIgnoreCase(strGuid.trim())) continue;
                    result = true;
                }
                Object var12_13 = null;
                try {
                    if (null != br) {
                        br.close();
                    }
                    if (null != fr) {
                        fr.close();
                    }
                    break block27;
                }
                catch (IOException e2) {}
            }
            break block27;
            {
                catch (IOException e3) {
                    Util.display(2, CLASS_NAME, "readGUIDFromConfig", "Error in processing file: " + e3);
                    boolean bl2 = result;
                    Object var12_14 = null;
                    try {
                        if (null != br) {
                            br.close();
                        }
                        if (null != fr) {
                            fr.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return bl2;
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    if (null != br) {
                        br.close();
                    }
                    if (null != fr) {
                        fr.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean writeGUIDIntoConfig(String strGUID) {
        boolean result;
        block14: {
            String methodName = "writeGUIDIntoConfig";
            result = false;
            BufferedWriter bw = null;
            FileWriter fw = null;
            File configFile = new File(this.m_agentInstanceDef.getAgentIdFile());
            fw = new FileWriter(configFile, true);
            bw = new BufferedWriter(fw);
            bw.newLine();
            bw.write("GUID=\"" + strGUID + QUOTE_STRING);
            bw.flush();
            this.m_agentInstanceDef.setAgentGuid(strGUID);
            result = true;
            Object var9_8 = null;
            try {
                if (null != bw) {
                    bw.close();
                }
                if (null != fw) {
                    fw.close();
                }
                break block14;
            }
            catch (IOException e2) {}
            break block14;
            {
                catch (IOException e3) {
                    Util.display(2, CLASS_NAME, "writeGUIDIntoConfig", "Error in processing file: " + e3);
                    boolean bl2 = result;
                    Object var9_9 = null;
                    try {
                        if (null != bw) {
                            bw.close();
                        }
                        if (null != fw) {
                            fw.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return bl2;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (null != bw) {
                        bw.close();
                    }
                    if (null != fw) {
                        fw.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    private void PopulateAgentInstanceInfo() {
        block19: {
            String methodName = "PopulateAgentInstanceInfo";
            if (this.m_agentInstanceDef.getAgentGuid().trim().equals("") && !this.m_agentInstanceDef.getAgentIdFile().trim().equals("")) {
                if (!this.readGUIDFromConfig(null)) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "PopulateAgentInstanceInfo", "GUID is not present in the config file");
                    }
                    if (this.writeGUIDIntoConfig(this.CreateGUID())) {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "PopulateAgentInstanceInfo", "Added GUID in config file: " + this.m_agentInstanceDef.getAgentGuid());
                        }
                    } else if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "PopulateAgentInstanceInfo", "Unable to add GUID in config file: " + this.m_agentInstanceDef.getAgentGuid());
                    }
                } else if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "PopulateAgentInstanceInfo", "Retrieve GUID from config file: " + this.m_agentInstanceDef.getAgentGuid());
                }
            } else if (!(this.m_agentInstanceDef.getAgentGuid().trim().equals("") || this.m_agentInstanceDef.getAgentIdFile().trim().equals("") || this.readGUIDFromConfig(this.m_agentInstanceDef.getAgentGuid()))) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "PopulateAgentInstanceInfo", "GUID is not present in the config file");
                }
                if (this.writeGUIDIntoConfig(this.m_agentInstanceDef.getAgentGuid())) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "PopulateAgentInstanceInfo", "Added GUID in config file: " + this.m_agentInstanceDef.getAgentGuid());
                    }
                } else if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "PopulateAgentInstanceInfo", "Unable to add GUID in config file: " + this.m_agentInstanceDef.getAgentGuid());
                }
            }
            String strHostName = "unknown";
            try {
                strHostName = InetAddress.getLocalHost().getHostName();
                InetAddress[] addr = InetAddress.getAllByName(strHostName);
                String strSystemIPAddresses = "";
                for (int i2 = 0; i2 < addr.length; ++i2) {
                    strSystemIPAddresses = strSystemIPAddresses + addr[i2].getHostAddress() + ",";
                }
                this.m_agentInstanceDef.setHostName(strHostName);
                this.m_agentInstanceDef.setSystemIPAddresses(strSystemIPAddresses.substring(0, strSystemIPAddresses.length() - 1));
            }
            catch (UnknownHostException uhe) {
                if (!Util.isLogEnabled()) break block19;
                Util.display(2, CLASS_NAME, "PopulateAgentInstanceInfo", "Unable to get the hostname: " + uhe);
            }
        }
        String strOSName = System.getProperty("os.name");
        this.m_agentInstanceDef.setAgentProductOStype(strOSName);
    }

    SmAgentApiManagementResult processAgentInstanceInfo() throws SmAgentApiManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "processAgentInstanceInfo";
        if (this.m_connection == null || this.m_connection.isClosed()) {
            Util.display(2, CLASS_NAME, "processAgentInstanceInfo", "Connection is null or closed");
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (this.m_agentInstanceDef == null) {
            Util.display(2, CLASS_NAME, "processAgentInstanceInfo", "Missing AgentInstanceDef/Data");
            throw new SmAgentApiManagementException(-4, c_bundle.getString("M_INVALID_AGENT_INSTANCE"));
        }
        this.PopulateAgentInstanceInfo();
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(7);
        try {
            if (this.m_agentInstanceDef.getAgentGuid() != null && !this.m_agentInstanceDef.getAgentGuid().trim().equals("")) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding GUID = " + this.m_agentInstanceDef.getAgentGuid());
                }
                request.setAttribute(169, this.m_agentInstanceDef.getAgentGuid().getBytes("UTF-8"));
            }
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding Agent Product Type = " + this.m_agentInstanceDef.getAgentProductType());
            }
            request.setAttribute(170, this.m_agentInstanceDef.getAgentProductType().getBytes("UTF-8"));
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding Agent Product Version = " + this.m_agentInstanceDef.getAgentProductVersion());
            }
            request.setAttribute(171, this.m_agentInstanceDef.getAgentProductVersion().getBytes("UTF-8"));
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding Agent Product Sub Type = " + this.m_agentInstanceDef.getAgentProductSubtype());
            }
            request.setAttribute(174, this.m_agentInstanceDef.getAgentProductSubtype().getBytes("UTF-8"));
            if (this.m_agentInstanceDef.getAgentIdFile() != null && !this.m_agentInstanceDef.getAgentIdFile().trim().equals("")) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding Agent ID File Data = " + this.m_agentInstanceDef.getAgentIdFile());
                }
                request.setAttribute(173, this.m_agentInstanceDef.getAgentIdFile().getBytes("UTF-8"));
            }
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding Agent Config Object Name = " + this.m_agentInstanceDef.getACOName());
            }
            request.setAttribute(175, this.m_agentInstanceDef.getACOName().getBytes("UTF-8"));
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding Host Config Object Name = " + this.m_agentInstanceDef.getHCOName());
            }
            request.setAttribute(176, this.m_agentInstanceDef.getHCOName().getBytes("UTF-8"));
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding Host Name = " + this.m_agentInstanceDef.getHostName());
            }
            request.setAttribute(177, this.m_agentInstanceDef.getHostName().getBytes("UTF-8"));
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding the Operating System Type = " + this.m_agentInstanceDef.getAgentProductOStype());
            }
            request.setAttribute(179, this.m_agentInstanceDef.getAgentProductOStype().getBytes("UTF-8"));
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding the FIPS Mode = " + this.m_agentInstanceDef.getFIPSMode());
            }
            request.setAttribute(181, this.m_agentInstanceDef.getFIPSMode().getBytes("UTF-8"));
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding the System IP Addresses = " + this.m_agentInstanceDef.getSystemIPAddresses());
            }
            request.setAttribute(182, this.m_agentInstanceDef.getSystemIPAddresses().getBytes("UTF-8"));
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processAgentInstanceInfo", "Adding the management command = " + 4);
            }
            request.setAttribute(148, String.valueOf(4).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "processAgentInstanceInfo", "Unsupported encoding creating TLI packet: " + e2);
            }
            throw new SmAgentApiManagementException(e2);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        this.validateResponse(status, response);
        List attributes = response.getAttributes();
        if (attributes == null) {
            Util.display(2, CLASS_NAME, "processAgentInstanceInfo", "No response attributes to process");
            throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_LIST_ATTRIBUTES"));
        }
        ArrayList<SmAttribute> updatedAttributes = new ArrayList<SmAttribute>();
        for (SmAttribute responseAttribute : attributes) {
            if (responseAttribute == null) {
                Util.display(4, CLASS_NAME, "processAgentInstanceInfo", "Ignoring null attribute from the PS");
                continue;
            }
            if (Util.isLogEnabled()) {
                Util.display(4, CLASS_NAME, "processAgentInstanceInfo", "Received response attribute id = " + responseAttribute.getId());
            }
            if (responseAttribute.getId() == 172) {
                String dataAIHI = null;
                try {
                    dataAIHI = new String(responseAttribute.getValue(), "UTF-8");
                    if (dataAIHI == null || dataAIHI.trim().equals("") || Integer.parseInt(dataAIHI) == 0) {
                        this.m_agentInstanceDef.setAIHI(24L);
                        continue;
                    }
                    this.m_agentInstanceDef.setAIHI(Long.parseLong(dataAIHI));
                    continue;
                }
                catch (UnsupportedEncodingException e3) {
                    Util.display(2, CLASS_NAME, "processAgentInstanceInfo", "Unsupported encoding parsing attribute value");
                    throw new SmAgentApiManagementException(e3);
                }
            }
            updatedAttributes.add(responseAttribute);
        }
        boolean result = false;
        int code = response.getType();
        if (code == 2) {
            result = true;
        }
        return new SmAgentApiManagementResult(result, updatedAttributes);
    }

    public void run() {
        try {
            SmAgentApiManagementResult result = this.processAgentInstanceInfo();
        }
        catch (SmAgentApiManagementException agentException) {
            Util.display(2, CLASS_NAME, "setAgentInstanceInfo", agentException.getMessage());
        }
        catch (SmAgentApiConnectionException agentConnection) {
            Util.display(2, CLASS_NAME, "setAgentInstanceInfo", agentConnection.getMessage());
        }
        catch (SmAgentApiNotInitializedException notInitialize) {
            Util.display(2, CLASS_NAME, "setAgentInstanceInfo", notInitialize.getMessage());
        }
        long timetoSchedule = this.m_agentInstanceDef.getAIHI() * 1000L;
        this.m_connection.getTimer().schedule((TimerTask)new SmAgentInstance(this.m_connection, this.m_agentInstanceDef), timetoSchedule);
    }

    private void validateResponse(int[] status, SmAgentTliPacket response) throws SmAgentApiManagementException {
        String methodName = "validateResponse";
        if (status[0] != 0) {
            Util.display(2, CLASS_NAME, "validateResponse", "Did not receive SUCCESS from request");
            throw new SmAgentApiManagementException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            Util.display(2, CLASS_NAME, "validateResponse", "Null response from request");
            throw new SmAgentApiManagementException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        if (code != 2 && code != 3) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "validateResponse", "Unrecognized response code from request: " + code);
            }
            throw new SmAgentApiManagementException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
        }
    }
}

