/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmSecureRandom;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.RC2ParameterSpec;

class SmRC2CryptoProvider
extends SmCryptoProvider {
    protected RC2ParameterSpec m_params = null;

    SmRC2CryptoProvider(String keyDigestAlg, boolean bAscii) {
        this.m_transformation = "RC2/CBC/PKCS5Padding";
        this.m_algorithm = "RC2";
        this.m_keyDigestAlg = keyDigestAlg;
        this.m_verifyDigest = false;
        this.m_bAscii = bAscii;
    }

    protected void initParams() throws SmCryptoProviderException {
        this.m_params = new RC2ParameterSpec(this.m_keyStrength, this.m_initVector);
    }

    public Key generateKey() throws SmCryptoProviderException {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(this.m_algorithm, (Provider)m_provider);
            keygen.init(this.m_params, SmSecureRandom.get());
            return keygen.generateKey();
        }
        catch (GeneralSecurityException e2) {
            throw new SmCryptoProviderException(e2);
        }
    }

    protected Cipher getEncrypter() throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(1, this.m_encryptKey, this.m_params, SmSecureRandom.get());
        return cipher;
    }

    protected Cipher getDecrypter() throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(2, this.m_decryptKey, this.m_params, SmSecureRandom.get());
        return cipher;
    }
}

