/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.connection;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.connection.SmHandle;
import com.ca.siteminder.sdk.agentapi.connection.SmInitDef;
import com.ca.siteminder.sdk.agentapi.connection.SmRequestCounter;
import com.ca.siteminder.sdk.agentapi.connection.SmServer;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.resources.SmConnectionMessages;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentPacket;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliBuffer;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.ResourceBundle;

class SmCluster
extends SmHandle
implements SmAgentApiConstants {
    private static final String CLASS_NAME = "SmCluster";
    private static final String MESSAGES_CLASSNAME = SmConnectionMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private static int c_totalClusters = 0;
    private SmServer[] m_servers = null;
    private int m_curServers = 0;
    private int m_maxServers = 0;
    private int m_failoverThresholdPercent = 0;
    private int m_failoverThresholdCount = 0;
    private int m_clusterId = 0;
    private int m_timeoutSum = 0;
    private double[] m_distributionTable = null;
    private Object m_clusterLock = new Object();
    private int m_failedHandShakeCount = 0;

    SmCluster() {
        this.m_clusterId = c_totalClusters++;
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, CLASS_NAME, "Creating cluster index = " + this.m_clusterId);
        }
        try {
            this.m_counter = new SmRequestCounter(20000L, true);
        }
        catch (SmAgentApiConnectionException smAgentApiConnectionException) {
            // empty catch block
        }
    }

    void init(int maxServers, int failoverThresholdPercent) throws SmAgentApiConnectionException {
        String methodName = "init";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "init", "Started init");
        }
        if (this.m_servers != null) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Re-initializing on an already-intialized cluster");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_CLUSTER_ALREADY_INITIALIZED"));
        }
        if (failoverThresholdPercent < 0 || failoverThresholdPercent > 100 || maxServers <= 0) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Invalid failoverThresholdPercent");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_CONFIG_INFO"));
        }
        this.m_servers = new SmServer[maxServers];
        Arrays.fill(this.m_servers, null);
        this.m_maxServers = maxServers;
        this.m_failoverThresholdPercent = failoverThresholdPercent;
        this.m_distributionTable = new double[2 * this.m_maxServers];
        this.resetDistribution();
        if (Util.isLogEnabled()) {
            Util.display(4, CLASS_NAME, "init", "Changing cluster state from init to disabled for id = " + this.m_clusterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addServer(SocketAddress serverAddress, SmInitDef initDef, int version) throws SmAgentApiConnectionException {
        String methodName = "addServer";
        Object object = this.m_clusterLock;
        synchronized (object) {
            if (this.m_servers == null) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "addServer", "Adding servers to an unintialized cluster!");
                }
                throw new SmAgentApiConnectionException(c_bundle.getString("M_CLUSTER_NOT_INITIALIZED"));
            }
            if (this.m_curServers >= this.m_maxServers) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "addServer", "Invalid servers - #servers = " + this.m_curServers + ", maxServers = " + this.m_maxServers);
                }
                throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_CONFIG_INFO"));
            }
            boolean newslot = false;
            SmServer newServer = new SmServer();
            try {
                newServer.init(serverAddress, initDef, version);
            }
            catch (SmAgentApiConnectionException e2) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "addServer", "Failed to add server " + serverAddress.toString() + " to cluster " + this.m_clusterId);
                    e2.printStackTrace();
                }
                newServer.setState(0, 5);
                throw e2;
            }
            catch (Throwable t2) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "addServer", "Failed to add server " + serverAddress.toString() + " to cluster " + this.m_clusterId);
                    t2.printStackTrace();
                }
                newServer.setState(0, 5);
                throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_CONFIG_INFO"), t2);
            }
            if (Util.isLogEnabled()) {
                Util.display(4, CLASS_NAME, "addServer", "Added a new server, hostname = " + serverAddress + ", to cluster id = " + this.m_clusterId);
            }
            newServer.setState(0, 3);
            this.m_servers[this.m_curServers++] = newServer;
            this.m_timeoutSum = (int)((long)this.m_timeoutSum + newServer.getTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SmAgentPacket processRequest(SmAgentPacket request, int[] status) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        String methodName = "processRequest";
        long start = System.currentTimeMillis();
        int[] returnCode = new int[]{-1};
        while (true) {
            int i2;
            SmServer curServer;
            Object object = this.m_clusterLock;
            synchronized (object) {
                curServer = this.getServer();
                if (curServer == null) {
                    status[0] = returnCode[0] == -2 ? -2 : -1;
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "processRequest", "No active servers found for cluster id = " + this.m_clusterId + ", setting status = " + status[0]);
                    }
                    return null;
                }
            }
            SmAgentPacket response = curServer.processRequest(request, returnCode);
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processRequest", "Server " + curServer.m_serverAddress + " returned " + returnCode[0]);
            }
            Object object2 = this.m_clusterLock;
            synchronized (object2) {
                if (returnCode[0] == 0) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Server process request returned successfully");
                    }
                    curServer.setState(1, 2);
                    long now = System.currentTimeMillis();
                    curServer.getRequestCounter().addRequestTimeSample(now, now - start);
                    status[0] = 0;
                    return response;
                }
                if (curServer.setState(2, 4)) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Changing active server " + curServer.m_serverAddress + " to intermediate");
                    }
                } else {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Server " + curServer.m_serverAddress + " wasn't active, trying another");
                    }
                    continue;
                }
            }
            if (returnCode[0] == -2) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "processRequest", "Got timeout from server " + curServer.m_serverAddress);
                }
                object2 = this.m_clusterLock;
                synchronized (object2) {
                    boolean bDeleteTimedOutConnection = false;
                    if (this.m_servers.length == 1 && curServer.getConnectionCount() == 1) {
                        bDeleteTimedOutConnection = true;
                    }
                    for (i2 = 0; i2 < this.m_servers.length; ++i2) {
                        int srState = this.m_servers[i2].getState();
                        if (srState != 2 && srState != 1 && srState != 4) continue;
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "processRequest", "Deleting idle connections for server " + curServer.m_serverAddress);
                        }
                        this.m_servers[i2].deleteIdleConnections(bDeleteTimedOutConnection);
                    }
                }
            }
            if (curServer.getConnectionCount() > 0) {
                object2 = this.m_clusterLock;
                synchronized (object2) {
                    if (curServer.setState(4, 1) && Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Connections left, changing from interm. to inactive for server " + curServer.m_serverAddress);
                    }
                }
            }
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "processRequest", "No connections left, creating 1 for server " + curServer.m_serverAddress);
            }
            boolean bInitResult = curServer.createConnections(1);
            Object bDeleteTimedOutConnection = this.m_clusterLock;
            synchronized (bDeleteTimedOutConnection) {
                if (bInitResult) {
                    if (curServer.setState(4, 2) && Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Creating connection succeeded, changing intermed. to success for server " + curServer.m_serverAddress);
                    }
                } else if (curServer.setState(4, 1) && Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "processRequest", "Creating connection failed, changing intermed. to inactive for server " + curServer.m_serverAddress);
                }
            }
            object2 = this.m_clusterLock;
            synchronized (object2) {
                int activecount = 0;
                for (i2 = 0; i2 < this.m_servers.length; ++i2) {
                    if (this.m_servers[i2].getState() != 2) continue;
                    ++activecount;
                }
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "processRequest", "Found active server count = " + activecount + ", for cluster " + this.m_clusterId);
                }
                if (activecount < this.m_failoverThresholdCount) {
                    curServer.setState(2, 1);
                    status[0] = returnCode[0] == -2 ? -2 : -1;
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Active count < failoverthreshhold, setting status = " + status[0]);
                    }
                    return null;
                }
            }
            if (System.currentTimeMillis() - start > (long)(2000 * this.m_timeoutSum)) break;
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "processRequest", "Aborting / timeout to prevent looping forever");
        }
        status[0] = -2;
        return null;
    }

    SmServer getServer() {
        String methodName = "getServer";
        int best = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int j2 = 0; j2 < this.m_servers.length; ++j2) {
                if (this.m_distributionTable[2 * j2] > 0.0 && this.m_servers[j2].getState() != 2) {
                    this.recalibrateDistribution();
                    j2 = -1;
                    i2 = 2;
                    continue;
                }
                if (!(this.m_distributionTable[2 * j2] > this.m_distributionTable[2 * best])) continue;
                best = j2;
            }
            if (!(this.m_distributionTable[2 * best] <= 0.0)) continue;
            this.recalibrateDistribution();
        }
        int doubleBest = 2 * best;
        if (this.m_distributionTable[doubleBest] <= 0.0) {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "getServer", "No good servers found for cluster id " + this.m_clusterId);
            }
            return null;
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "getServer", "Using server " + this.m_servers[best].m_serverAddress + ": goodness " + this.m_distributionTable[doubleBest] + ", step " + this.m_distributionTable[doubleBest + 1]);
        }
        int n2 = doubleBest;
        this.m_distributionTable[n2] = this.m_distributionTable[n2] - this.m_distributionTable[doubleBest + 1];
        return this.m_servers[best];
    }

    void recalibrateDistribution() {
        String methodName = "recalibrateDistribution";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "recalibrateDistribution", "Recalibrating for cluster id " + this.m_clusterId);
        }
        this.resetDistribution();
        int i2 = 0;
        double totalTput = 0.0;
        for (i2 = 0; i2 < this.m_servers.length; ++i2) {
            if (this.m_servers[i2].getState() != 2) continue;
            double resptime = this.m_servers[i2].getRequestCounter().getAverageResponseTime();
            double thr = 1000.0 / (resptime + 1.0);
            this.m_distributionTable[2 * i2] = 100.0;
            this.m_distributionTable[2 * i2 + 1] = thr;
            totalTput += thr;
        }
        if (totalTput > 0.0) {
            for (i2 = 0; i2 < this.m_servers.length; ++i2) {
                if (this.m_servers[i2].getState() != 2) continue;
                this.m_distributionTable[2 * i2 + 1] = totalTput / this.m_distributionTable[2 * i2 + 1];
            }
        }
    }

    void resetDistribution() {
        Arrays.fill(this.m_distributionTable, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enable() throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        String methodName = "enable";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "enable", "Attempting to enable cluster id = " + this.m_clusterId);
        }
        int activecount = 0;
        this.m_failedHandShakeCount = 0;
        Object object = this.m_clusterLock;
        synchronized (object) {
            this.m_failoverThresholdCount = (int)Math.max(1.0, Math.ceil((double)this.m_failoverThresholdPercent * (double)this.m_servers.length / 100.0));
            for (int i2 = 0; i2 < this.m_servers.length; ++i2) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "enable", "Attempting to enable server index = " + i2);
                }
                if (this.m_servers[i2].enable()) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "enable", "Success enabling server index = " + i2);
                    }
                    this.m_servers[i2].setState(3, 2);
                    ++activecount;
                    continue;
                }
                if (Util.isLogEnabled()) {
                    Util.display(3, CLASS_NAME, "enable", "Failed enabling server index = " + i2);
                }
                this.m_servers[i2].setState(3, 1);
                if (!this.m_servers[i2].isHandShakeFailed()) continue;
                ++this.m_failedHandShakeCount;
            }
        }
        if (activecount < this.m_failoverThresholdCount) {
            if (Util.isLogEnabled()) {
                Util.display(4, CLASS_NAME, "enable", "Failed to activate cluster id = " + this.m_clusterId);
            }
            return false;
        }
        if (Util.isLogEnabled()) {
            Util.display(4, CLASS_NAME, "enable", "Activating cluster id = " + this.m_clusterId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disable() {
        if (Util.isLogEnabled()) {
            Util.display(4, CLASS_NAME, "disable", "Disabling all servers for cluster id = " + this.m_clusterId);
        }
        Object object = this.m_clusterLock;
        synchronized (object) {
            for (int i2 = 0; i2 < this.m_servers.length; ++i2) {
                this.m_servers[i2].disable();
                this.m_servers[i2].setState(this.m_servers[i2].getState(), 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean revive() throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        String methodName = "revive";
        int activecount = 0;
        if (Util.isLogEnabled()) {
            Util.display(4, CLASS_NAME, "revive", "Reviving cluster id = " + this.m_clusterId);
        }
        for (int i2 = 0; i2 < this.m_servers.length; ++i2) {
            SmServer server = null;
            Object object = this.m_clusterLock;
            synchronized (object) {
                int srState = this.m_servers[i2].getState();
                if (srState == 2) {
                    ++activecount;
                } else if (srState == 1 && this.m_servers[i2].setState(1, 4)) {
                    server = this.m_servers[i2];
                }
            }
            if (server == null) continue;
            if (server.getConnectionCount() > 0) {
                int retryRes = server.retryTimedoutConnections();
                Object object2 = this.m_clusterLock;
                synchronized (object2) {
                    switch (retryRes) {
                        case 0: {
                            if (Util.isLogEnabled()) {
                                Util.display(4, CLASS_NAME, "revive", "Revived timed-out connections to server + " + this.m_servers[i2] + " succesfully");
                            }
                            if (!server.setState(4, 2)) break;
                            ++activecount;
                            break;
                        }
                        case -1: {
                            if (Util.isLogEnabled()) {
                                Util.display(4, CLASS_NAME, "revive", "Failed to revive timed-out connections, killing all connections to server " + this.m_servers[i2]);
                            }
                            server.releaseAllConnections();
                            server.setState(4, 1);
                            break;
                        }
                        default: {
                            if (Util.isLogEnabled()) {
                                Util.display(4, CLASS_NAME, "revive", "No connections found to retry for server " + this.m_servers[i2] + " state " + this.m_servers[i2].getState());
                            }
                            server.setState(4, 1);
                        }
                    }
                    continue;
                }
            }
            boolean bInitResult = server.createConnections(1);
            Object object3 = this.m_clusterLock;
            synchronized (object3) {
                if (bInitResult) {
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "revive", "Created initial connection to server " + this.m_servers[i2]);
                    }
                    if (server.setState(4, 2)) {
                        ++activecount;
                    }
                } else {
                    if (Util.isLogEnabled()) {
                        Util.display(4, CLASS_NAME, "revive", "Failed to create initial connection to server " + this.m_servers[i2]);
                    }
                    server.setState(4, 1);
                }
                continue;
            }
        }
        return activecount >= this.m_failoverThresholdCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMaxBufferSize() {
        int nSize = SmAgentTliBuffer.getMaxBufferSize();
        boolean gotValidLimit = false;
        Object object = this.m_clusterLock;
        synchronized (object) {
            int trialSize = 0;
            for (int i2 = 0; i2 < this.m_servers.length; ++i2) {
                if (this.m_servers[i2].getState() == 3 || this.m_servers[i2].getState() == 5) continue;
                trialSize = this.m_servers[i2].getMaxBufferSize();
                if (trialSize < nSize) {
                    if (trialSize < SmAgentTliBuffer.getDefaultBufferSize()) continue;
                    nSize = trialSize;
                    gotValidLimit = true;
                    continue;
                }
                if (gotValidLimit) continue;
                gotValidLimit = true;
            }
        }
        if (!gotValidLimit) {
            nSize = SmAgentTliBuffer.getDefaultBufferSize();
        }
        return nSize;
    }

    void logStats(OutputStream stream) {
        int i2;
        PrintStream out = null;
        out = stream instanceof PrintStream ? (PrintStream)stream : new PrintStream(stream);
        int activeServerCount = 0;
        for (i2 = 0; i2 < this.m_servers.length; ++i2) {
            if (this.m_servers[i2].getState() != 2) continue;
            ++activeServerCount;
        }
        out.println("    Cluster [" + this.m_clusterId + "]:");
        out.println("        state is " + this.getStatus());
        out.println("        active servers/threshold are " + activeServerCount + "/" + this.m_failoverThresholdCount);
        out.println("        average response time is " + String.valueOf(this.m_counter.getAverageResponseTime()) + " (msec)");
        out.println("        throughput is " + String.valueOf(this.m_counter.getCurrentThroughput()) + " (req/sec)");
        out.println("        max throughput is " + String.valueOf(this.m_counter.getMaxThroughput()) + " (req/sec)");
        out.println("        min throughput is " + String.valueOf(this.m_counter.getMinThroughput()) + " (req/sec)");
        out.println("        avg throughput is " + String.valueOf(this.m_counter.getAverageThroughput()) + " (req/sec)");
        out.println("        Servers:");
        for (i2 = 0; i2 < this.m_servers.length; ++i2) {
            this.m_servers[i2].logStats(stream);
        }
    }

    int failedHandShakeCount() {
        return this.m_failedHandShakeCount;
    }
}

