/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.security;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.Security;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentGroup;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentInstance;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthAzMap;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthValidateMap;
import com.ca.siteminder.sdk.adminapi.ca.sm.CertMap;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalDomain;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.ca.xps.SecurityCategory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Workspace;
import com.ca.siteminder.sdk.adminapi.ca.xps.WorkspaceEntry;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.STIUtil;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.basic.sm.AuthAzMapTest;
import com.ca.siteminder.sdk.adminapitest.basic.sm.AuthValidateMapTest;
import com.ca.siteminder.sdk.adminapitest.basic.sm.CertMapTest;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class WorkspaceTest
extends TestBase {
    static String name;
    static PolicyData policyData2;
    static Security security2;
    static Domain domainx;
    static Domain domain;
    static Domain newDomain;
    static Administrator admin2;
    static Workspace workspace;
    static WorkspaceEntry entry;
    static Grant domainGrant;
    static Grant agentGrant;
    static UserDirectory userDir;

    @TestBase.STI(value=1)
    public void smoke() throws Exception {
        name = "WorkspaceTest_" + SetupConnection.random;
        workspace = SecuritySetup.makeWorkspace(name);
        entry = SecuritySetup.makeWorkspaceEntry(workspace);
        domain = SetupConnection.builder.makeDomain(name, null);
        entry.setMember((XPSObject)domain);
        admin2 = SecuritySetup.admin2;
        admin2.setWorkspaces(Collections.singletonList(workspace));
        domainGrant = SecuritySetup.makeGrant(admin2, null);
        domainGrant.setRightsMask(Integer.valueOf(Security.convertRights((String)"M")));
        SecurityCategory securityCategory = SecuritySetup.makeSecurityCategory(SecuritySetup.agentAdmin);
        agentGrant = SecuritySetup.makeGrant(admin2, securityCategory);
        agentGrant.setRightsMask(Integer.valueOf(Security.convertRights((String)"M")));
        domainx = SetupConnection.builder.makeDomain(name + "x", null);
        this.createObject((XPSObject)domainGrant);
        this.createObject((XPSObject)agentGrant);
        this.createObject((XPSObject)domain);
        this.createObject((XPSObject)domainx);
        this.createObject((XPSObject)workspace);
        this.createObject((XPSObject)entry);
        this.updateObject((XPSObject)admin2);
        SecuritySetup.session2.connect();
        security2 = SecuritySetup.session2.getSecurity();
        policyData2 = SecuritySetup.session2.getPolicyData();
        Administrator administrator = security2.getAdmin();
        WorkspaceTest.assertEquals((String)"WorkSpace Admin XID and Server Admin XID must match", (String)admin2.getXid(), (String)administrator.getXid());
        List list = administrator.getWorkspaces();
        WorkspaceTest.assertSize("wslist", list, 1);
        Workspace workspace = (Workspace)list.get(0);
        WorkspaceTest.assertEquals((String)"Workspace and serverWorkspace XID must match", (String)WorkspaceTest.workspace.getXid(), (String)workspace.getXid());
        security2.setWorkspace(WorkspaceTest.workspace);
        List list2 = policyData2.search((IClass)Domain.ddclass);
        WorkspaceTest.assertSize("Only one domain expected", list2, 1);
        WorkspaceTest.assertEquals((String)"Domain XIDs must match", (String)domain.getXid(), (String)((Domain)list2.get(0)).getXid());
    }

    @TestBase.STI(value=2)
    public void updateGood() {
        policyData2.updateObject((XPSObject)domain);
        int n = security2.getRights((XPSObject)domain);
        WorkspaceTest.assertTrue((String)"update", (0 != (n & 2) ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void updateBad() {
        STIUtil.failUpdate(policyData2, (XPSObject)domainx, "Insufficient rights");
        STIUtil.failDelete(policyData2, (XPSObject)domainx, "Insufficient rights");
        int n = security2.getRights((XPSObject)domainx);
        WorkspaceTest.assertEquals((String)"rights", (int)0, (int)n);
    }

    @TestBase.STI(value=4)
    public void createNew() {
        List list = workspace.getChildren((IClass)WorkspaceEntry.ddclass);
        WorkspaceTest.assertSize("workspace entries before create", list, 1);
        newDomain = (Domain)policyData2.newObject((IClass)Domain.ddclass);
        newDomain.setName(name + "new");
        policyData2.createObject((XPSObject)newDomain);
        list = workspace.getChildren((IClass)WorkspaceEntry.ddclass);
        WorkspaceTest.assertSize("workspace entries after create", list, 2);
    }

    @TestBase.STI(value=5)
    public void deleteNew() {
        policyData2.deleteObject((XPSObject)newDomain);
        List list = workspace.getChildren((IClass)WorkspaceEntry.ddclass);
        WorkspaceTest.assertSize("workspace entries after delete", list, 1);
    }

    @TestBase.STI(value=6)
    public void uniquiness() {
        String string = "domainwforuniquiness" + SetupConnection.random;
        Domain domain = (Domain)SetupConnection.policyData.newObject((IClass)Domain.ddclass);
        domain.setName(string);
        this.createObject((XPSObject)domain);
        Domain domain2 = (Domain)policyData2.newObject((IClass)Domain.ddclass);
        domain2.setName(string);
        STIUtil.failCreate(policyData2, (XPSObject)domain2, "Duplicate value");
    }

    @TestBase.STI(value=7)
    public void changeToReadOnly() {
        entry.setReadOnly(Boolean.valueOf(true));
        this.updateObject((XPSObject)entry);
        List list = policyData2.search((IClass)Domain.ddclass);
        WorkspaceTest.assertEquals((String)"Only one domain expected", (int)1, (int)list.size());
    }

    @TestBase.STI(value=8)
    public void updateReadOnly() {
        STIUtil.failUpdate(policyData2, (XPSObject)domain, "Insufficient rights");
        int n = security2.getRights((XPSObject)domain);
        WorkspaceTest.assertFalse((String)"update", (0 != (n & 2) ? 1 : 0) != 0);
    }

    @TestBase.STI(value=9)
    public void deleteReadOnly() {
        STIUtil.failDelete(policyData2, (XPSObject)domain, "Insufficient rights");
        int n = security2.getRights((XPSObject)domain);
        WorkspaceTest.assertFalse((String)"update", (0 != (n & 4) ? 1 : 0) != 0);
        WorkspaceTest.assertTrue((String)"update", (0 != (n & 0x10) ? 1 : 0) != 0);
    }

    @TestBase.STI(value=10)
    public void newObject() {
        newDomain = (Domain)policyData2.newObject((IClass)Domain.ddclass);
        newDomain.setName(name + "new1");
        policyData2.createObject((XPSObject)newDomain);
        policyData2.updateObject((XPSObject)newDomain);
        policyData2.deleteObject((XPSObject)newDomain);
    }

    @TestBase.STI(value=11)
    public void removeLastEntry() {
        SetupConnection.policyData.deleteObject((XPSObject)entry);
        List list = workspace.getChildren((IClass)WorkspaceEntry.ddclass);
        WorkspaceTest.assertSize("workspace entries", list, 0);
        STIUtil.failUpdate(policyData2, (XPSObject)domain, "Insufficient rights");
        STIUtil.failDelete(policyData2, (XPSObject)domain, "Insufficient rights");
        newDomain = (Domain)policyData2.newObject((IClass)Domain.ddclass);
        newDomain.setName(name + "new2");
        policyData2.createObject((XPSObject)newDomain);
        policyData2.updateObject((XPSObject)newDomain);
        policyData2.deleteObject((XPSObject)newDomain);
    }

    @TestBase.STI(value=12)
    public void mandatoryObjects() {
        List list = policyData2.search((IClass)AgentType.ddclass);
        WorkspaceTest.assertSize("agent types", list, 2);
        List list2 = policyData2.search((IClass)GlobalDomain.ddclass);
        WorkspaceTest.assertSize("global domains", list2, 1);
    }

    @TestBase.STI(value=13)
    public void deleteEntryWhenDMemberDeleted() {
        newDomain = (Domain)policyData2.newObject((IClass)Domain.ddclass);
        newDomain.setName(name + "new3");
        policyData2.createObject((XPSObject)newDomain);
        List list = workspace.getChildren((IClass)WorkspaceEntry.ddclass);
        WorkspaceTest.assertSize("workspace entries", list, 1);
        policyData2.deleteObject((XPSObject)newDomain);
        list = workspace.getChildren((IClass)WorkspaceEntry.ddclass);
        if (list != null) {
            WorkspaceTest.assertEquals((String)"workspace entries size", (int)0, (int)list.size());
        }
    }

    @TestBase.STI(value=14)
    public void testAgentInstance() {
        String string = "agent" + SetupConnection.random;
        Agent agent = SetupConnection.builder.makeAgent(string);
        List<String> list = Collections.singletonList(string);
        AgentInstance agentInstance = (AgentInstance)SetupConnection.policyData.newObject((IClass)AgentInstance.ddclass);
        agentInstance.setAgentsName(list);
        agentInstance.setSystemName("s1");
        AgentInstance agentInstance2 = (AgentInstance)SetupConnection.policyData.newObject((IClass)AgentInstance.ddclass);
        agentInstance2.setSystemName("s2");
        this.createObject((XPSObject)agent);
        this.createObject((XPSObject)agentInstance);
        this.createObject((XPSObject)agentInstance2);
        entry = SecuritySetup.makeWorkspaceEntry(workspace);
        entry.setMember((XPSObject)agent);
        this.createObject((XPSObject)entry);
        List list2 = policyData2.search((IClass)AgentInstance.ddclass);
        WorkspaceTest.assertSize("1 ai", list2, 1);
        WorkspaceTest.assertEquals((String)"1 ai", (String)agentInstance.getSystemName(), (String)((AgentInstance)list2.get(0)).getSystemName());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("fakeagent1");
        arrayList.add("fakeagent2");
        agentInstance2.setAgentsName(arrayList);
        this.updateObject((XPSObject)agentInstance2);
        list2 = policyData2.search((IClass)AgentInstance.ddclass);
        WorkspaceTest.assertSize("2 ai", list2, 1);
        WorkspaceTest.assertEquals((String)"2 ai", (String)agentInstance.getSystemName(), (String)((AgentInstance)list2.get(0)).getSystemName());
        arrayList.add(string);
        agentInstance2.setAgentsName(arrayList);
        this.updateObject((XPSObject)agentInstance2);
        list2 = policyData2.search((IClass)AgentInstance.ddclass);
        WorkspaceTest.assertSize("3 ai", list2, 2);
        this.deleteObject((XPSObject)entry);
    }

    @TestBase.STI(value=15)
    public void testAgentInGroup() {
        String string = "agent3" + SetupConnection.random;
        Agent agent = SetupConnection.builder.makeAgent(string);
        this.createObject((XPSObject)agent);
        AgentType agentType = agent.getAgentType();
        AgentGroup agentGroup = (AgentGroup)SetupConnection.policyData.newObject((IClass)AgentGroup.ddclass);
        agentGroup.setAgentType(agentType);
        agentGroup.setName(string + "group2");
        this.createObject((XPSObject)agentGroup);
        AgentGroup agentGroup2 = (AgentGroup)SetupConnection.policyData.newObject((IClass)AgentGroup.ddclass);
        ArrayList<Agent> arrayList = new ArrayList<Agent>();
        arrayList.add(agent);
        agentGroup2.setAgents(arrayList);
        agentGroup2.setAgentGroups(Collections.singletonList(agentGroup));
        agentGroup2.setAgentType(agentType);
        agentGroup2.setName(string + "group");
        this.createObject((XPSObject)agentGroup2);
        WorkspaceEntry workspaceEntry = SecuritySetup.makeWorkspaceEntry(workspace);
        workspaceEntry.setMember((XPSObject)agentGroup2);
        this.createObject((XPSObject)workspaceEntry);
        STIUtil.failUpdate(policyData2, (XPSObject)agent, "Insufficient rights");
        List list = policyData2.search((IClass)Agent.ddclass);
        WorkspaceTest.assertSize("agent", list, 1);
        List list2 = policyData2.search((IClass)AgentGroup.ddclass);
        WorkspaceTest.assertSize("agentgroup", list2, 2);
        policyData2.deleteObject((XPSObject)agentGroup2);
        list = policyData2.search((IClass)Agent.ddclass);
        WorkspaceTest.assertSize("agent", list, 0);
        list2 = policyData2.search((IClass)AgentGroup.ddclass);
        WorkspaceTest.assertSize("agentgroup", list2, 0);
    }

    @TestBase.STI(value=16)
    public void testAuthScheme() {
        List list = policyData2.search((IClass)AuthScheme.ddclass);
        WorkspaceTest.assertNotNull((Object)list);
        WorkspaceTest.assertTrue((String)"scheme size", (list.size() > 0 ? 1 : 0) != 0);
        for (AuthScheme authScheme : list) {
            WorkspaceTest.assertTrue((String)"isTemplate", (boolean)authScheme.getIsTemplate());
        }
    }

    @TestBase.STI(value=17)
    public void testCertMap() {
        String string = "CA.XPS::SecurityCategory@!Mapping Administration";
        SecurityCategory securityCategory = SecuritySetup.makeSecurityCategory(string);
        Grant grant = SecuritySetup.makeGrant(admin2, securityCategory);
        grant.setRightsMask(Integer.valueOf(Security.convertRights((String)"M")));
        this.createObject((XPSObject)grant);
        String string2 = "TestWorkspaceUserDir" + SetupConnection.random;
        userDir = SetupConnection.builder.makeUserDirectory(string2);
        this.createObject((XPSObject)userDir);
        CertMap certMap = CertMapTest.makeCertMap(null);
        this.createObject((XPSObject)certMap);
        policyData2.fetchObject(certMap.getXid());
        certMap.setUserDirectory(userDir);
        this.updateObject((XPSObject)certMap);
        this.failFetchObject((XPSObject)certMap);
        this.createEntry((XPSObject)userDir);
        policyData2.fetchObject(certMap.getXid());
        this.deleteObject((XPSObject)entry);
    }

    @TestBase.STI(value=18)
    public void testAuthMap() {
        AuthAzMap authAzMap = AuthAzMapTest.makeAuthAzMap(userDir);
        UserDirectory userDirectory = userDir.duplicate();
        userDirectory.setName("TestWorkspaceUserDirAz" + SetupConnection.random);
        this.createObject((XPSObject)userDirectory);
        authAzMap.setAzDir(userDirectory);
        this.createObject((XPSObject)authAzMap);
        this.failFetchObject((XPSObject)authAzMap);
        this.createEntry((XPSObject)userDirectory);
        this.failFetchObject((XPSObject)authAzMap);
        this.createEntry((XPSObject)userDir);
        policyData2.fetchObject(authAzMap.getXid());
    }

    @TestBase.STI(value=19)
    public void testAuthValidateMap() {
        String string = "AuthValidateMap" + SetupConnection.random;
        AuthValidateMap authValidateMap = AuthValidateMapTest.makeAuthValidateMap(string, userDir);
        this.createObject((XPSObject)authValidateMap);
        this.deleteObject((XPSObject)entry);
        this.failFetchObject((XPSObject)authValidateMap);
        this.createEntry((XPSObject)userDir);
        policyData2.fetchObject(authValidateMap.getXid());
    }

    void createEntry(XPSObject xPSObject) {
        entry = SecuritySetup.makeWorkspaceEntry(workspace);
        entry.setMember(xPSObject);
        this.createObject((XPSObject)entry);
    }

    void failFetchObject(XPSObject xPSObject) {
        InternalTesting.removeFromCache(SecuritySetup.session2, xPSObject);
        try {
            XPSObject xPSObject2 = policyData2.fetchObject(xPSObject.getXid());
            WorkspaceTest.format(xPSObject2);
            WorkspaceTest.fail((String)("fetched without rights: " + xPSObject.getXid()));
        }
        catch (ServerException serverException) {
            WorkspaceTest.assertContains(serverException.getMsg(), "Insufficient rights");
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)WorkspaceTest.suite());
    }

    public static Test suite() {
        return new SecuritySetup(WorkspaceTest.class);
    }
}

