/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.security;

import com.ca.siteminder.sdk.adminapi.ConnectionHelper;
import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;
import netegrity.siteminder.javaagent.AgentAPI;

public class LegacyAdmin
extends TestBase {
    static Domain domain;
    static Admin legacy;
    static Session session2;
    static PolicyData policyData2;
    static int domainCount;
    static String admin2Name;

    @Override
    public void setUpSuite() {
        AgentAPI agentAPI;
        domain = (Domain)SetupConnection.policyData.newObject((IClass)Domain.ddclass);
        domain.setName("domainSecurity" + SetupConnection.random);
        this.createObject((XPSObject)domain);
        List list = SetupConnection.policyData.search((IClass)Domain.ddclass);
        domainCount = list.size();
        String string = "firewall";
        String string2 = "legacyadmin" + SetupConnection.random;
        legacy = (Admin)SetupConnection.policyData.newObject((IClass)Admin.ddclass);
        legacy.setName(string2);
        legacy.setPassword(string);
        legacy.setRights(Admin.Rights.ManageObjects, new Admin.Rights[0]);
        this.createObject((XPSObject)legacy);
        Session session = SetupConnection.session;
        ConnectionHelper connectionHelper = new ConnectionHelper();
        connectionHelper.agentapi = agentAPI = session.getConnection();
        String string3 = connectionHelper.PMAPI_login(string2, string);
        session2 = new Session();
        session2.setConnection(agentAPI);
        session2.setSessionTicket(string3);
        session2.connect();
        policyData2 = session2.getPolicyData();
        admin2Name = session2.getSecurity().getAdmin().getName();
    }

    @TestBase.STI(value=1)
    public void noDomains() {
        LegacyAdmin.countGrants(0);
        List list = policyData2.search((IClass)Domain.ddclass);
        LegacyAdmin.assertSize("no domains", list, 0);
    }

    @TestBase.STI(value=2)
    public void searchWithAllDomains() {
        legacy.setRights(Admin.Rights.ManageObjects, new Admin.Rights[]{Admin.Rights.ManageAllDomains});
        this.updateObject((XPSObject)legacy);
        LegacyAdmin.countGrants(2);
        List list = policyData2.search((IClass)Domain.ddclass);
        LegacyAdmin.assertSize("all domains", list, domainCount);
    }

    @TestBase.STI(value=3)
    public void searchWithOneDomain() {
        legacy.setRights(Admin.Rights.ManageObjects, new Admin.Rights[0]);
        List<Domain> list = Collections.singletonList(domain);
        legacy.setDomains(list);
        this.updateObject((XPSObject)legacy);
        LegacyAdmin.countGrants(2);
        List list2 = policyData2.search((IClass)Domain.ddclass);
        LegacyAdmin.assertSize("has domains", list2, 1);
        LegacyAdmin.assertEquals((String)"right domain", (String)domain.getXid(), (String)((Domain)list2.get(0)).getXid());
    }

    @TestBase.STI(value=4)
    public void toXAdmin() {
        String string = SecuritySetup.getLegacyNamespace();
        String string2 = string + legacy.getName();
        Administrator administrator = (Administrator)SetupConnection.fetchByAttr(Administrator.ddclass, (IAttribute)Administrator.USERPATH, string2);
        SetupConnection.policyData.updateObject((XPSObject)administrator);
        LegacyAdmin.assertFalse((String)"legacy", (boolean)administrator.getFlags().contains(Administrator.Flags.Legacy));
        SetupConnection.policyData.deleteObject((XPSObject)administrator);
        LegacyAdmin.assertTrue((String)"legacy", (boolean)administrator.getFlags().contains(Administrator.Flags.Legacy));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)LegacyAdmin.suite());
    }

    public static Test suite() {
        return new SetupConnection(LegacyAdmin.class);
    }

    static void countGrants(int n) {
        Administrator administrator = (Administrator)SetupConnection.fetchByName(Administrator.ddclass, admin2Name);
        List list = administrator.getChildren((IClass)Grant.ddclass);
        LegacyAdmin.assertSize("grants", list, n);
    }
}

