/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.rolesexp;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapitest.RoleExpBase;
import com.ca.siteminder.sdk.adminapitest.RoleExpSetup;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class RoleExpTestGroup7
extends RoleExpBase {
    String expr;

    @TestBase.STI(value=1)
    public void test131_PCASEvery_good() throws XPSException {
        this.expr = "PCASE('very, good')";
        this.evalStringExpr(this.expr, "Very, Good");
    }

    @TestBase.STI(value=2)
    public void test132_RIGHTsiteminder_3() throws XPSException {
        this.expr = "RIGHT('siteminder', 3)";
        this.evalStringExpr(this.expr, "der");
    }

    @TestBase.STI(value=3)
    public void test133_RIGHTsiteminder_20() throws XPSException {
        this.expr = "RIGHT('siteminder', 20)";
        this.evalStringExpr(this.expr, "siteminder");
    }

    @TestBase.STI(value=4)
    public void test134_RIGHTsiteminder_0() throws XPSException {
        this.expr = "RIGHT('siteminder', 0)";
        this.evalStringExpr(this.expr, "");
    }

    @TestBase.STI(value=5)
    public void test135_RPADsam_5() throws XPSException {
        this.expr = "RPAD('sam', 5)";
        this.evalStringExpr(this.expr, "sam  ");
    }

    @TestBase.STI(value=6)
    public void test136_RPADsam_5_Asterisk() throws XPSException {
        this.expr = "RPAD('sam', 5, '*')";
        this.evalStringExpr(this.expr, "sam**");
    }

    @TestBase.STI(value=7)
    public void test137_RPADsam_5_AsteriskHash() throws XPSException {
        this.expr = "RPAD('sam',   5, '*#')";
        this.evalStringExpr(this.expr, "sam**");
    }

    @TestBase.STI(value=8)
    public void test138_RPAD9_3() throws XPSException {
        this.expr = "RPAD(9,3)";
        this.evalStringExpr(this.expr, "900");
    }

    @TestBase.STI(value=9)
    public void test139_RPAD9_3() throws XPSException {
        this.expr = "RPAD(9, 3, ' ')";
        this.evalStringExpr(this.expr, "9  ");
    }

    @TestBase.STI(value=10)
    public void test140_AND() throws XPSException {
        this.eval("(1=1) AND (2=2)");
        this.eval("(1=1) AnD (2=1)", false);
        this.eval("yes & tRue");
        this.eval("true && nO", false);
    }

    @TestBase.STI(value=11)
    public void test141_OR() throws XPSException {
        this.eval("(1=1) OR (2=2)");
        this.eval("(1=1) oR (2=1)");
        this.eval("yes | tRue");
        this.eval("false || no", false);
    }

    @TestBase.STI(value=12)
    public void test142_AND_AND() throws XPSException {
        this.eval("true && true && true");
    }

    @TestBase.STI(value=13)
    public void test142_NOT() {
        this.eval("not (1=2)");
        this.eval("! false");
        this.eval("nOt true", false);
    }

    @TestBase.STI(value=14)
    public void test144_NOT_precedence() throws XPSException {
        this.eval("not true and false", false);
        this.eval("not false or true");
    }

    @TestBase.STI(value=15)
    public void test145_AND_OR_PRECEDENCE() throws XPSException {
        this.eval("false and true or true");
    }

    @TestBase.STI(value=17)
    public void test147_XOR() throws XPSException {
        this.eval("true Xor false");
        this.eval("false xor true");
        this.eval("true xor true", false);
        this.eval("false xor false", false);
    }

    @TestBase.STI(value=18)
    public void test148_XPR_distribution() throws XPSException {
        this.eval("true xor true or true");
        this.eval("true xor true and false", false);
    }

    @TestBase.STI(value=22)
    public void test152_RPTsam_3() throws XPSException {
        this.expr = "RPT('sam', 3)";
        this.evalStringExpr(this.expr, "samsamsam");
    }

    @TestBase.STI(value=23)
    public void test153_RPTPrc_7() throws XPSException {
        this.expr = "RPT('%', 7)";
        this.evalStringExpr(this.expr, "%%%%%%%");
    }

    @TestBase.STI(value=24)
    public void test154_RTRIMsample() throws XPSException {
        this.expr = "RTRIM('sample   ')";
        this.evalStringExpr(this.expr, "sample");
    }

    @TestBase.STI(value=25)
    public void test155_SPACE3() throws XPSException {
        this.expr = "SPACE(3)";
        this.evalStringExpr(this.expr, "   ");
    }

    @TestBase.STI(value=26)
    public void test156_SPACE10() throws XPSException {
        this.expr = "SPACE(10)";
        this.evalStringExpr(this.expr, "          ");
    }

    @TestBase.STI(value=27)
    public void test157_TRANSLATESample_m_x() throws XPSException {
        this.expr = "TRANSLATE('Sample', 'm', 'x')";
        this.evalStringExpr(this.expr, "Saxple");
    }

    @TestBase.STI(value=28)
    public void test158_TRANSLATESample_mp_x() throws XPSException {
        this.expr = "TRANSLATE('Sample', 'mp', 'x')";
        this.evalStringExpr(this.expr, "Saxle");
    }

    @TestBase.STI(value=29)
    public void test159_TRANSLATESample_m_xy() throws XPSException {
        this.expr = "TRANSLATE('Sample', 'm', 'xy')";
        this.evalStringExpr(this.expr, "Saxyple");
    }

    @TestBase.STI(value=30)
    public void test160_TRANSLATESample_M_x() throws XPSException {
        this.expr = "TRANSLATE('Sample', 'M', 'x')";
        this.evalStringExpr(this.expr, "Sample");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RoleExpTestGroup7.suite());
    }

    public static Test suite() {
        return new RoleExpSetup(RoleExpTestGroup7.class);
    }
}

