/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.GenericObject;
import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.xps.Attribute;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.Set;
import junit.framework.Test;
import junit.textui.TestRunner;

public class MetaAttributesTest
extends TestBase {
    static Domain domain;

    @TestBase.STI(value=1)
    public void setMeta() {
        domain = (Domain)SetupConnection.policyData.newObject((IClass)Domain.ddclass);
        domain.setName("MetaAttributesDomain" + SetupConnection.random);
        domain.setDesc("setMeta");
        domain.setHidingMask(XPSObject.HidingMask.GUI, new XPSObject.HidingMask[0]);
        this.createObject((XPSObject)domain);
        InternalTesting.invalidate((XPSObject)domain);
        MetaAttributesTest.assertTrue((String)"Domain must have hiding mask", (boolean)domain.hasHidingMask());
        Set set = domain.getHidingMask();
        MetaAttributesTest.assertTrue((String)"Mask must contain HidingMask.GUI", (boolean)set.contains(XPSObject.HidingMask.GUI));
    }

    @TestBase.STI(value=2)
    public void testMetaDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)domain);
        MetaAttributesTest.assertTrue((boolean)domain.hasHidingMask());
    }

    @TestBase.STI(value=3)
    public void clearMeta() {
        domain.setDesc("clearMeta");
        domain.clearHidingMask();
        this.updateObject((XPSObject)domain);
        domain = (Domain)InternalTesting.refetch(domain.getXid(), SetupConnection.session);
        MetaAttributesTest.assertFalse((String)"Hiding mask is not cleared", (boolean)domain.hasHidingMask());
    }

    @TestBase.STI(value=4)
    public void testGeneric() {
        GenericObject genericObject = domain.castToGenericObject();
        Attribute attribute = (Attribute)SetupConnection.policyData.fetchObject("CA.XPS::Attribute@CA.XPS::MetaAttributes.HidingMask");
        genericObject.set((IAttribute)attribute, (Object)XPSObject.HidingMask.GUI);
        this.updateObject((XPSObject)genericObject);
        InternalTesting.invalidate((XPSObject)domain);
        MetaAttributesTest.assertTrue((String)"Domain must have hiding mask", (boolean)domain.hasHidingMask());
        Set set = domain.getHidingMask();
        MetaAttributesTest.assertTrue((String)"Mask must contain HidingMask.GUI", (boolean)set.contains(XPSObject.HidingMask.GUI));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)MetaAttributesTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(MetaAttributesTest.class);
    }
}

