/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.ResultEntry;
import com.ca.siteminder.sdk.adminapi.User;
import com.ca.siteminder.sdk.adminapi.ValidatePasswordResponse;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class UserTest
extends TestBaseDMS {
    private static final Logger logger = Logger.getLogger(UserTest.class);

    @Override
    public void setUpSuite() {
        super.setUpSuite();
    }

    @TestBase.STI(value=1)
    public void testDisableUser() throws XPSException {
        logger.debug((Object)"***Testing User disable (POSITIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserDsbDN, list);
        user.enable(1);
    }

    @TestBase.STI(value=2)
    public void testGetDisabled() throws XPSException {
        logger.debug((Object)"***Testing User getDisabled (POSITIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserDsbDN, list);
        int n = user.getDisabled();
        UserTest.assertTrue((String)"User \"DMSTestUserDisabled\" must be disabled", ((n & 1) == 1 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testEnableUser() throws XPSException {
        logger.debug((Object)"***Testing User enable (POSITIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserDsbDN, list);
        user.enable(0);
    }

    @TestBase.STI(value=4)
    public void testGetGroups() throws XPSException {
        logger.debug((Object)"***Testing User getGroups (POSITIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserGrpDN, list);
        List list2 = null;
        list2 = user.getGroups(true);
        UserTest.assertTrue((list2.size() == 2 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=5)
    public void testIsInGroup() throws XPSException {
        logger.debug((Object)"***Testing User isInGroup (POSITIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserGrpDN, list);
        List list2 = user.getGroups(true);
        UserTest.assertNotNull((Object)list2);
        boolean bl = user.isInGroup(((ResultEntry)list2.get(0)).getDN());
        UserTest.assertTrue((boolean)bl);
    }

    @TestBase.STI(value=6)
    public void testIsInGroup_InvalidGroup() throws XPSException {
        logger.debug((Object)"***Testing User isInGroup (NEGATIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserGrpDN, list);
        boolean bl = user.isInGroup("jnjrehfuhhnn");
        UserTest.assertFalse((boolean)bl);
    }

    @TestBase.STI(value=7)
    public void testSetPasswordMustChange() throws XPSException {
        logger.debug((Object)"***Testing User setPasswordMustChange (POSITIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserPwdDN, list);
        user.setPasswordMustChange();
        user.enable(0);
    }

    @TestBase.STI(value=8)
    public void testValidatePassword() throws XPSException {
        logger.debug((Object)"***Testing User validatePassword (POSITIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserPwdDN, list);
        ValidatePasswordResponse validatePasswordResponse = user.validatePassword("TestPassword1234&Abc", false, false);
        UserTest.assertTrue((String)"Password must be valid", (boolean)validatePasswordResponse.isValid());
    }

    @TestBase.STI(value=9)
    public void testGetAttributes() throws XPSException {
        logger.debug((Object)"***Testing User getDisabled (POSITIVE)***");
        ArrayList<String> arrayList = null;
        User user = dir.fetchUser(fullUserGrpDN, arrayList);
        arrayList = new ArrayList<String>();
        arrayList.add(pwdDataAttr);
        Map map = user.getAttributes(arrayList);
        UserTest.assertNotNull((String)"user.getAttributes() returned null", (Object)map);
        List list = (List)map.get(pwdDataAttr);
        UserTest.assertNotNull((String)"fetching password attribute resulted in null value", (Object)list);
    }

    @TestBase.STI(value=10)
    public void testSetAttributes() throws XPSException {
        List list;
        logger.debug((Object)"***Testing User getDisabled (POSITIVE)***");
        ArrayList<String> arrayList = null;
        User user = dir.fetchUser(fullUserGrpDN, arrayList);
        arrayList = new ArrayList<String>();
        arrayList.add(pwdDataAttr);
        Map map = user.getAttributes(arrayList);
        UserTest.assertNotNull((String)"user.getAttributes() returned null", (Object)map);
        List list2 = list = (List)map.get(pwdDataAttr);
        list2.set(0, "2");
        HashMap<String, List> hashMap = new HashMap<String, List>();
        hashMap.put(pwdDataAttr, list2);
        int n = user.setAttributes(hashMap);
        UserTest.assertTrue((String)"testUser.setAttributes() must return zero value", (n > 0 ? 1 : 0) != 0);
        HashMap<String, List> hashMap2 = new HashMap<String, List>();
        hashMap2.put(pwdDataAttr, list);
        user.setAttributes(hashMap2);
    }

    @TestBase.STI(value=11)
    public void testValidateNewPassword() throws XPSException {
        logger.debug((Object)"***Testing User validateNewPassword (POSITIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserPwdDN, list);
        ValidatePasswordResponse validatePasswordResponse = user.validateNewPassword("OrigPassword11", "NewPassword11", false, false);
        UserTest.assertTrue((String)"validate password failed", (boolean)validatePasswordResponse.isValid());
    }

    @TestBase.STI(value=12)
    public void testChangePassword_NotRequireOldPassword() throws XPSException {
        logger.debug((Object)"***Testing User changePassword (POSITIVE)***");
        List list = null;
        User user = dir.fetchUser(fullUserPwdDN, list);
        user.changePassword("", "NewPassword11", true);
        user.changePassword("", "OrigPassword11", true);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)UserTest.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(UserTest.class);
    }
}

