/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.KeyManagement;
import com.ca.siteminder.sdk.adminapi.Server;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.VerifyEntryResult;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.EnumSet;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class ServerTest
extends TestBaseDMS {
    private static final Logger logger = Logger.getLogger(ServerTest.class);
    private static KeyManagement keyMgt;
    static String desc;
    static String realmName;
    static Realm realm;
    private static String dirPath;
    private static String userLoginName;
    private static Session newAdminSession;

    @Override
    public void setUpSuite() {
        super.setUpSuite();
        ServerTest.breakdown(SetupConnection.session);
        EnumSet<Admin.Rights> enumSet = EnumSet.noneOf(Admin.Rights.class);
        EnumSet<Administrator.Flags> enumSet2 = EnumSet.noneOf(Administrator.Flags.class);
        Integer n = 4096;
        ServerTest.createNewAdmin(SetupConnection.session, "CA.XPS::SecurityCategory@!Policy Server Administration", enumSet, enumSet2, n);
        String string = ServerTest.getSpec(SetupConnection.session);
        newAdminSession = ServerTest.login(SetupConnection.session, string);
    }

    @TestBase.STI(value=1)
    public void testFlushALL() throws XPSException {
        logger.debug((Object)"***Testing Server flush ALL (POSITIVE)***");
        SetupConnection.getServer().flush(Server.FlushType.FLUSH_ALL);
    }

    @TestBase.STI(value=2)
    public void testFlushUSERS() throws XPSException {
        logger.debug((Object)"***Testing Server flush USERS (POSITIVE)***");
        SetupConnection.getServer().flush(Server.FlushType.FLUSH_USERS);
    }

    @TestBase.STI(value=3)
    public void testFlushREALMS() throws XPSException {
        logger.debug((Object)"***Testing Server flush REALMS(POSITIVE)***");
        SetupConnection.getServer().flush(Server.FlushType.FLUSH_REALMS);
    }

    @TestBase.STI(value=4)
    public void testFlushRealm() throws XPSException {
        logger.debug((Object)"***Testing Server flushRealm (POSITIVE)***");
        SetupConnection.builder.doDomainSetUp("TestRealmUserDir" + System.currentTimeMillis(), "TestRealmAgent1" + System.currentTimeMillis(), null, "TestRealmDomain" + System.currentTimeMillis(), "TestRealm" + System.currentTimeMillis(), null, null, null);
        List list = SetupConnection.session.getPolicyData().search((IClass)Realm.ddclass);
        realm = (Realm)list.get(0);
        SetupConnection.getServer().flushRealm(realm.getXid());
    }

    @TestBase.STI(value=5)
    public void testFlushRealmEmptyRealm() throws XPSException {
        logger.debug((Object)"***Testing Server flushRealm (NEGATIVE)***");
        try {
            SetupConnection.getServer().flushRealm("");
            ServerTest.fail((String)"Flushing an empty realm id succeeded.");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.flushRealm", (String)serverException.getTag(), (String)"server.flushRealm");
            ServerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
    }

    @TestBase.STI(value=6)
    public void testFlushRealmInvalidRealm() throws XPSException {
        logger.debug((Object)"***Testing Server flushRealm (NEGATIVE)***");
        try {
            String string = "CA.SM::Realm@06-0c151ef4-fc61-4cce-b6f8-7a67a7a41111";
            SetupConnection.getServer().flushRealm(string);
            ServerTest.fail((String)"flushRealm for invalid realm succeeded.");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.flushRealm", (String)serverException.getTag(), (String)"server.flushRealm");
            ServerTest.assertTrue((String)"Exception must contain \"Invalid ID\"", (boolean)serverException.getMsg().contains("Invalid ID"));
        }
    }

    @TestBase.STI(value=7)
    public void testFlushUser() throws XPSException {
        logger.debug((Object)"***Testing Server flushUser (POSITIVE)***");
        SetupConnection.getServer().flushUser(dir.getXID(), userSearchName);
    }

    @TestBase.STI(value=8)
    public void testFlushEpmtyUser() throws XPSException {
        logger.debug((Object)"***Testing Server flushUser (NEGATIVE)***");
        String string = "";
        try {
            SetupConnection.getServer().flushUser(dir.getXID(), string);
            ServerTest.fail((String)"empty user dn is flushed successfully");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.flushUser", (String)serverException.getTag(), (String)"server.flushUser");
            ServerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
        try {
            SetupConnection.getServer().flushUser("", "");
            ServerTest.fail((String)"flushed empty userdn with empty user directory successfully.");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.flushUser", (String)serverException.getTag(), (String)"server.flushUser");
            ServerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
    }

    @TestBase.STI(value=9)
    public void testChangeKeyDYNAMIC_KEY() throws XPSException {
        ServerTest.skip("Use Dynamic Key (through FSS GUI) must be enabled for this test case to pass");
    }

    @TestBase.STI(value=10)
    public void testChangeKeyPERSISTENT_KEY() throws XPSException {
        logger.debug((Object)"***Testing Server changeKey PERSISTENT_KEY (POSITIVE)***");
        SetupConnection.getServer().changeKey(Server.KeyType.PERSISTENT_KEY, "TestVAL");
    }

    @TestBase.STI(value=11)
    public void testChangeKeyPERSISTENT_KEY2() throws XPSException {
        logger.debug((Object)"***Testing Server changeKey PERSISTENT_KEY (NEGATIVE)***");
        try {
            SetupConnection.getServer().changeKey(Server.KeyType.PERSISTENT_KEY, "");
            ServerTest.fail((String)"Changing persistent key succeeded.");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.changeKey", (String)serverException.getTag(), (String)"server.changeKey");
            ServerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
    }

    @TestBase.STI(value=12)
    public void testChangeKeySESSION_KEY2() throws XPSException {
        logger.debug((Object)"***Testing Server changeKey SESSION_KEY (NEGATIVE)***");
        try {
            SetupConnection.getServer().changeKey(Server.KeyType.SESSION_KEY, "");
            ServerTest.fail((String)"Changing Session key to empty key succeeded");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.changeKey", (String)serverException.getTag(), (String)"server.changeKey");
            ServerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
    }

    @TestBase.STI(value=13)
    public void testChangeKeySHARED_SECRET_KEY() throws XPSException {
        logger.debug((Object)"***Testing Server changeKey SHARED_SECRET_KEY (POSITIVE)***");
        SetupConnection.getServer().changeKey(Server.KeyType.SHARED_SECRET_KEY, "");
    }

    @TestBase.STI(value=14)
    public void testChangeKeyPASSWORDBLOB_KEY() throws XPSException {
        logger.debug((Object)"***Testing Server changeKey PASSWORDBLOB_KEY (POSITIVE)***");
        try {
            SetupConnection.getServer().changeKey(Server.KeyType.PASSWORDBLOB_KEY, "TestVAL");
        }
        catch (ServerException serverException) {
            // empty catch block
        }
    }

    @TestBase.STI(value=15)
    public void testChangeKeyPASSWORDBLOB_KEY2() throws XPSException {
        logger.debug((Object)"***Testing Server changeKey PASSWORDBLOB_KEY (POSITIVE)***");
        try {
            SetupConnection.getServer().changeKey(Server.KeyType.PASSWORDBLOB_KEY, "");
            ServerTest.fail((String)"Changing password blob key to empty key succeeded.");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.changeKey", (String)serverException.getTag(), (String)"server.changeKey");
            ServerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
    }

    @TestBase.STI(value=16)
    public void testChangeKeySESSION_TOBLOB_KEY() throws XPSException {
        logger.debug((Object)"***Testing Server changeKey SESSION_TOBLOB_KEY (POSITIVE)***");
        try {
            SetupConnection.getServer().changeKey(Server.KeyType.SESSION_TOBLOB_KEY, "");
        }
        catch (ServerException serverException) {
            // empty catch block
        }
    }

    @TestBase.STI(value=17)
    public void testFetchKeyStoreAttribs() throws XPSException {
        logger.debug((Object)"***Testing Server fetchKeyStoreAttribs (POSITIVE)***");
        keyMgt = newAdminSession.getServer().fetchKeyStoreAttribs();
        ServerTest.assertNotNull((String)"keyMgt.getChangeFrequency() returned null", (Object)keyMgt.getChangeFrequency());
        ServerTest.assertNotNull((String)"keyMgt.getChangeValue() returned null", (Object)keyMgt.getChangeValue());
        ServerTest.assertNotNull((String)"keyMgt.getOid() returned null", (Object)keyMgt.getOid());
        ServerTest.assertNotNull((String)"keyMgt.getNewKeyTime() returned null", (Object)keyMgt.getNewKeyTime());
        ServerTest.assertNotNull((String)"keyMgt.getOldKeyTime() returned null", (Object)keyMgt.getOldKeyTime());
    }

    @TestBase.STI(value=18)
    public void testFetchKeyStoreAttribsAdminWithoutManagePrivs() throws XPSException {
        logger.debug((Object)"***Testing Server fetchKeyStoreAttribs (NEGATIVE)***");
        try {
            SetupConnection.getServer().fetchKeyStoreAttribs();
            ServerTest.fail((String)"fetchKeyStoreAttribs must fail with no authorized admin");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.fetchKeyStoreAttribs", (String)serverException.getTag(), (String)"server.fetchKeyStoreAttribs");
            ServerTest.assertTrue((String)"Exception expected \"Insufficient Rights\"", (boolean)serverException.getMsg().contains("Insufficient rights"));
        }
    }

    @TestBase.STI(value=19)
    public void testSaveKeyStoreAttribs() throws XPSException {
        logger.debug((Object)"***Testing Server saveKeyStoreAttribs (POSITIVE)***");
        newAdminSession.getServer().saveKeyStoreAttribs(keyMgt);
    }

    @TestBase.STI(value=20)
    public void testSaveKeyStoreAttribsAdminWithoutPrivs() throws XPSException {
        logger.debug((Object)"***Testing Server saveKeyStoreAttribs (NEGATIVE)***");
        try {
            SetupConnection.getServer().saveKeyStoreAttribs(keyMgt);
            ServerTest.fail((String)"Key store attributes saved successfully without admin.");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.saveKeyStoreAttribs", (String)serverException.getTag(), (String)"server.saveKeyStoreAttribs");
            ServerTest.assertTrue((String)"Exception expected \"Insufficient Rights\"", (boolean)serverException.getMsg().contains("Insufficient rights"));
        }
    }

    @TestBase.STI(value=21)
    public void testVerifyEntry() throws XPSException {
        logger.debug((Object)"***Testing Server verifyEntry (POSITIVE)***");
        VerifyEntryResult verifyEntryResult = SetupConnection.getServer().verifyEntry(dir.getXID(), userSearchName);
        ServerTest.assertTrue((String)"result resolution must be in range from 0 to 13", (verifyEntryResult.getResolution() >= 0 && verifyEntryResult.getResolution() <= 13 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=22)
    public void testVerifyEntryEmptyString() throws XPSException {
        logger.debug((Object)"***Testing Server verifyEntry (NEGATIVE)***");
        try {
            SetupConnection.getServer().verifyEntry("", "");
            ServerTest.fail((String)"Verifying empty string succeeded");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.verifyEntry", (String)serverException.getTag(), (String)"server.verifyEntry");
            ServerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
    }

    @TestBase.STI(value=23)
    public void testVerifyEntryInvalidString() throws XPSException {
        logger.debug((Object)"***Testing Server verifyEntry (NEGATIVE)***");
        try {
            SetupConnection.getServer().verifyEntry("ddsds", "dsds");
            ServerTest.fail((String)"Empty invalid string verified successfully");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.verifyEntry", (String)serverException.getTag(), (String)"server.verifyEntry");
            ServerTest.assertTrue((String)"Exception expected \"User Directory not found\"", (boolean)serverException.getMsg().contains("User Directory not found"));
        }
    }

    @TestBase.STI(value=24)
    public void testParseExpression() throws XPSException {
        logger.debug((Object)"***Testing Server parseExpression (POSITIVE)***");
        String string = SetupConnection.getServer().parseExpression("1 < 2");
        ServerTest.assertTrue((String)"parseExpresssion result must contain Result=\"OK\"", (boolean)string.contains("Result=\"Ok"));
    }

    @TestBase.STI(value=25)
    public void testParseExpressionEmptyString() throws XPSException {
        logger.debug((Object)"***Testing Server parseExpression (NEGATIVE)***");
        try {
            SetupConnection.getServer().parseExpression("");
            ServerTest.fail((String)"Empty expression parsed successfully.");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.parseExpression", (String)serverException.getTag(), (String)"server.parseExpression");
            ServerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
    }

    @TestBase.STI(value=26)
    public void testParseExpressionInvalidString() throws XPSException {
        logger.debug((Object)"***Testing Server parseExpression (NEGATIVE)***");
        try {
            SetupConnection.getServer().parseExpression("4==1");
            ServerTest.fail((String)"Invalid string parsed successfully.");
        }
        catch (ServerException serverException) {
            ServerTest.assertEquals((String)"Exception tag must match server.parseExpression", (String)serverException.getTag(), (String)"server.parseExpression");
            ServerTest.assertTrue((String)"Exception expected \"syntax error\"", (boolean)serverException.getMsg().contains("syntax error"));
        }
    }

    @TestBase.STI(value=27)
    public void testParseExpression2() throws XPSException {
        logger.debug((Object)"***Testing Server parseExpression (POSITIVE)***");
        String string = SetupConnection.getServer().parseExpression("1 < 2");
        ServerTest.assertTrue((String)"parseExpresssion result must contain Result=\"OK\"", (boolean)string.contains("Result=\"Ok"));
    }

    @TestBase.STI(value=28)
    public void testChangeKeySESSION_KEY() throws XPSException {
        logger.debug((Object)"***Testing Server changeKey SESSION_KEY (POSITIVE)***");
        SetupConnection.getServer().changeKey(Server.KeyType.SESSION_KEY, "TestVAL" + System.currentTimeMillis());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ServerTest.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(ServerTest.class);
    }

    static {
        desc = "XXXX";
        realmName = "JUnitTestRealm";
        realm = null;
        dirPath = null;
        userLoginName = null;
        newAdminSession = null;
    }
}

