/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.ResultEntry;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Expression;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapi.filter.UserLookupExpr;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class DirectoryTest
extends TestBaseDMS {
    private static final Logger logger = Logger.getLogger(DirectoryTest.class);

    @Override
    public void setUpSuite() {
        super.setUpSuite();
    }

    @TestBase.STI(value=1)
    public void testFetchUserRoot() throws XPSException {
        logger.debug((Object)"***Testing Fetch User (POSITIVE) in root directory***");
        List list = null;
        dir.fetchUser(fullUserSrcDN, list);
    }

    @TestBase.STI(value=2)
    public void testFetchUserInvalidDn() throws XPSException {
        logger.debug((Object)"***Testing Fetch User (NEGATIVE) in sub-directory using invalid DN***");
        String string = "ckkkkkddkk";
        List list = null;
        try {
            dir.fetchUser(string, list);
            DirectoryTest.fail((String)"fetchUser succeeded for invalid DN");
        }
        catch (ServerException serverException) {
            DirectoryTest.assertEquals((String)"Exception tag must match directory.fetchUser", (String)serverException.getTag(), (String)"directory.fetchUser");
        }
    }

    @TestBase.STI(value=3)
    public void testFetchUserEmptyDn() throws XPSException {
        logger.debug((Object)"***Testing Fetch User (NEGATIVE) using EMPTY DN***");
        List list = null;
        try {
            dir.fetchUser("", list);
            DirectoryTest.fail((String)"fetchUser succeeded for empty DN");
        }
        catch (ServerException serverException) {
            DirectoryTest.assertEquals((String)"Exception tag must match directory.fetchUser", (String)serverException.getTag(), (String)"directory.fetchUser");
        }
    }

    @TestBase.STI(value=4)
    public void testCheckConnectionStore() throws XPSException {
        logger.debug((Object)"***Testing Fetch User (POSITIVE) in root directory***");
        int n = dir.checkConnection();
        DirectoryTest.assertEquals((String)"Directory is not reachable", (int)0, (int)n);
    }

    @TestBase.STI(value=5)
    public void testSearchUsingClauseExpr_All_Users() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        Clause clause = new Clause(uid, Clause.Operator.ENDSWITH, (Object)"");
        List list = dir.search(null, (Expression)clause, searchOptions);
        DirectoryTest.assertNotNull((String)"directory.search returned null", (Object)list);
        DirectoryTest.assertFalse((String)"directory.search returned empty list", (boolean)list.isEmpty());
    }

    @TestBase.STI(value=6)
    public void testSearchUsingClauseExpr_Specific_User() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        Clause clause = new Clause(uid, Clause.Operator.EQUAL, (Object)userSearchName);
        List list = dir.search(null, (Expression)clause, searchOptions);
        DirectoryTest.assertTrue((String)("directory search result list must contain user \"" + userSearchName + "\""), (boolean)((ResultEntry)list.get(0)).getDN().contains(userSearchName));
    }

    @TestBase.STI(value=7)
    public void testSearchUsingClauseExpr_Contains_User() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        Clause clause = new Clause(uid, Clause.Operator.BEGINSWITH, (Object)"user", false);
        List list = dir.search(null, (Expression)clause, searchOptions);
        DirectoryTest.assertFalse((String)"directory search result list must contain some users ", (boolean)list.isEmpty());
    }

    @TestBase.STI(value=8)
    public void testSearchUsingUserLookupExpr() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        UserLookupExpr userLookupExpr = new UserLookupExpr(UserLookupExpr.Operator.EQUAL, (Object)userSearchName);
        List list = dir.search(userLookupExpr, null, searchOptions);
        DirectoryTest.assertNotNull((String)"directory.search returned null", (Object)list);
        DirectoryTest.assertTrue((String)("directory search result list must contain user \"" + userSearchName + "\""), (boolean)((ResultEntry)list.get(0)).getDN().contains(userSearchName));
    }

    @TestBase.STI(value=9)
    public void testSearchUsingBooleanExpr() throws XPSException {
        logger.debug((Object)"***Testing search (POSITIVE)***");
        Clause clause = new Clause(uid, Clause.Operator.CONTAINS, (Object)"");
        Clause clause2 = new Clause(uid, Clause.Operator.CONTAINS, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        Filter filter2 = new Filter((Expression)clause2);
        filter.ANDNOT(filter2);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTest.assertNotNull((String)"directory.search returned null", (Object)list);
        DirectoryTest.assertFalse((String)"directory.search returned empty list", (boolean)list.isEmpty());
        for (ResultEntry resultEntry : list) {
            if (!resultEntry.getDN().equals(fullUserSrcDN)) continue;
            DirectoryTest.fail((String)("Result cannot contain " + fullUserSrcDN));
        }
    }

    @TestBase.STI(value=10)
    public void testGetCapabilities() throws XPSException {
        logger.debug((Object)"***Testing GetCapabilities of UD (POSITIVE)***");
        long l = dir.getCapabilities();
        DirectoryTest.assertTrue((l > 0L ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DirectoryTest.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(DirectoryTest.class);
    }
}

