/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.EnumSet;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class DirectoryManagerTestAdminWithNoRights
extends TestBaseDMS {
    private static final Logger logger = Logger.getLogger(DirectoryManagerTestAdminWithNoRights.class);
    private static Session newAdminSession = null;
    private static String dirPath = null;

    @Override
    public void setUpSuite() {
        super.setUpSuite();
        DirectoryManagerTestAdminWithNoRights.breakdown(SetupConnection.session);
        EnumSet<Admin.Rights> enumSet = EnumSet.noneOf(Admin.Rights.class);
        EnumSet<Administrator.Flags> enumSet2 = EnumSet.noneOf(Administrator.Flags.class);
        DirectoryManagerTestAdminWithNoRights.createNewAdmin(SetupConnection.session, null, enumSet, enumSet2, null);
        String string = DirectoryManagerTestAdminWithNoRights.getSpec(SetupConnection.session);
        newAdminSession = DirectoryManagerTestAdminWithNoRights.login(SetupConnection.session, string);
        dirPath = this.getUserDirectoryPath();
    }

    @TestBase.STI(value=1)
    public void testGetDirectory() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (NEGATIVE) by Unauthorized Admin using dir namespace, path***");
        try {
            newAdminSession.getDirectoryManager().getDirectory(strUDNamespace, dirPath);
            DirectoryManagerTestAdminWithNoRights.fail((String)"GetDirectory must fail with no authorized admin");
        }
        catch (ServerException serverException) {
            DirectoryManagerTestAdminWithNoRights.assertEquals((String)"Exception tag does must match directoryManager.getDirectory", (String)serverException.getTag(), (String)"directoryManager.getDirectory");
            DirectoryManagerTestAdminWithNoRights.assertTrue((String)"Exception expected because of user insufficient rights", (boolean)serverException.getMsg().contains("Insufficient rights"));
        }
    }

    @TestBase.STI(value=2)
    public void testGetDirectoryUsingXid() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (NEGATIVE) by Unauthorized Admin using dir XID***");
        try {
            newAdminSession.getDirectoryManager().getDirectory(strUDXID);
            DirectoryManagerTestAdminWithNoRights.fail((String)"GetDirectory with XID should fail with no authorized admin");
        }
        catch (ServerException serverException) {
            DirectoryManagerTestAdminWithNoRights.assertEquals((String)"Exception tag must match directoryManager.getDirectory", (String)serverException.getTag(), (String)"directoryManager.getDirectory");
            DirectoryManagerTestAdminWithNoRights.assertTrue((String)"Exception expected because of user insufficient rights", (boolean)serverException.getMsg().contains("Insufficient rights"));
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DirectoryManagerTestAdminWithNoRights.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(DirectoryManagerTestAdminWithNoRights.class);
    }
}

