/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.Directory;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class DirectoryManagerTest
extends TestBaseDMS {
    private static final Logger logger = Logger.getLogger(DirectoryManagerTest.class);
    protected static String XID = null;
    private static String dirPath = null;

    @Override
    public void setUpSuite() {
        super.setUpSuite();
        dirPath = this.getUserDirectoryPath();
    }

    @TestBase.STI(value=1)
    public void testGetDirectoryUsingEmptyStrings() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (NEGATIVE) by Authorized Admin using EMPTY dir namespace, path***");
        try {
            SetupConnection.getDirectoryManager().getDirectory("", "");
            DirectoryManagerTest.fail((String)"Getdirectory with empty string must fail");
        }
        catch (ServerException serverException) {
            DirectoryManagerTest.assertEquals((String)"Exception tag must match directoryManager.getDirectory", (String)serverException.getTag(), (String)"directoryManager.getDirectory");
            DirectoryManagerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
    }

    @TestBase.STI(value=2)
    public void testGetDirectoryUsingEmptyXid() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (NEGATIVE) by Authorized Admin using EMPTY dir XID***");
        try {
            SetupConnection.getDirectoryManager().getDirectory("");
            DirectoryManagerTest.fail((String)"GetDirectory with empty XID must fail");
        }
        catch (ServerException serverException) {
            DirectoryManagerTest.assertEquals((String)"Exception tag must match directoryManager.getDirectory", (String)serverException.getTag(), (String)"directoryManager.getDirectory");
            DirectoryManagerTest.assertTrue((String)"Exception expected \"Bad argument(s) to EPM interface\"", (boolean)serverException.getMsg().contains("Bad argument(s) to EPM interface"));
        }
    }

    @TestBase.STI(value=3)
    public void testGetDirectory() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (POSITIVE) by Authorized Admin using dir namespace, path***");
        Directory directory = SetupConnection.getDirectoryManager().getDirectory(strUDNamespace, dirPath);
        XID = directory.getXID();
        DirectoryManagerTest.assertTrue((String)"Fetched directory XID must be of class CA.SM::UserDirectory", (boolean)XID.contains("CA.SM::UserDirectory"));
    }

    @TestBase.STI(value=4)
    public void testGetDirectoryUsingXid() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (POSITIVE) by Authorized Admin using dir XID***");
        SetupConnection.getDirectoryManager().getDirectory(XID);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DirectoryManagerTest.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(DirectoryManagerTest.class);
    }
}

