/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.xps;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Workspace;
import com.ca.siteminder.sdk.adminapi.ca.xps.WorkspaceEntry;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.basic.sm.AdminTest;
import com.ca.siteminder.sdk.adminapitest.basic.xps.WorkspaceTest;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class WorkspaceEntryTest
extends TestBase {
    static WorkspaceEntry wsentry;
    static Workspace workspace;
    static XPSObject member;

    @TestBase.STI(value=1)
    public void testCreatWorkspaceEntry() throws XPSException {
        wsentry = WorkspaceEntryTest.makeWorkspaceEntry(null, null);
        this.createObject((XPSObject)wsentry);
        member = wsentry.getMember();
        workspace = wsentry.getParent();
    }

    @TestBase.STI(value=2)
    public void testSearchWorkspaceEntry() throws XPSException {
        Filter filter = new Filter((IAttribute)WorkspaceEntry.MEMBER, Clause.Operator.EQUAL, (Object)member);
        List list = SetupConnection.policyData.search((IClass)WorkspaceEntry.ddclass, filter);
        WorkspaceEntryTest.assertEquals((String)"entries", (int)1, (int)list.size());
    }

    @TestBase.STI(value=3)
    public void testUpdateWorkspaceEntry() throws XPSException {
        wsentry.setReadOnly(Boolean.valueOf(false));
        this.updateObject((XPSObject)wsentry);
    }

    @TestBase.STI(value=4)
    public void testWorkspaceEntryDeployment() throws XPSException {
        try {
            InternalTesting.testDeployment(SetupConnection.session, (XPSObject)wsentry);
            WorkspaceEntryTest.fail((String)"exported workspaceEntry");
        }
        catch (ServerException serverException) {
            WorkspaceEntryTest.assertContains(serverException.getMsg(), "not exportable");
        }
    }

    @TestBase.STI(value=5)
    public void testDeleteWorkspaceEntry() throws XPSException {
        this.deleteObject((XPSObject)wsentry);
        wsentry = null;
    }

    @TestBase.STI(value=6)
    public void testWorkspaceEntryWithoutMember() throws XPSException {
        wsentry = WorkspaceEntryTest.makeWorkspaceEntry(workspace, member);
        wsentry.clearMember();
        this.failCreate((XPSObject)wsentry, "Entry");
    }

    @TestBase.STI(value=7)
    public void testWorkspaceEntrySameMember() throws XPSException {
        wsentry = WorkspaceEntryTest.makeWorkspaceEntry(workspace, member);
        this.createObject((XPSObject)wsentry);
        wsentry = WorkspaceEntryTest.makeWorkspaceEntry(workspace, member);
        this.failCreate((XPSObject)wsentry, "Assert");
    }

    @TestBase.STI(value=8)
    public void testWorkspaceEntryNonrootMember() throws XPSException {
        Domain domain = (Domain)member;
        String string = "Policy2" + SetupConnection.random;
        Policy policy = SetupConnection.builder.makePolicy(string, domain);
        this.createObject((XPSObject)policy);
        wsentry = WorkspaceEntryTest.makeWorkspaceEntry(workspace, (XPSObject)policy);
        this.failCreate((XPSObject)wsentry, "Assert");
    }

    @TestBase.STI(value=9)
    public void selfReference() {
        wsentry = WorkspaceEntryTest.makeWorkspaceEntry(workspace, (XPSObject)workspace);
        this.failCreate((XPSObject)wsentry, "Assert");
    }

    @TestBase.STI(value=10)
    public void implicitToExplicit() {
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        wsentry = WorkspaceEntryTest.makeWorkspaceEntry(workspace, (XPSObject)agentType);
        this.createObject((XPSObject)wsentry);
    }

    @TestBase.STI(value=11)
    public void circular() {
        Workspace workspace = WorkspaceTest.makeWorkspace("ws2" + SetupConnection.random);
        SetupConnection.createObject((XPSObject)workspace);
        WorkspaceEntry workspaceEntry = WorkspaceEntryTest.makeWorkspaceEntry(WorkspaceEntryTest.workspace, (XPSObject)workspace);
        SetupConnection.createObject((XPSObject)workspaceEntry);
        WorkspaceEntry workspaceEntry2 = WorkspaceEntryTest.makeWorkspaceEntry(workspace, (XPSObject)WorkspaceEntryTest.workspace);
        this.failCreate((XPSObject)workspaceEntry2, "Assert");
    }

    @TestBase.STI(value=12)
    public void legacyAdmin() {
        String string = "smadmin_" + SetupConnection.random;
        Admin admin = AdminTest.makeAdmin(string);
        this.createObject((XPSObject)admin);
        String string2 = admin.getXid();
        String string3 = string2.substring("CA.SM::Admin@12-".length());
        String string4 = "CA.XPS::Administrator@" + string3;
        Administrator administrator = (Administrator)SetupConnection.policyData.fetchObject(string4);
        wsentry = WorkspaceEntryTest.makeWorkspaceEntry(workspace, (XPSObject)administrator);
        this.failCreate((XPSObject)wsentry, "Assert");
    }

    static WorkspaceEntry makeWorkspaceEntry(Workspace workspace, XPSObject xPSObject) {
        WorkspaceEntry workspaceEntry = (WorkspaceEntry)SetupConnection.policyData.newObject((IClass)WorkspaceEntry.ddclass);
        workspaceEntry.setReadOnly(Boolean.valueOf(true));
        if (workspace == null) {
            workspace = WorkspaceTest.makeWorkspace("wsentry" + SetupConnection.random);
            SetupConnection.createObject((XPSObject)workspace);
        }
        workspaceEntry.setParent(workspace);
        if (xPSObject == null) {
            Domain domain = (Domain)SetupConnection.policyData.newObject((IClass)Domain.ddclass);
            domain.setName("domain" + SetupConnection.random);
            SetupConnection.createObject((XPSObject)domain);
            xPSObject = domain;
        }
        workspaceEntry.setMember(xPSObject);
        return workspaceEntry;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)WorkspaceEntryTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(WorkspaceEntryTest.class);
    }
}

