/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.xps;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.xps.Expression;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.HashSet;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ExpressionTest
extends TestBase {
    static Expression expression;

    @TestBase.STI(value=1)
    public void testCreateExpression() throws XPSException {
        String string = "@Expression" + SetupConnection.random;
        expression = this.makeExpression(string);
        this.createObject((XPSObject)expression);
    }

    @TestBase.STI(value=2)
    public void testSearchExpression() throws XPSException {
        SetupConnection.fetchByName(Expression.ddclass, expression.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateExpression() throws XPSException {
        expression.setDescription("update" + expression.getDescription());
        this.updateObject((XPSObject)expression);
    }

    @TestBase.STI(value=4)
    public void testExpressionDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)expression);
    }

    @TestBase.STI(value=5)
    public void testDeleteExpression() throws XPSException {
        this.deleteObject((XPSObject)expression);
        expression = null;
    }

    @TestBase.STI(value=6)
    public void testExpressionWithoutName() throws XPSException {
        expression = this.makeExpression(null);
        this.failCreate((XPSObject)expression, "Name");
    }

    @TestBase.STI(value=7)
    public void testExpressionWithoutExpression() throws XPSException {
        String string = "@updateExpression1" + SetupConnection.random;
        expression = this.makeExpression(string);
        expression.clearExpression();
        this.failCreate((XPSObject)expression, "Expression");
    }

    private Expression makeExpression(String string) throws XPSException {
        Expression expression = (Expression)SetupConnection.policyData.newObject((IClass)Expression.ddclass);
        HashSet<Expression.Flags> hashSet = new HashSet<Expression.Flags>();
        hashSet.add(Expression.Flags.Disabled);
        if (string != null) {
            expression.setName(string);
        }
        expression.setDescription("XPSAPI JUnit Sample Expression");
        expression.setExpression("100=100");
        expression.setFlags(hashSet);
        return expression;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ExpressionTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ExpressionTest.class);
    }
}

