/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.VariableType;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class VariableTypeTest
extends TestBase {
    static VariableType variableType;

    @TestBase.STI(value=1)
    public void testCreateVariableType() throws XPSException {
        String string = "VariableType" + SetupConnection.random;
        variableType = this.makeVariableType(string);
        this.createObject((XPSObject)variableType);
    }

    @TestBase.STI(value=2)
    public void testSearchVariableType() {
        SetupConnection.fetchByName(VariableType.ddclass, variableType.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateVariableType() throws XPSException {
        variableType.setName("update" + variableType.getName());
        variableType.setDesc("update" + variableType.getDesc());
        this.updateObject((XPSObject)variableType);
    }

    @TestBase.STI(value=4)
    public void testVariableTypeDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)variableType);
    }

    @TestBase.STI(value=5)
    public void testDeleteVariableType() throws XPSException {
        this.deleteObject((XPSObject)variableType);
        variableType = null;
    }

    @TestBase.STI(value=6)
    public void testVariableTypeWithoutName() throws XPSException {
        variableType = this.makeVariableType(null);
        this.failCreate((XPSObject)variableType, "Name");
    }

    private VariableType makeVariableType(String string) throws XPSException {
        VariableType variableType = (VariableType)SetupConnection.policyData.newObject((IClass)VariableType.ddclass);
        if (string != null) {
            variableType.setName(string);
        }
        variableType.setDesc("XPSAPI JUnit Sample VariableType");
        variableType.setFilter("100 = 100");
        return variableType;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)VariableTypeTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(VariableTypeTest.class);
    }
}

