/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IdentityMapping;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.sm.ValidateIdentityMappingEntry;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ValidateIdentityMappingEntryTest
extends TestBase {
    static IdentityMapping mapping;
    static ValidateIdentityMappingEntry validateIdentityMappingEntry;

    @TestBase.STI(value=1)
    public void testCreateValidateIdentityMappingEntry() throws XPSException {
        SetupConnection.builder.doIdentityMappingSetup("ValidateIdentityMappingEntry" + SetupConnection.random, "validate");
        SetupConnection.builder.doUserDirSetUp("userDirValidateIdentityMappingEntry" + SetupConnection.random);
        mapping = (IdentityMapping)SetupConnection.fetchByName(IdentityMapping.ddclass, "ValidateIdentityMappingEntry" + SetupConnection.random);
        String string = "ValidateIdentityMappingEntry" + SetupConnection.random;
        validateIdentityMappingEntry = this.makeValidateIdentityMappingEntry(string, mapping);
        this.createObject((XPSObject)validateIdentityMappingEntry);
    }

    @TestBase.STI(value=2)
    public void testSearchValidateIdentityMappingEntry() {
        SetupConnection.fetchByName(ValidateIdentityMappingEntry.ddclass, validateIdentityMappingEntry.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateValidateIdentityMappingEntry() throws XPSException {
        validateIdentityMappingEntry.setName("update" + validateIdentityMappingEntry.getName());
        validateIdentityMappingEntry.setDescription("update" + validateIdentityMappingEntry.getDescription());
        this.updateObject((XPSObject)validateIdentityMappingEntry);
    }

    @TestBase.STI(value=4)
    public void testValidateIdentityMappingEntryDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)validateIdentityMappingEntry);
    }

    @TestBase.STI(value=5)
    public void testdeleteAzValidateIdentityMappingEntry() throws XPSException {
        this.deleteObject((XPSObject)validateIdentityMappingEntry);
        validateIdentityMappingEntry = null;
    }

    @TestBase.STI(value=6)
    public void testValidateIdentityMappingEntryWithoutName() throws XPSException {
        validateIdentityMappingEntry = this.makeValidateIdentityMappingEntry(null, mapping);
        this.failCreate((XPSObject)validateIdentityMappingEntry, "Name");
    }

    @TestBase.STI(value=7)
    public void testValidateIdentityMappingEntryWithoutParent() throws XPSException {
        String string = "ValidateIdentityMappingEntry2" + SetupConnection.random;
        validateIdentityMappingEntry = this.makeValidateIdentityMappingEntry(string, null);
        this.failCreate((XPSObject)validateIdentityMappingEntry, "parent");
    }

    @TestBase.STI(value=8)
    public void testValidateIdentityMappingEntryWithoutExpression() throws XPSException {
        String string = "ValidateIdentityMappingEntry3" + SetupConnection.random;
        validateIdentityMappingEntry = this.makeValidateIdentityMappingEntry(string, mapping);
        validateIdentityMappingEntry.clearUserSearchExpression();
        this.failCreate((XPSObject)validateIdentityMappingEntry, "UserSearchExpression");
    }

    @TestBase.STI(value=9)
    public void testCreateValidateIdentityMapWithAzIdentityMap() throws XPSException {
        SetupConnection.builder.doIdentityMappingSetup("AzIdentityMappingEntry" + SetupConnection.random, "az");
        mapping = (IdentityMapping)SetupConnection.fetchByName(IdentityMapping.ddclass, "AzIdentityMappingEntry" + SetupConnection.random);
        String string = "ValidateIdentityMappingEntry2" + SetupConnection.random;
        validateIdentityMappingEntry = this.makeValidateIdentityMappingEntry(string, null);
        this.failCreate((XPSObject)validateIdentityMappingEntry, "Required parent missing");
    }

    public void doMappingSetup(String string, String string2) throws XPSException {
        IdentityMapping identityMapping = SetupConnection.builder.makeIdentityMapping(string, string2);
        this.createObject((XPSObject)identityMapping);
    }

    private ValidateIdentityMappingEntry makeValidateIdentityMappingEntry(String string, IdentityMapping identityMapping) {
        ValidateIdentityMappingEntry validateIdentityMappingEntry = (ValidateIdentityMappingEntry)SetupConnection.policyData.newObject((IClass)ValidateIdentityMappingEntry.ddclass);
        UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "userDirValidateIdentityMappingEntry" + SetupConnection.random);
        if (string != null) {
            validateIdentityMappingEntry.setName(string);
        }
        validateIdentityMappingEntry.setDescription("XPSAPI JUnit Sample ValidateIdentityMappingEntry");
        validateIdentityMappingEntry.setParent(identityMapping);
        validateIdentityMappingEntry.setUserSearchExpression("Identical DN");
        validateIdentityMappingEntry.setTargetDir(userDirectory);
        validateIdentityMappingEntry.setSourceUserDirectory("userDirValidateIdentityMappingEntry" + SetupConnection.random);
        return validateIdentityMappingEntry;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ValidateIdentityMappingEntryTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ValidateIdentityMappingEntryTest.class);
    }
}

