/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent4x;
import com.ca.siteminder.sdk.adminapi.ca.sm.TrustedHost;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.basic.sm.Agent4xTest;
import junit.framework.Test;
import junit.textui.TestRunner;

public class TrustedHostTest
extends TestBase {
    static TrustedHost trustedHost;
    static String strTrustedHostName;

    @TestBase.STI(value=1)
    public void testCreateTrustedHost() throws XPSException {
        strTrustedHostName = "trustedhost" + SetupConnection.random;
        trustedHost = TrustedHostTest.makeTrustedHost(strTrustedHostName);
        this.createObject((XPSObject)trustedHost);
    }

    @TestBase.STI(value=2)
    public void testSearchTrustedHost() {
        SetupConnection.fetchByName(TrustedHost.ddclass, trustedHost.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateTrustedHost() throws XPSException {
        trustedHost.setName("update" + trustedHost.getName());
        trustedHost.setDesc("update" + trustedHost.getDesc());
        this.updateObject((XPSObject)trustedHost);
    }

    @TestBase.STI(value=4)
    public void testTrustedHostDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)trustedHost);
    }

    @TestBase.STI(value=5)
    public void testDeleteTrustedHost() throws XPSException {
        this.deleteObject((XPSObject)trustedHost);
        trustedHost = null;
    }

    @TestBase.STI(value=6)
    public void testTrustedHostWithoutName() throws XPSException {
        trustedHost = TrustedHostTest.makeTrustedHost(null);
        this.failCreate((XPSObject)trustedHost, "Name");
    }

    @TestBase.STI(value=7)
    public void testTrustedHostWithAgent4xName() throws XPSException {
        Agent4x agent4x = Agent4xTest.makeAgent4x(strTrustedHostName);
        this.createObject((XPSObject)agent4x);
        trustedHost = TrustedHostTest.makeTrustedHost(strTrustedHostName);
        this.failCreate((XPSObject)trustedHost, "Duplicate");
    }

    public static TrustedHost makeTrustedHost(String string) throws XPSException {
        TrustedHost trustedHost = (TrustedHost)SetupConnection.policyData.newObject((IClass)TrustedHost.ddclass);
        if (string != null) {
            trustedHost.setName(string);
        }
        trustedHost.setDesc("XPSAPI JUnit Sample trustedHost");
        trustedHost.setIpAddr("127.0.0.1");
        trustedHost.setSecret("firewall");
        trustedHost.setRolloverEnabled(Boolean.valueOf(false));
        return trustedHost;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TrustedHostTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(TrustedHostTest.class);
    }
}

