/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.SelfReg;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class SelfRegTest
extends TestBase {
    static SelfReg selfReg;

    @TestBase.STI(value=1)
    public void testCreateSelfReg() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestSelfRegUserDir" + SetupConnection.random);
        String string = "SelfReg" + SetupConnection.random;
        selfReg = this.makeSelfReg(string);
        this.createObject((XPSObject)selfReg);
    }

    @TestBase.STI(value=2)
    public void testSearchSelfReg() {
        SetupConnection.fetchByName(SelfReg.ddclass, selfReg.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateSelfReg() throws XPSException {
        selfReg.setName("update" + selfReg.getName());
        selfReg.setDesc("update" + selfReg.getDesc());
        this.updateObject((XPSObject)selfReg);
    }

    @TestBase.STI(value=4)
    public void testSelfRegDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)selfReg);
    }

    @TestBase.STI(value=5)
    public void testDeleteSelfReg() throws XPSException {
        this.deleteObject((XPSObject)selfReg);
        selfReg = null;
    }

    @TestBase.STI(value=6)
    public void testSelfRegWithoutName() throws XPSException {
        selfReg = this.makeSelfReg(null);
        this.failCreate((XPSObject)selfReg, "Name");
    }

    @TestBase.STI(value=7)
    public void testSelfRegWithoutDN() throws XPSException {
        String string = "SelfReg1" + SetupConnection.random;
        selfReg = this.makeSelfReg(string);
        selfReg.clearUserDirectory();
        this.failCreate((XPSObject)selfReg, "UserDirectoryLink");
    }

    private SelfReg makeSelfReg(String string) throws XPSException {
        SelfReg selfReg = (SelfReg)SetupConnection.policyData.newObject((IClass)SelfReg.ddclass);
        UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "TestSelfRegUserDir" + SetupConnection.random);
        if (string != null) {
            selfReg.setName(string);
        }
        selfReg.setUserDirectory(userDirectory);
        selfReg.setDesc("XPSAPI JUnit Sample SelfReg");
        selfReg.setRegistrationURL("http://test.com");
        selfReg.setEnableLogging(Boolean.valueOf(false));
        selfReg.setTemplatePath("/test/");
        return selfReg;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SelfRegTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(SelfRegTest.class);
    }
}

