/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.ca.sm.ResponseGroup;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ResponseGroupTest
extends TestBase {
    static Response response;
    static Domain domain;
    static ResponseGroup responseGroup;

    @TestBase.STI(value=1)
    public void testCreateResponseGroup() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestResponseGroupUserDir" + SetupConnection.random, "TestResponseGroupAgent" + SetupConnection.random, null, "TestResponseGroupDomain" + SetupConnection.random, null, null, "TestResponseGroupResponse" + SetupConnection.random, null);
        response = (Response)SetupConnection.fetchByName(Response.ddclass, "TestResponseGroupResponse" + SetupConnection.random);
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, "TestResponseGroupDomain" + SetupConnection.random);
        String string = "ResponseGroup" + SetupConnection.random;
        responseGroup = this.makeResponseGroup(string, domain, response);
        this.createObject((XPSObject)responseGroup);
        List list = domain.getChildren((IClass)ResponseGroup.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((ResponseGroup)list.get(i)).getName().equals(string)) continue;
            bl = true;
        }
        ResponseGroupTest.assertTrue((String)"ResponseGroup, created, must found in the existing Respose groups", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchResponseGroup() {
        SetupConnection.fetchByName(ResponseGroup.ddclass, responseGroup.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateResponseGroup() throws XPSException {
        responseGroup.setName("update" + responseGroup.getName());
        responseGroup.setDesc("update" + responseGroup.getDesc());
        this.updateObject((XPSObject)responseGroup);
    }

    @TestBase.STI(value=4)
    public void testResponseGroupDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)responseGroup);
    }

    @TestBase.STI(value=5)
    public void testDeleteResponseGroup() throws XPSException {
        this.deleteObject((XPSObject)responseGroup);
        responseGroup = null;
    }

    @TestBase.STI(value=6)
    public void testResponseGroupWithoutName() throws XPSException {
        responseGroup = this.makeResponseGroup(null, domain, response);
        this.failCreate((XPSObject)responseGroup, "Name");
    }

    @TestBase.STI(value=7)
    public void testResponseGroupWithoutParent() throws XPSException {
        String string = "ResponseGroup" + SetupConnection.random;
        responseGroup = this.makeResponseGroup(string, null, response);
        this.failCreate((XPSObject)responseGroup, "parent");
    }

    @TestBase.STI(value=8)
    public void testResponseGroupWithoutAgentType() throws XPSException {
        String string = "ResponseGroup" + SetupConnection.random;
        responseGroup = this.makeResponseGroup(string, domain, response);
        responseGroup.clearAgentType();
        this.failCreate((XPSObject)responseGroup, "AgentTypeLink");
    }

    private ResponseGroup makeResponseGroup(String string, Domain domain, Response response) throws XPSException {
        ResponseGroup responseGroup = (ResponseGroup)SetupConnection.policyData.newObject((IClass)ResponseGroup.ddclass);
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        if (string != null) {
            responseGroup.setName(string);
        }
        if (domain != null) {
            responseGroup.setParent(domain);
        }
        if (response != null) {
            ArrayList<Response> arrayList = new ArrayList<Response>();
            arrayList.add(response);
            responseGroup.setResponses(arrayList);
        }
        responseGroup.setDesc("XPSAPI JUnit Sample ResponseGroup");
        responseGroup.setAgentType(agentType);
        return responseGroup;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ResponseGroupTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ResponseGroupTest.class);
    }
}

