/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.PasswordPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.RegularExpr;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class RegularExprTest
extends TestBase {
    static RegularExpr regularExpr;

    @TestBase.STI(value=1)
    public void testCreateRegularExpr() throws XPSException {
        String string = "RegularexprPwdPolicy" + SetupConnection.random;
        this.doSetup(string);
        String string2 = "RegularExpr" + SetupConnection.random;
        regularExpr = this.makeRegularExpr(string2, string);
        this.createObject((XPSObject)regularExpr);
    }

    @TestBase.STI(value=2)
    public void testSearchRegularExpr() {
        SetupConnection.fetchByName(RegularExpr.ddclass, regularExpr.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateRegularExpr() throws XPSException {
        regularExpr.setName("update" + regularExpr.getName());
        this.updateObject((XPSObject)regularExpr);
    }

    @TestBase.STI(value=4)
    public void testRegularExprDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)regularExpr);
    }

    @TestBase.STI(value=5)
    public void testDeleteRegularExpr() throws XPSException {
        this.deleteObject((XPSObject)regularExpr);
        regularExpr = null;
    }

    @TestBase.STI(value=6)
    public void testRegularExprWithoutName() throws XPSException {
        regularExpr = this.makeRegularExpr(null, "RegularexprPwdPolicy" + SetupConnection.random);
        this.failCreate((XPSObject)regularExpr, "Name");
    }

    @TestBase.STI(value=7)
    public void testRegularExprWithoutPwdPolicy() throws XPSException {
        String string = "RegularExpr1" + SetupConnection.random;
        regularExpr = this.makeRegularExpr(string, null);
        this.failCreate((XPSObject)regularExpr, "parent");
    }

    @TestBase.STI(value=8)
    public void testRegularExprWithoutValue() throws XPSException {
        String string = "PasswordPolicy2" + SetupConnection.random;
        regularExpr = this.makeRegularExpr(string, "RegularexprPwdPolicy" + SetupConnection.random);
        regularExpr.clearTaggedValue();
        this.failCreate((XPSObject)regularExpr, "TaggedValue");
    }

    private void doSetup(String string) throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestRegularExprUserDir" + SetupConnection.random);
        UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "TestRegularExprUserDir" + SetupConnection.random);
        PasswordPolicy passwordPolicy = SetupConnection.builder.makePasswordPolicy(string, userDirectory);
        this.createObject((XPSObject)passwordPolicy);
    }

    private RegularExpr makeRegularExpr(String string, String string2) throws XPSException {
        RegularExpr regularExpr = (RegularExpr)SetupConnection.policyData.newObject((IClass)RegularExpr.ddclass);
        if (string2 != null) {
            PasswordPolicy passwordPolicy = (PasswordPolicy)SetupConnection.fetchByName(PasswordPolicy.ddclass, string2);
            regularExpr.setParent(passwordPolicy);
        }
        if (string != null) {
            regularExpr.setName(string);
        }
        regularExpr.setTaggedValue("ab=cd");
        return regularExpr;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RegularExprTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(RegularExprTest.class);
    }
}

