/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class PolicyTest
extends TestBase {
    static Domain domain;
    static Policy policy;

    @TestBase.STI(value=1)
    public void testCreatePolicy() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestPolicyUserDir" + SetupConnection.random, "TestPolicyAgent1" + SetupConnection.random, null, "TestPolicyDomain" + SetupConnection.random, null, null, null, null);
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, "TestPolicyDomain" + SetupConnection.random);
        String string = "Policy" + SetupConnection.random;
        policy = SetupConnection.builder.makePolicy(string, domain);
        this.createObject((XPSObject)policy);
        List list = domain.getChildren((IClass)Policy.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Policy)list.get(i)).getName().equals(string)) continue;
            bl = true;
        }
        PolicyTest.assertTrue((String)"Policy, created, must reflect in existing policies", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchPolicy() {
        SetupConnection.fetchByName(Policy.ddclass, policy.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdatePolicy() throws XPSException {
        policy.setName("update" + policy.getName());
        policy.setDesc("update" + policy.getDesc());
        this.updateObject((XPSObject)policy);
    }

    @TestBase.STI(value=4)
    public void testPolicyDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)policy);
    }

    @TestBase.STI(value=5)
    public void testDeletePolicy() throws XPSException {
        this.deleteObject((XPSObject)policy);
        policy = null;
    }

    @TestBase.STI(value=6)
    public void testPolicyWithoutName() throws XPSException {
        policy = SetupConnection.builder.makePolicy(null, domain);
        this.failCreate((XPSObject)policy, "Name");
    }

    @TestBase.STI(value=7)
    public void testPolicyWithoutDomain() throws XPSException {
        String string = "Policy2" + SetupConnection.random;
        policy = SetupConnection.builder.makePolicy(string, null);
        this.failCreate((XPSObject)policy, "parent");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)PolicyTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(PolicyTest.class);
    }
}

