/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.HostConfig;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Test;
import junit.textui.TestRunner;

public class HostConfigTest
extends TestBase {
    static String strName;
    static HostConfig hostConfig;

    @TestBase.STI(value=1)
    public void testCreateHostConfig() throws XPSException {
        strName = "HostConfig" + SetupConnection.random;
        hostConfig = this.makeHostConfig(strName);
        this.createObject((XPSObject)hostConfig);
    }

    @TestBase.STI(value=2)
    public void testSearchHostConfig() {
        SetupConnection.fetchByName(HostConfig.ddclass, hostConfig.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateHostConfig() throws XPSException {
        hostConfig.setName("update" + hostConfig.getName());
        hostConfig.setDesc("update" + hostConfig.getDesc());
        this.updateObject((XPSObject)hostConfig);
    }

    @TestBase.STI(value=4)
    public void testHostConfigDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)hostConfig);
    }

    @TestBase.STI(value=5)
    public void testDeleteHostConfig() throws XPSException {
        this.deleteObject((XPSObject)hostConfig);
        hostConfig = null;
    }

    @TestBase.STI(value=6)
    public void testHostConfigWithoutName() throws XPSException {
        hostConfig = this.makeHostConfig(null);
        this.failCreate((XPSObject)hostConfig, "Name");
    }

    @TestBase.STI(value=7)
    public void testHostConfigServerSpaces() throws XPSException {
        hostConfig = this.makeHostConfig(strName + 10);
        hostConfig.setPolicyServer(Collections.singletonList("abc , 1, 2 ,3   "));
        this.createObject((XPSObject)hostConfig);
    }

    @TestBase.STI(value=8)
    public void testHostConfigWrongServer1() throws XPSException {
        hostConfig = this.makeHostConfig(strName + 1);
        hostConfig.setPolicyServer(Collections.singletonList("abcdefg"));
        this.failCreate((XPSObject)hostConfig, "Badly formatted");
    }

    @TestBase.STI(value=9)
    public void testHostConfigWrongServer2() throws XPSException {
        hostConfig = this.makeHostConfig(strName + 1);
        hostConfig.setPolicyServer(Collections.singletonList("abc,1,2"));
        this.failCreate((XPSObject)hostConfig, "Badly formatted");
    }

    @TestBase.STI(value=10)
    public void testHostConfigWrongServer4() throws XPSException {
        hostConfig = this.makeHostConfig(strName + 1);
        hostConfig.setPolicyServer(Collections.singletonList("abc,1,2,1a"));
        this.failCreate((XPSObject)hostConfig, "integer");
    }

    @TestBase.STI(value=11)
    public void testHostConfigWrongServer5() throws XPSException {
        hostConfig = this.makeHostConfig(strName + 1);
        hostConfig.setPolicyServer(Collections.singletonList("abc,1,2,0"));
        this.failCreate((XPSObject)hostConfig, "integer");
    }

    @TestBase.STI(value=12)
    public void testHostConfigWrongServer6() throws XPSException {
        hostConfig = this.makeHostConfig(strName + 1);
        hostConfig.setPolicyServer(Collections.singletonList("abc,1,2,999999"));
        this.failCreate((XPSObject)hostConfig, "integer");
    }

    private HostConfig makeHostConfig(String string) throws XPSException {
        HostConfig hostConfig = (HostConfig)SetupConnection.policyData.newObject((IClass)HostConfig.ddclass);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("127.0.0.1,44441,44442,44443");
        if (string != null) {
            hostConfig.setName(string);
        }
        hostConfig.setDesc("XPSAPI JUnit Sample HostConfig");
        hostConfig.setPolicyServer(arrayList);
        hostConfig.setMaxSocketsPerPort(Integer.valueOf(20));
        hostConfig.setMinSocketsPerPort(Integer.valueOf(2));
        hostConfig.setNewSocketStep(Integer.valueOf(2));
        hostConfig.setRequestTimeout(Integer.valueOf(60));
        hostConfig.setEnableFailOver(Boolean.valueOf(true));
        return hostConfig;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)HostConfigTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(HostConfigTest.class);
    }
}

