/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalResponse;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class GlobalResponseTest
extends TestBase {
    static String strName;
    static GlobalResponse globalResponse;

    @TestBase.STI(value=1)
    public void testCreateGlobalResponse() throws XPSException {
        strName = "GlobalResponse" + SetupConnection.random;
        globalResponse = SetupConnection.builder.makeGlobalResponse(strName);
        this.createObject((XPSObject)globalResponse);
    }

    @TestBase.STI(value=2)
    public void testSearchGlobalResponse() {
        SetupConnection.fetchByName(GlobalResponse.ddclass, globalResponse.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateGlobalResponse() throws XPSException {
        globalResponse.setName("update" + globalResponse.getName());
        globalResponse.setDesc("update" + globalResponse.getDesc());
        this.updateObject((XPSObject)globalResponse);
    }

    @TestBase.STI(value=4)
    public void testGlobalResponseDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)globalResponse, false);
    }

    @TestBase.STI(value=5)
    public void testDeleteGlobalResponse() throws XPSException {
        this.deleteObject((XPSObject)globalResponse);
        globalResponse = null;
    }

    @TestBase.STI(value=6)
    public void testGlobalResponseWithoutName() throws XPSException {
        globalResponse = SetupConnection.builder.makeGlobalResponse(null);
        this.failCreate((XPSObject)globalResponse, "Name");
    }

    @TestBase.STI(value=7)
    public void testGlobalResponseWithoutAgentType() throws XPSException {
        globalResponse = SetupConnection.builder.makeGlobalResponse(strName);
        globalResponse.clearAgentType();
        this.failCreate((XPSObject)globalResponse, "AgentTypeLink");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GlobalResponseTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(GlobalResponseTest.class);
    }
}

