/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentTypeAttr;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalResponse;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalResponseAttr;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class GlobalResponseAttrTest
extends TestBase {
    static String strName;
    static GlobalResponseAttr globalResponseAttr;
    static GlobalResponse globalResponse;

    @TestBase.STI(value=1)
    public void testCreateGlobalResponseAttr() throws XPSException {
        globalResponse = SetupConnection.builder.makeGlobalResponse("AttributeGlobalResponse" + SetupConnection.random);
        this.createObject((XPSObject)globalResponse);
        strName = "GlobalResponseAttr" + SetupConnection.random;
        globalResponseAttr = this.makeGlobalResponseAttr(strName, globalResponse);
        this.createObject((XPSObject)globalResponseAttr);
    }

    @TestBase.STI(value=2)
    public void testSearchGlobalResponseAttr() {
        strName = "GlobalResponseAttr" + SetupConnection.random;
        Filter filter = new Filter((IAttribute)GlobalResponseAttr.VALUE, Clause.Operator.EQUAL, (Object)strName);
        List list = SetupConnection.policyData.search((IClass)GlobalResponseAttr.ddclass, filter);
        GlobalResponseAttrTest.assertFalse((String)"policyData.search returned empty GlobalResponseAttr", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateGlobalResponseAttr() throws XPSException {
        globalResponseAttr.setValue("update" + strName);
        this.updateObject((XPSObject)globalResponseAttr);
    }

    @TestBase.STI(value=4)
    public void testGlobalResponseAttrDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)globalResponseAttr, false);
    }

    @TestBase.STI(value=5)
    public void testDeleteGlobalResponseAttr() throws XPSException {
        this.deleteObject((XPSObject)globalResponseAttr);
        globalResponseAttr = null;
    }

    @TestBase.STI(value=6)
    public void testGlobalResponseAttrWithoutParent() throws XPSException {
        globalResponseAttr = this.makeGlobalResponseAttr(strName, null);
        this.failCreate((XPSObject)globalResponseAttr, "parent");
    }

    @TestBase.STI(value=7)
    public void testGlobalResponseAttrWithoutAgentTypeAttr() throws XPSException {
        globalResponseAttr = this.makeGlobalResponseAttr(strName, globalResponse);
        globalResponseAttr.clearAgentTypeAttr();
        this.failCreate((XPSObject)globalResponseAttr, "AgentTypeAttrLink");
    }

    private GlobalResponseAttr makeGlobalResponseAttr(String string, GlobalResponse globalResponse) throws XPSException {
        GlobalResponseAttr globalResponseAttr = (GlobalResponseAttr)SetupConnection.policyData.newObject((IClass)GlobalResponseAttr.ddclass);
        AgentTypeAttr agentTypeAttr = (AgentTypeAttr)SetupConnection.fetchByName(AgentTypeAttr.ddclass, "WebAgent-HTTP-Authorization-Variable");
        if (string != null) {
            globalResponseAttr.setValue(string);
        }
        if (globalResponse != null) {
            globalResponseAttr.setParent((Response)globalResponse);
        }
        globalResponseAttr.setAgentTypeAttr(agentTypeAttr);
        globalResponseAttr.setTTL(Integer.valueOf(0));
        globalResponseAttr.setFlags(Integer.valueOf(0));
        globalResponseAttr.setIsGlobal(GlobalResponseAttr.IsGlobal.YES);
        return globalResponseAttr;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GlobalResponseAttrTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(GlobalResponseAttrTest.class);
    }
}

