/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthValidateMap;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AuthValidateMapTest
extends TestBase {
    static AuthValidateMap authValidateMap;
    static String strDirName;
    static UserDirectory userDir;

    @TestBase.STI(value=1)
    public void testCreateAuthValidateMap() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestValidateUser" + SetupConnection.random);
        userDir = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "TestValidateUser" + SetupConnection.random);
        strDirName = "AuthValidateMap" + SetupConnection.random;
        authValidateMap = AuthValidateMapTest.makeAuthValidateMap(strDirName, userDir);
        this.createObject((XPSObject)authValidateMap);
    }

    @TestBase.STI(value=2)
    public void testSearchAuthValidateMap() {
        Filter filter = new Filter((IAttribute)AuthValidateMap.AUTHDIRNAME, Clause.Operator.EQUAL, (Object)strDirName);
        List list = SetupConnection.policyData.search((IClass)AuthValidateMap.ddclass, filter);
        AuthValidateMapTest.assertFalse((String)"policyData.search returned empty list of AuthValidateMap", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateAuthValidateMap() throws XPSException {
        authValidateMap.setAuthDirName("update" + strDirName);
        this.updateObject((XPSObject)authValidateMap);
    }

    @TestBase.STI(value=4)
    public void testAuthValidateMapDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)authValidateMap);
    }

    @TestBase.STI(value=5)
    public void testDeleteAuthValidateMap() throws XPSException {
        this.deleteObject((XPSObject)authValidateMap);
        authValidateMap = null;
    }

    @TestBase.STI(value=6)
    public void testAuthValidateMapWithoutDirName() throws XPSException {
        authValidateMap = AuthValidateMapTest.makeAuthValidateMap(null, userDir);
        this.failCreate((XPSObject)authValidateMap, "AuthDirName");
    }

    @TestBase.STI(value=7)
    public void testAuthValidateMapWithoutUserDir() throws XPSException {
        authValidateMap = AuthValidateMapTest.makeAuthValidateMap(strDirName, null);
        this.failCreate((XPSObject)authValidateMap, "ValidateDirLink");
    }

    public static AuthValidateMap makeAuthValidateMap(String string, UserDirectory userDirectory) throws XPSException {
        AuthValidateMap authValidateMap = (AuthValidateMap)SetupConnection.policyData.newObject((IClass)AuthValidateMap.ddclass);
        if (userDirectory != null) {
            authValidateMap.setValidateDir(userDirectory);
        }
        if (string != null) {
            authValidateMap.setAuthDirName(string);
        }
        authValidateMap.setMappingType(AuthValidateMap.MappingType.UserDN);
        return authValidateMap;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AuthValidateMapTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AuthValidateMapTest.class);
    }
}

