/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AuthSchemeTest
extends TestBase {
    static AuthScheme authScheme;

    @TestBase.STI(value=1)
    public void testCreateAuthScheme() throws XPSException {
        String string = "AuthScheme" + SetupConnection.random;
        authScheme = SetupConnection.builder.makeAuthScheme(string);
        this.createObject((XPSObject)authScheme);
    }

    @TestBase.STI(value=2)
    public void testSearchAuthScheme() {
        SetupConnection.fetchByName(AuthScheme.ddclass, authScheme.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAuthScheme() throws XPSException {
        authScheme.setName("update" + authScheme.getName());
        authScheme.setDesc("update" + authScheme.getDesc());
        this.updateObject((XPSObject)authScheme);
    }

    @TestBase.STI(value=4)
    public void testAuthSchemeDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)authScheme);
    }

    @TestBase.STI(value=5)
    public void testDeleteAuthScheme() throws XPSException {
        this.deleteObject((XPSObject)authScheme);
        authScheme = null;
    }

    @TestBase.STI(value=6)
    public void testAuthSchemeWithoutName() throws XPSException {
        authScheme = SetupConnection.builder.makeAuthScheme(null);
        this.failCreate((XPSObject)authScheme, "Name");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AuthSchemeTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AuthSchemeTest.class);
    }
}

