/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.TrustedHost;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.basic.sm.TrustedHostTest;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AgentTest
extends TestBase {
    static Agent agent;
    static String strName;

    @TestBase.STI(value=1)
    public void testCreateAgent() throws XPSException {
        strName = "agent" + SetupConnection.random;
        agent = SetupConnection.builder.makeAgent(strName);
        this.createObject((XPSObject)agent);
    }

    @TestBase.STI(value=2)
    public void testSearchAgentConfig() {
        SetupConnection.fetchByName(Agent.ddclass, agent.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAgent() throws XPSException {
        agent.setName("update" + agent.getName());
        agent.setDesc("update" + agent.getDesc());
        this.updateObject((XPSObject)agent);
    }

    @TestBase.STI(value=4)
    public void testAgentDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)agent);
    }

    @TestBase.STI(value=5)
    public void testdeleteAgent() throws XPSException {
        this.deleteObject((XPSObject)agent);
        agent = null;
    }

    @TestBase.STI(value=6)
    public void testAgentWithoutName() throws XPSException {
        agent = SetupConnection.builder.makeAgent(null);
        this.failCreate((XPSObject)agent, "Name");
    }

    @TestBase.STI(value=7)
    public void testAgentWithoutAgentType() throws XPSException {
        strName = "agent" + SetupConnection.random;
        agent = SetupConnection.builder.makeAgent(strName);
        agent.clearAgentType();
        this.failCreate((XPSObject)agent, "AgentTypeLink");
    }

    @TestBase.STI(value=8)
    public void testTrustedHostWithAgentName() throws XPSException {
        String string = "agent2_" + SetupConnection.random;
        TrustedHost trustedHost = TrustedHostTest.makeTrustedHost(string);
        this.createObject((XPSObject)trustedHost);
        agent = SetupConnection.builder.makeAgent(string);
        this.createObject((XPSObject)agent);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AgentTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AgentTest.class);
    }
}

