/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentGroup;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AgentGroupTest
extends TestBase {
    static AgentGroup agentGroup;
    static Agent agent;
    static String strGroupName;
    static String strAgentName;

    @TestBase.STI(value=1)
    public void testCreateAgentGroup() throws XPSException {
        strAgentName = "TestGroupAgent" + SetupConnection.random;
        agent = SetupConnection.builder.doAgentSetUp(strAgentName);
        strGroupName = "AgentGroup" + SetupConnection.random;
        agentGroup = AgentGroupTest.makeAgentGroup(strGroupName);
        this.createObject((XPSObject)agentGroup);
    }

    @TestBase.STI(value=2)
    public void testSearchAgentGroup() {
        SetupConnection.fetchByName(AgentGroup.ddclass, agentGroup.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAgentGroup() throws XPSException {
        agentGroup.setDesc("update" + agentGroup.getDesc());
        this.updateObject((XPSObject)agentGroup);
    }

    @TestBase.STI(value=4)
    public void testAgentGroupDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)agentGroup);
    }

    @TestBase.STI(value=5)
    public void testDeleteAgentGroup() throws XPSException {
        this.deleteObject((XPSObject)agentGroup);
        agentGroup = null;
    }

    @TestBase.STI(value=6)
    public void testAgentGroupWithoutName() throws XPSException {
        agentGroup = AgentGroupTest.makeAgentGroup(null);
        this.failCreate((XPSObject)agentGroup, "Name");
    }

    @TestBase.STI(value=7)
    public void testAgentGroupWithoutAgentType() throws XPSException {
        agentGroup = AgentGroupTest.makeAgentGroup(strGroupName);
        agentGroup.clearAgentType();
        this.failCreate((XPSObject)agentGroup, "AgentTypeLink");
    }

    @TestBase.STI(value=8)
    public void testAgentGroupWithNameOfAgent() throws XPSException {
        agentGroup = AgentGroupTest.makeAgentGroup(strGroupName);
        agentGroup.setName(strAgentName);
        this.failCreate((XPSObject)agentGroup, "Duplicate");
    }

    @TestBase.STI(value=9)
    public void testWrongAgentAgentType() throws XPSException {
        Agent agent = SetupConnection.builder.makeAgent(strAgentName + '_' + 1);
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "3Com");
        agent.setAgentType(agentType);
        this.createObject((XPSObject)agent);
        agentGroup = AgentGroupTest.makeAgentGroup(strGroupName + 1, agent);
        this.failCreate((XPSObject)agentGroup, "Agent Type");
    }

    @TestBase.STI(value=10)
    public void testWrongAgentGroupAgentType() throws XPSException {
        AgentGroup agentGroup = AgentGroupTest.makeAgentGroup(strGroupName + '_' + 2, null);
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "3Com");
        agentGroup.setAgentType(agentType);
        this.createObject((XPSObject)agentGroup);
        AgentGroupTest.agentGroup = AgentGroupTest.makeAgentGroup(strGroupName + 2);
        AgentGroupTest.agentGroup.setAgentGroups(Collections.singletonList(agentGroup));
        this.failCreate((XPSObject)AgentGroupTest.agentGroup, "Agent Type");
    }

    private static AgentGroup makeAgentGroup(String string) {
        return AgentGroupTest.makeAgentGroup(string, agent);
    }

    public static AgentGroup makeAgentGroup(String string, Agent agent) throws XPSException {
        AgentGroup agentGroup = (AgentGroup)SetupConnection.policyData.newObject((IClass)AgentGroup.ddclass);
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        ArrayList<Agent> arrayList = null;
        if (agent != null) {
            arrayList = new ArrayList<Agent>();
            arrayList.add(agent);
        }
        if (string != null) {
            agentGroup.setName(string);
        }
        agentGroup.setDesc("XPSAPI JUnit Sample AgentGroup");
        agentGroup.setAgentType(agentType);
        if (arrayList != null) {
            agentGroup.setAgents(arrayList);
        }
        return agentGroup;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AgentGroupTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AgentGroupTest.class);
    }
}

