/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AffiliateDomain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AffiliateDomainTest
extends TestBase {
    static AffiliateDomain affiliateDomain;

    @TestBase.STI(value=1)
    public void testCreateAffiliateDomain() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestAffilateDomainUserDir" + SetupConnection.random);
        String string = "AffiliateDomain" + SetupConnection.random;
        affiliateDomain = this.makeAffiliateDomain(string);
        this.createObject((XPSObject)affiliateDomain);
    }

    @TestBase.STI(value=2)
    public void testSearchAffiliateDomain() {
        SetupConnection.fetchByName(AffiliateDomain.ddclass, affiliateDomain.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAffiliateDomain() throws XPSException {
        affiliateDomain.setName("update" + affiliateDomain.getName());
        affiliateDomain.setDesc("update" + affiliateDomain.getDesc());
        this.updateObject((XPSObject)affiliateDomain);
    }

    @TestBase.STI(value=4)
    public void testAffiliateDomainDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)affiliateDomain);
    }

    @TestBase.STI(value=5)
    public void testDeleteAffiliateDomain() throws XPSException {
        this.deleteObject((XPSObject)affiliateDomain);
        affiliateDomain = null;
    }

    @TestBase.STI(value=6)
    public void testAffiliateDomainWithoutName() throws XPSException {
        affiliateDomain = this.makeAffiliateDomain(null);
        this.failCreate((XPSObject)affiliateDomain, "Name");
    }

    private AffiliateDomain makeAffiliateDomain(String string) {
        List<UserDirectory> list = SetupConnection.builder.getUserDirs("TestAffilateDomainUserDir" + SetupConnection.random);
        AffiliateDomainTest.assertFalse((String)"Userdirectories list must be empty", (list.size() == 0 ? 1 : 0) != 0);
        AffiliateDomain affiliateDomain = (AffiliateDomain)SetupConnection.policyData.newObject((IClass)AffiliateDomain.ddclass);
        if (string != null) {
            affiliateDomain.setName(string);
        }
        affiliateDomain.setDesc("XPSAPI JUnit Sample AffiliateDomain");
        affiliateDomain.setUserDirectories(list);
        affiliateDomain.setMode(Domain.Mode.Default);
        return affiliateDomain;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AffiliateDomainTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AffiliateDomainTest.class);
    }
}

