/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.fss;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.PolicyLink;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.ca.sm.ResponseAttr;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.ca.sm.SAMLv2SP;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class SAMLv2SPTest
extends TestBase {
    static SAMLv2SP sAMLv2SP;
    static Domain domain;
    static String strName;

    @TestBase.STI(value=1)
    public void testCreateSAMLv2SP() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestSAMLv2SPUserDir" + SetupConnection.random, "TestSAMLv2SPAgent1" + SetupConnection.random, null, "TestSAMLv2SPDomain" + SetupConnection.random, "TestSAMLv2SPRealm" + SetupConnection.random, "TestSAMLv2SPRule" + SetupConnection.random, "TestSAMLv2SPResponse" + SetupConnection.random, "TestSAMLv2SPPolicy" + SetupConnection.random);
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, "TestSAMLv2SPDomain" + SetupConnection.random);
        strName = "samlv2sp" + SetupConnection.random;
        sAMLv2SP = this.makeSAMLv2SP(strName, domain);
        this.createObject((XPSObject)sAMLv2SP);
        List list = domain.getChildren((IClass)SAMLv2SP.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((SAMLv2SP)list.get(i)).getName().equals(strName)) continue;
            bl = true;
        }
        SAMLv2SPTest.assertTrue((String)"SAMLv2SP, created, must found in existing SAMLv2SP list", (boolean)bl);
        String string = "samlsp:" + strName;
        Agent agent = sAMLv2SP.getAgent();
        SAMLv2SPTest.assertNotNull((String)"Backing agent not found", (Object)agent);
        SAMLv2SPTest.assertEquals((String)"Backing agent has a wrong name", (String)string.toLowerCase(), (String)agent.getName());
        Realm realm = sAMLv2SP.getRealm();
        SAMLv2SPTest.assertNotNull((String)"Backing realm not found", (Object)realm);
        SAMLv2SPTest.assertEquals((String)"Backing realm has a wrong name", (String)string, (String)realm.getName());
        Rule rule = sAMLv2SP.getRule();
        SAMLv2SPTest.assertNotNull((String)"Backing rule not found", (Object)rule);
        SAMLv2SPTest.assertEquals((String)"Backing rule has a wrong name", (String)string, (String)rule.getName());
        Policy policy = sAMLv2SP.getPolicy();
        SAMLv2SPTest.assertNotNull((String)"Backing policy not found", (Object)policy);
        SAMLv2SPTest.assertEquals((String)"Backing policy has a wrong name", (String)string, (String)policy.getName());
        Response response = sAMLv2SP.getResponse();
        SAMLv2SPTest.assertNotNull((String)"Backing response not found", (Object)response);
        SAMLv2SPTest.assertEquals((String)"Backing response has a wrong name", (String)string, (String)response.getName());
        List list2 = policy.getChildren((IClass)PolicyLink.ddclass);
        SAMLv2SPTest.assertNotNull((String)"Backing policy link not found", (Object)list2);
        SAMLv2SPTest.assertEquals((String)"Wrong number of backing policy links", (int)1, (int)list2.size());
        List list3 = response.getChildren((IClass)ResponseAttr.ddclass);
        SAMLv2SPTest.assertNotNull((String)"Backing response attribute not found", (Object)list3);
        SAMLv2SPTest.assertEquals((String)"Wrong number of backing response attributes", (int)1, (int)list3.size());
    }

    @TestBase.STI(value=2)
    public void testSearchSAMLv2SP() throws XPSException {
        SetupConnection.fetchByName(SAMLv2SP.ddclass, sAMLv2SP.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateSAMLv2SP() throws XPSException {
        sAMLv2SP.setName("update" + sAMLv2SP.getName());
        this.updateObject((XPSObject)sAMLv2SP);
    }

    @TestBase.STI(value=4)
    public void testSAMLv2SPDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)sAMLv2SP);
    }

    @TestBase.STI(value=5)
    public void testDeleteSAMLv2SP() throws XPSException {
        this.deleteObject((XPSObject)sAMLv2SP);
        sAMLv2SP = null;
    }

    @TestBase.STI(value=6)
    public void testSAMLv2SPWithoutDomain() throws XPSException {
        sAMLv2SP = this.makeSAMLv2SP(strName, null);
        this.failCreate((XPSObject)sAMLv2SP, "parent");
    }

    @TestBase.STI(value=7)
    public void testSAMLv2SPWithoutAuthURL() throws XPSException {
        sAMLv2SP = this.makeSAMLv2SP(strName, domain);
        sAMLv2SP.clearNetegrityAffiliateMinderAuthURL();
        this.failCreate((XPSObject)sAMLv2SP, "NetegrityAffiliateMinderAuthURL");
    }

    @TestBase.STI(value=8)
    public void testSAMLv2SPWithoutSPID() throws XPSException {
        sAMLv2SP = this.makeSAMLv2SP(strName, domain);
        sAMLv2SP.clearKEY_SPID();
        this.failCreate((XPSObject)sAMLv2SP, "KEY_SPID");
    }

    @TestBase.STI(value=9)
    public void testSAMLv2SPWithoutIDPID() throws XPSException {
        sAMLv2SP = this.makeSAMLv2SP(strName, domain);
        sAMLv2SP.clearIdPID();
        this.failCreate((XPSObject)sAMLv2SP, "IdPID");
    }

    @TestBase.STI(value=10)
    public void testSAMLv2SPWithoutName() throws XPSException {
        sAMLv2SP = this.makeSAMLv2SP(null, domain);
        this.failCreate((XPSObject)sAMLv2SP, "Name");
    }

    private SAMLv2SP makeSAMLv2SP(String string, Domain domain) throws XPSException {
        SAMLv2SP sAMLv2SP = (SAMLv2SP)SetupConnection.policyData.newObject((IClass)SAMLv2SP.ddclass);
        if (string != null) {
            sAMLv2SP.setName(string);
        }
        if (domain != null) {
            sAMLv2SP.setParent(domain);
        }
        sAMLv2SP.setAllowCreationOfUserIdentifier(Boolean.valueOf(false));
        sAMLv2SP.setApplicationURL("http://application");
        sAMLv2SP.setAssertionConsumerDefaultURL("http://consumer");
        sAMLv2SP.setAudience("Testing");
        sAMLv2SP.setAssertionPluginClass("Assertion");
        sAMLv2SP.setAssertionPluginParameters("AssertionParameter");
        sAMLv2SP.setArtifactEncoding("ASCAII");
        sAMLv2SP.setDisableSignatureProcessing(Boolean.valueOf(false));
        sAMLv2SP.setDSigningAlias("XPSAPI_Signing");
        sAMLv2SP.setDSigVerInfoIssuerDN("dc=testing");
        sAMLv2SP.setDSigVerInfoSerialNumber("A12345");
        sAMLv2SP.setAssertionPluginClass("XPSAPI Plugin");
        sAMLv2SP.setEnableAttributeService(Boolean.valueOf(false));
        sAMLv2SP.setEnableSLORedirectBinding(Boolean.valueOf(false));
        sAMLv2SP.setEnableSSOArtifactBinding(Boolean.valueOf(false));
        sAMLv2SP.setEnableSSOECPProfile(Boolean.valueOf(true));
        sAMLv2SP.setEnableSSOPostBinding(Boolean.valueOf(false));
        sAMLv2SP.setEnableIPD(Boolean.valueOf(true));
        sAMLv2SP.setIdPID("IPD_123456");
        sAMLv2SP.setIdPSourceID("IPD_Source");
        sAMLv2SP.setIPDServiceURL("http://service");
        sAMLv2SP.setAttrSvcADSearchSpec("cn=testing");
        sAMLv2SP.setAttrSvcCustomSearchSpec("cn=common");
        sAMLv2SP.setAttrSvcLDAPSearchSpec("uid=testing");
        sAMLv2SP.setAttrSvcODBCSearchSpec("name=testing");
        sAMLv2SP.setAttrSvcSignAssertion(Boolean.valueOf(false));
        sAMLv2SP.setNameIdAttrName("XPSAPIAttribute");
        sAMLv2SP.setNameIdDNSpec("XPSAPIDomain");
        sAMLv2SP.setNameIdFormat("ab=dc");
        sAMLv2SP.setNameIdType(Integer.valueOf(2));
        sAMLv2SP.setPassword("firewall");
        sAMLv2SP.setAuthenticationLevel(Integer.valueOf(2));
        sAMLv2SP.setAuthnContextClassRef("R12.5");
        sAMLv2SP.setSAMLMajorVersion(Integer.valueOf(2));
        sAMLv2SP.setSAMLMinorVersion(Integer.valueOf(0));
        sAMLv2SP.setValidityDuration(Integer.valueOf(90));
        sAMLv2SP.setSkewTime(Integer.valueOf(60));
        sAMLv2SP.setSLOServiceConfirmURL("http://SLO");
        sAMLv2SP.setSLOServiceResponseURL("http://service");
        sAMLv2SP.setSLOServiceValidityDuration(Integer.valueOf(40));
        sAMLv2SP.setRequireSignedAuthnRequests(Boolean.valueOf(false));
        sAMLv2SP.setEncryptAssertion(Boolean.valueOf(false));
        sAMLv2SP.setEncryptionBlockAlgorithm("Compat");
        sAMLv2SP.setNetegrityAffiliateMinderAuthURL("http://AuthUrl");
        sAMLv2SP.setEncryptNameID(Boolean.valueOf(true));
        sAMLv2SP.setEncryptionCertSerialNumber("200");
        sAMLv2SP.setKEY_SPID("key200" + SetupConnection.random);
        sAMLv2SP.setNetegrityAffiliateMinderAuthURL("http://abcd");
        sAMLv2SP.setNameIdType(Integer.valueOf(2));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1.1.1.1");
        arrayList.add("2.2.2.2");
        sAMLv2SP.setIPAddresses(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("first");
        arrayList2.add("second");
        sAMLv2SP.setAttributeList(arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("svc1");
        arrayList3.add("svc2");
        sAMLv2SP.setAttrSvcAttributes(arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        arrayList4.add("attr1");
        arrayList4.add("attr2");
        sAMLv2SP.setAttrList(arrayList4);
        ArrayList<String> arrayList5 = new ArrayList<String>();
        arrayList5.add("http://url1");
        arrayList5.add("http://url2");
        sAMLv2SP.setAssertionConsumerSvcURL(arrayList5);
        return sAMLv2SP;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SAMLv2SPTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(SAMLv2SPTest.class);
    }
}

