/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.fss;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.SAMLv2IdP;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.Date;
import junit.framework.Test;
import junit.textui.TestRunner;

public class SAMLv2IdPTest
extends TestBase {
    static String name;
    static SAMLv2IdP sAMLv2IdP;
    static AuthScheme scheme;

    @TestBase.STI(value=1)
    public void testCreateSAMLv2IdP() throws XPSException {
        name = "TestSAMLv2IdPAuthScheme" + SetupConnection.random;
        scheme = this.doAuthValidateSetUp(name);
        sAMLv2IdP = this.makeSAMLv2IdP(true);
        this.createObject((XPSObject)sAMLv2IdP);
    }

    @TestBase.STI(value=2)
    public void testSearchSAMLv2IdP() throws XPSException {
        XPSObject xPSObject = SetupConnection.policyData.fetchObject(sAMLv2IdP.getXid(), true);
        SAMLv2IdPTest.assertTrue((xPSObject != null ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateSAMLv2IdP() throws XPSException {
        sAMLv2IdP.setDescription("update" + sAMLv2IdP.getDescription());
        this.updateObject((XPSObject)sAMLv2IdP);
    }

    @TestBase.STI(value=4)
    public void testSAMLv2IdPDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)sAMLv2IdP);
    }

    @TestBase.STI(value=5)
    public void testDeleteSAMLv2IdP() throws XPSException {
        this.deleteObject((XPSObject)sAMLv2IdP);
        sAMLv2IdP = null;
    }

    @TestBase.STI(value=6)
    public void testSAMLv2IdPWithoutParent() throws XPSException {
        sAMLv2IdP = this.makeSAMLv2IdP(false);
        this.failCreate((XPSObject)sAMLv2IdP, "parent");
    }

    @TestBase.STI(value=7)
    public void testSAMLv2IdPWithoutKEYPID() throws XPSException {
        sAMLv2IdP = this.makeSAMLv2IdP(true);
        sAMLv2IdP.clearKEY_IdPID();
        this.failCreate((XPSObject)sAMLv2IdP, "KEY_IdPID");
    }

    @TestBase.STI(value=8)
    public void testSAMLv2IdPWithoutKEYSourceID() throws XPSException {
        sAMLv2IdP = this.makeSAMLv2IdP(true);
        sAMLv2IdP.clearKEY_IdPSourceID();
        this.failCreate((XPSObject)sAMLv2IdP, "KEY_IdPSourceID");
    }

    @TestBase.STI(value=9)
    public void testSAMLv2IdPWithoutSPID() throws XPSException {
        sAMLv2IdP = this.makeSAMLv2IdP(true);
        sAMLv2IdP.clearSPID();
        this.failCreate((XPSObject)sAMLv2IdP, "SPID");
    }

    private SAMLv2IdP makeSAMLv2IdP(boolean bl) throws XPSException {
        SAMLv2IdP sAMLv2IdP = (SAMLv2IdP)SetupConnection.policyData.newObject((IClass)SAMLv2IdP.ddclass);
        if (bl) {
            sAMLv2IdP.setParent(scheme);
        }
        sAMLv2IdP.setName(name);
        sAMLv2IdP.setDescription("XPSAPI JUnit Sample SAMLv2IdP");
        sAMLv2IdP.setADSearchSpec("CN=Testing");
        sAMLv2IdP.setAllowIdPtoCreateUserIdentifier(Boolean.valueOf(false));
        sAMLv2IdP.setArtifactResolutionDefaultService("DefaultService");
        sAMLv2IdP.setAssertionConsumerDefaultURL("http://consumer");
        sAMLv2IdP.setAudience("Testing");
        sAMLv2IdP.setBackChannelAuthType(Integer.valueOf(0));
        sAMLv2IdP.setCustomSearchSpec("dc=consumer");
        sAMLv2IdP.setDecryptionAlias("XPSAPI");
        sAMLv2IdP.setDisableSignatureProcessing(Boolean.valueOf(false));
        sAMLv2IdP.setDSigningAlias("XPSAPI_Signing");
        sAMLv2IdP.setDSigVerInfoIssuerDN("dc=testing");
        sAMLv2IdP.setDSigVerInfoSerialNumber("A12345");
        sAMLv2IdP.setEnabled(Boolean.valueOf(true));
        sAMLv2IdP.setEnableSAMLRequester(Boolean.valueOf(false));
        sAMLv2IdP.setEnableSLORedirectBinding(Boolean.valueOf(false));
        sAMLv2IdP.setEnableSSOArtifactBinding(Boolean.valueOf(false));
        sAMLv2IdP.setEnableSSOECPProfile(Boolean.valueOf(true));
        sAMLv2IdP.setEnableSSOPostBinding(Boolean.valueOf(false));
        sAMLv2IdP.setEnforceSingleUsePolicy(Boolean.valueOf(false));
        sAMLv2IdP.setFailureRedirectMode(Integer.valueOf(1));
        sAMLv2IdP.setFailureRedirectURL("http://Failure");
        sAMLv2IdP.setInvalidRedirectMode(Integer.valueOf(2));
        sAMLv2IdP.setInvalidRedirectURL("http://Redirect");
        sAMLv2IdP.setIDPPluginClass("PluginClass");
        sAMLv2IdP.setIDPPluginParameters("XPSAPI Plugin");
        sAMLv2IdP.setKEY_IdPID("PIDkey" + new Date().getTime());
        sAMLv2IdP.setKEY_IdPSourceID("XPSAPISource");
        sAMLv2IdP.setLDAPSearchSpec("dc=testing");
        sAMLv2IdP.setNameIdAllowNested(Boolean.valueOf(true));
        sAMLv2IdP.setNameIdAttrName("XPSAPIAttribute");
        sAMLv2IdP.setNameIdDNSpec("XPSAPIDomain");
        sAMLv2IdP.setNameIdFormat("ab=dc");
        sAMLv2IdP.setNameIdType(Integer.valueOf(2));
        sAMLv2IdP.setPassword("firewall");
        sAMLv2IdP.setODBCSearchSpec("name=testing");
        sAMLv2IdP.setSAMLMajorVersion(Integer.valueOf(2));
        sAMLv2IdP.setSAMLMinorVersion(Integer.valueOf(0));
        sAMLv2IdP.setSAMLReqGetAllAttributes(Boolean.valueOf(true));
        sAMLv2IdP.setSkewTime(Integer.valueOf(60));
        sAMLv2IdP.setSPID("XPSAPI12345");
        sAMLv2IdP.setSPName("XPSAPI Testing");
        sAMLv2IdP.setTarget("testing");
        sAMLv2IdP.setUserNotFoundRedirectMode(Integer.valueOf(3));
        sAMLv2IdP.setUserNotFoundRedirectURL("http://UserNotFound");
        return sAMLv2IdP;
    }

    private AuthScheme doAuthValidateSetUp(String string) throws XPSException {
        AuthScheme authScheme = SetupConnection.builder.makeAuthScheme(string);
        this.createObject((XPSObject)authScheme);
        return authScheme;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SAMLv2IdPTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(SAMLv2IdPTest.class);
    }
}

