/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.epm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.Application;
import com.ca.siteminder.sdk.adminapi.ca.epm.Role;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.HashSet;
import junit.framework.Test;
import junit.textui.TestRunner;

public class RoleTest
extends TestBase {
    static Role role;
    static Application app;

    @TestBase.STI(value=1)
    public void testCreateRole() throws XPSException {
        SetupConnection.builder.doApplicationSetUp("TestAppGroupUserDir" + SetupConnection.random, "TestAppGroupApp" + SetupConnection.random);
        app = (Application)SetupConnection.fetchByName(Application.ddclass, "TestAppGroupApp" + SetupConnection.random);
        String string = "Role" + SetupConnection.random;
        role = this.makeRole(string, app);
        this.createObject((XPSObject)role);
    }

    @TestBase.STI(value=2)
    public void testSearchRole() throws XPSException {
        SetupConnection.fetchByName(Role.ddclass, role.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateRole() throws XPSException {
        role.setName("update" + role.getName());
        role.setDescription("update" + role.getDescription());
        this.updateObject((XPSObject)role);
    }

    @TestBase.STI(value=4)
    public void testRoleDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)role);
    }

    @TestBase.STI(value=5)
    public void testDeleteRole() throws XPSException {
        this.deleteObject((XPSObject)role);
        role = null;
    }

    @TestBase.STI(value=6)
    public void testRoleWithoutName() throws XPSException {
        role = this.makeRole(null, app);
        this.failCreate((XPSObject)role, "Name");
    }

    @TestBase.STI(value=7)
    public void testRoleWithoutApplication() throws XPSException {
        String string = "Role2" + SetupConnection.random;
        role = this.makeRole(string, null);
        this.failCreate((XPSObject)role, "parent");
    }

    private Role makeRole(String string, Application application) throws XPSException {
        Role role = (Role)SetupConnection.policyData.newObject((IClass)Role.ddclass);
        HashSet<Role.Flags> hashSet = new HashSet<Role.Flags>();
        hashSet.add(Role.Flags.Disabled);
        if (string != null) {
            role.setName(string);
        }
        if (application != null) {
            role.setParent((Domain)application);
        }
        role.setDescription("XPSAPI JUnit Sample Role");
        role.setExpression("100=100");
        role.setFlags(hashSet);
        return role;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RoleTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(RoleTest.class);
    }
}

