/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.epm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.AttributeMapping;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AttributeMappingTest
extends TestBase {
    static AttributeMapping attributeMapping;
    static UserDirectory userDir;

    @TestBase.STI(value=1)
    public void testCreateAttributeMapping() throws XPSException {
        SetupConnection.builder.doUserDirSetUp("TestDomainUserDirectory" + SetupConnection.random);
        userDir = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "TestDomainUserDirectory" + SetupConnection.random);
        String string = "AttributeMapping" + SetupConnection.random;
        attributeMapping = this.makeAttributeMapping(string, userDir);
        this.createObject((XPSObject)attributeMapping);
    }

    @TestBase.STI(value=2)
    public void testSearchAttributeMapping() throws XPSException {
        SetupConnection.fetchByName(AttributeMapping.ddclass, attributeMapping.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAttributeMapping() throws XPSException {
        attributeMapping.setName("update" + attributeMapping.getName());
        attributeMapping.setDescription("update" + attributeMapping.getDescription());
        this.updateObject((XPSObject)attributeMapping);
    }

    @TestBase.STI(value=4)
    public void testApplicationGroupDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)attributeMapping);
    }

    @TestBase.STI(value=5)
    public void testDeleteAttributeMapping() throws XPSException {
        this.deleteObject((XPSObject)attributeMapping);
        attributeMapping = null;
    }

    @TestBase.STI(value=6)
    public void testAttributeMappingWithoutName() throws XPSException {
        attributeMapping = this.makeAttributeMapping(null, userDir);
        this.failCreate((XPSObject)attributeMapping, "Name");
    }

    @TestBase.STI(value=7)
    public void testAttributeMappingWithoutParent() throws XPSException {
        String string = "AttributeMapping1" + SetupConnection.random;
        attributeMapping = this.makeAttributeMapping(string, null);
        this.failCreate((XPSObject)attributeMapping, "parent");
    }

    private AttributeMapping makeAttributeMapping(String string, UserDirectory userDirectory) throws XPSException {
        AttributeMapping attributeMapping = (AttributeMapping)SetupConnection.policyData.newObject((IClass)AttributeMapping.ddclass);
        if (string != null) {
            attributeMapping.setName(string);
        }
        if (userDirectory != null) {
            attributeMapping.setParent(userDirectory);
        }
        attributeMapping.setDescription("XPSAPI JUnit Sample attributeMapping");
        attributeMapping.setType(AttributeMapping.Type.Group);
        attributeMapping.setDefinition("Testing");
        return attributeMapping;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AttributeMappingTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AttributeMappingTest.class);
    }
}

