/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.alias;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.alias.AliasBase;
import java.util.ArrayList;
import junit.framework.Test;
import junit.textui.TestRunner;

public class StringListAliasTest
extends AliasBase {
    @TestBase.STI(value=1)
    public void testStringListAlias() throws XPSException {
        StringListAliasTest.assertEquals((String)"AliasToStringList attribute must match with aliased string", gMainTest.getAliasToStringList(), (Object)lAliasedString);
    }

    @TestBase.STI(value=2)
    public void testStringListAliasForward() throws XPSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Aliased Value1");
        arrayList.add("Main Value1");
        arrayList.add("Main Value2");
        gMainTest.setAliasToStringList(arrayList);
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        StringListAliasTest.assertEquals((String)"StringList attribute is not updated", test.getStringList(), arrayList);
    }

    @TestBase.STI(value=3)
    public void testStringListAliasBackward() throws XPSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Aliased Value1");
        arrayList.add("Aliased Value2");
        arrayList.add("Main Value1");
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.setStringList(arrayList);
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        StringListAliasTest.assertEquals((String)"AliasToStringList attribute is not updated", gMainTest.getAliasToStringList(), arrayList);
    }

    @TestBase.STI(value=4)
    public void testStringListAliasCleared() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.clearStringList();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        StringListAliasTest.assertTrue((String)"AliasToStringList attribute is not cleared", (boolean)gMainTest.getAliasToStringList().isEmpty());
    }

    @TestBase.STI(value=5)
    public void testStringListMainCleared() throws XPSException {
        gMainTest.clearAliasToStringList();
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        StringListAliasTest.assertTrue((String)"StringList attribute is not cleared", (boolean)test.getStringList().isEmpty());
    }

    @TestBase.STI(value=6)
    public void testStringListSetAliasBeforeLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(null);
        StringListAliasTest.assertEquals((String)"Before setLink, AliasToStringList must match with lMainString", test.getAliasToStringList(), (Object)lMainString);
        test.setLink(this.createAliasTest());
        this.updateObject((XPSObject)test);
        StringListAliasTest.assertEquals((String)"After setLink, AliasToStringList must match with lAliasedString", test.getAliasToStringList(), (Object)lAliasedString);
        test.clearLink();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)test);
        StringListAliasTest.assertEquals((String)"After clearLink, AliasToStringList must match with lMainString", test.getAliasToStringList(), (Object)lMainString);
    }

    @TestBase.STI(value=7)
    public void testStringListAliasToAliasLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(this.createAliasTest());
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = this.createTest(test);
        StringListAliasTest.assertEquals((String)"AliasToAliasToStringList attribute must match with lAliasedString", test2.getAliasToAliasToStringList(), (Object)lAliasedString);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)StringListAliasTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(StringListAliasTest.class);
    }
}

