/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.alias;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.alias.AliasBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class StringAliasTest
extends AliasBase {
    @TestBase.STI(value=1)
    public void testStringAlias() throws XPSException {
        StringAliasTest.assertEquals((String)"AliasToString attribute must have value \"Aliased String\"", (String)gMainTest.getAliasToString(), (String)"Aliased String");
    }

    @TestBase.STI(value=2)
    public void testStringAliasForward() throws XPSException {
        gMainTest.setAliasToString("Main Test");
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        StringAliasTest.assertEquals((String)"The String attributed must have value \"Main Test\"", (String)test.getString(), (String)"Main Test");
    }

    @TestBase.STI(value=3)
    public void testStringAliasBackward() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.setString("Updated Aliased String");
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        StringAliasTest.assertEquals((String)"The String attribute must have value \"Updated Aliased String\"", (String)gMainTest.getAliasToString(), (String)"Updated Aliased String");
    }

    @TestBase.STI(value=4)
    public void testStringAliasCleared() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.clearString();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        StringAliasTest.assertNull((String)"AliasToString attribute is not cleared", (Object)gMainTest.getAliasToString());
    }

    @TestBase.STI(value=5)
    public void testStringMainCleared() throws XPSException {
        gMainTest.clearAliasToString();
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        StringAliasTest.assertNull((String)"String attribute is not cleared", (Object)test.getString());
    }

    @TestBase.STI(value=6)
    public void testStringSetAliasBeforeLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(null);
        StringAliasTest.assertEquals((String)"Before setLink, AliasToString must match with \"Main String\"", (String)test.getAliasToString(), (String)"Main String");
        test.setLink(this.createAliasTest());
        this.updateObject((XPSObject)test);
        StringAliasTest.assertEquals((String)"After setLink, AliasToString must match with \"Aliased String\"", (String)test.getAliasToString(), (String)"Aliased String");
        test.clearLink();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)test);
        StringAliasTest.assertEquals((String)"After ClearLink, AliasToString must match with \"Main String\"", (String)test.getAliasToString(), (String)"Main String");
    }

    @TestBase.STI(value=7)
    public void testStringWithoutLink() throws XPSException {
        StringAliasTest.assertEquals((String)"AliasToStringWithoutLink attribute must match with \"Main String without link\"", (String)gMainTest.getAliasToStringWithoutLink(), (String)"Main String without link");
    }

    @TestBase.STI(value=8)
    public void testStringAliasToAliasLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(this.createAliasTest());
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = this.createTest(test);
        StringAliasTest.assertEquals((String)"AliasToAliasToString attribute must match with \"Aliased String\"", (String)test2.getAliasToAliasToString(), (String)"Aliased String");
    }

    @TestBase.STI(value=9)
    public void testStringAliasToInteger() throws XPSException {
        StringAliasTest.assertEquals((String)"AliasToStringInteger attribute must match with \"String with Integer Link\"", (String)gMainTest.getAliasToStringInteger(), (String)"String with Integer Link");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)StringAliasTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(StringAliasTest.class);
    }
}

