/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.alias;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.alias.AliasBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IntegerAliasTest
extends AliasBase {
    @TestBase.STI(value=1)
    public void testIntegerAlias() throws XPSException {
        IntegerAliasTest.assertEquals((String)"AliasToInteger attribute must have value 10", (Object)gMainTest.getAliasToInteger(), (Object)new Integer(10));
    }

    @TestBase.STI(value=2)
    public void testIntegerAliasForward() throws XPSException {
        gMainTest.setAliasToInteger(20);
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        IntegerAliasTest.assertEquals((String)"The Integer attribute must have value 20", (Object)test.getInteger(), (Object)new Integer(20));
    }

    @TestBase.STI(value=3)
    public void testIntegerAliasBackward() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.setInteger(50);
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        IntegerAliasTest.assertEquals((String)"AliasToInteger attribute must have value 50", (Object)gMainTest.getAliasToInteger(), (Object)new Integer(50));
    }

    @TestBase.STI(value=4)
    public void testBooleanAliasCleared() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.clearInteger();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        IntegerAliasTest.assertNull((String)"AliasToInteger attribute is not cleared", (Object)gMainTest.getAliasToInteger());
    }

    @TestBase.STI(value=5)
    public void testIntegerMainCleared() throws XPSException {
        gMainTest.clearAliasToInteger();
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        IntegerAliasTest.assertNull((String)"Integer attribute is not cleared", (Object)test.getInteger());
    }

    @TestBase.STI(value=6)
    public void testIntegerSetAliasBeforeLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(null);
        IntegerAliasTest.assertEquals((String)"Before setLink, AliasToInteger attribute must have value 50", (Object)test.getAliasToInteger(), (Object)new Integer(50));
        test.setLink(this.createAliasTest());
        this.updateObject((XPSObject)test);
        IntegerAliasTest.assertEquals((String)"After setLink, AliasToInteger attribute must have value 10", (Object)test.getAliasToInteger(), (Object)new Integer(10));
        test.clearLink();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)test);
        IntegerAliasTest.assertEquals((String)"After ClearLink, AliasToInteger attribute must have value 50", (Object)test.getAliasToInteger(), (Object)new Integer(50));
    }

    @TestBase.STI(value=7)
    public void testIntegerWithoutLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(this.createAliasTest());
        IntegerAliasTest.assertEquals((String)"AliasToIntegerWithoutLink attribute must have value 100", (Object)test.getAliasToIntegerWithoutLink(), (Object)new Integer(100));
    }

    @TestBase.STI(value=8)
    public void testIntegerAliasToAliasLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(this.createAliasTest());
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = this.createTest(test);
        IntegerAliasTest.assertEquals((String)"AliasToAliasToInteger must have value 10", (Object)test2.getAliasToAliasToInteger(), (Object)new Integer(10));
    }

    @TestBase.STI(value=9)
    public void testIntegerAliasToBoolean() throws XPSException {
        IntegerAliasTest.assertEquals((String)"AliasToIntegerBoolean attribute must have value 150", (Object)gMainTest.getAliasToIntegerBoolean(), (Object)new Integer(150));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IntegerAliasTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IntegerAliasTest.class);
    }
}

