/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.alias;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.alias.AliasBase;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.Test;
import junit.textui.TestRunner;

public class DateListAliasTest
extends AliasBase {
    @TestBase.STI(value=1)
    public void testDateListAlias() throws XPSException {
        DateListAliasTest.assertEquals((String)"AliasToDateList attribute does not match with aliased date", gMainTest.getAliasToDateList(), (Object)lAliasedDate);
    }

    @TestBase.STI(value=2)
    public void testDateListAliasForward() throws XPSException {
        ArrayList<Date> arrayList = new ArrayList<Date>();
        arrayList.add(alisedDate);
        arrayList.add(alisedDate);
        gMainTest.setAliasToDateList(arrayList);
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        DateListAliasTest.assertEquals((String)"The DateList attribute must match with lDate", test.getDateList(), arrayList);
    }

    @TestBase.STI(value=3)
    public void testDateListAliasBackward() throws XPSException {
        ArrayList<Date> arrayList = new ArrayList<Date>();
        arrayList.add(mainDate);
        arrayList.add(mainDate);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.setDateList(arrayList);
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        DateListAliasTest.assertEquals((String)"AliasToDateList attribute must match with lDate", gMainTest.getAliasToDateList(), arrayList);
    }

    @TestBase.STI(value=4)
    public void testDateListAliasCleared() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.clearDateList();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        DateListAliasTest.assertTrue((String)"AliasToDateList attribute is not cleared", (boolean)gMainTest.getAliasToDateList().isEmpty());
    }

    @TestBase.STI(value=5)
    public void testDateListMainCleared() throws XPSException {
        gMainTest.clearAliasToDateList();
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        DateListAliasTest.assertTrue((String)"DateList attribute is not cleared", (boolean)test.getDateList().isEmpty());
    }

    @TestBase.STI(value=6)
    public void testDateListSetAliasBeforeLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(null);
        DateListAliasTest.assertEquals((String)"Before setLink, AliasToDateList attribute must match with main date", test.getAliasToDateList(), (Object)lMainDate);
        test.setLink(test);
        this.updateObject((XPSObject)test);
        DateListAliasTest.assertEquals((String)"After setLink, AliasToDateList attribute must match with aliased date", test.getAliasToDateList(), (Object)lAliasedDate);
        test.clearLink();
        this.updateObject((XPSObject)test);
        DateListAliasTest.assertEquals((String)"After clearLink, AliasToDateList attribute must match with main date", test.getAliasToDateList(), (Object)lMainDate);
    }

    @TestBase.STI(value=7)
    public void testDateListAliasToAliasLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(this.createAliasTest());
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = this.createTest(test);
        DateListAliasTest.assertEquals((String)"AliasToAliasToDateList attribute must match with aliased date", test2.getAliasToAliasToDateList(), (Object)lAliasedDate);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DateListAliasTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(DateListAliasTest.class);
    }
}

