/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.alias;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.alias.AliasBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class BooleanAliasTest
extends AliasBase {
    @TestBase.STI(value=1)
    public void testBooleanAlias() throws XPSException {
        BooleanAliasTest.assertTrue((String)"testBooleanAlias: Attribute AliasToBoolean is false", (boolean)gMainTest.getAliasToBoolean());
    }

    @TestBase.STI(value=2)
    public void testBooleanAliasForward() throws XPSException {
        gMainTest.setAliasToBoolean(false);
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        BooleanAliasTest.assertFalse((String)"Attribute Boolean is true", (boolean)test.getBoolean());
    }

    @TestBase.STI(value=3)
    public void testBooleanAliasBackward() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.setBoolean(false);
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        BooleanAliasTest.assertFalse((String)"Attribute AliasToBoolean is true", (boolean)gMainTest.getAliasToBoolean());
    }

    @TestBase.STI(value=4)
    public void testBooleanAliasCleared() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.clearBoolean();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        BooleanAliasTest.assertNull((String)"Attribute AliasToBoolean is not cleared", (Object)gMainTest.getAliasToBoolean());
    }

    @TestBase.STI(value=5)
    public void testBooleanMainCleared() throws XPSException {
        gMainTest.clearAliasToBoolean();
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        BooleanAliasTest.assertNull((String)"The Boolean attribute is not null", (Object)test.getBoolean());
    }

    @TestBase.STI(value=6)
    public void testBooleanSetAliasBeforeLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createAliasTest();
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = this.createTest(null);
        BooleanAliasTest.assertFalse((String)"Before setLink, Attribute AliasToBoolean must be False", (boolean)test2.getAliasToBoolean());
        test2.setLink(test);
        this.updateObject((XPSObject)test2);
        BooleanAliasTest.assertTrue((String)"After setLink, Attribute AliasToBoolean must be True", (boolean)test2.getAliasToBoolean());
        test2.clearLink();
        this.updateObject((XPSObject)test2);
        BooleanAliasTest.assertFalse((String)"After clearing setLink, Attribute AliasToBoolean must be False", (boolean)test2.getAliasToBoolean());
    }

    @TestBase.STI(value=7)
    public void testBooleanWithoutLink() throws XPSException {
        BooleanAliasTest.assertFalse((String)"value of AliasToBooleanWithoutLink attribute must be False", (boolean)gMainTest.getAliasToBooleanWithoutLink());
    }

    @TestBase.STI(value=8)
    public void testBooleanAliasToAliasLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createAliasTest();
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = this.createTest(test);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test3 = this.createTest(test2);
        BooleanAliasTest.assertTrue((String)"testBooleanAliasToAliasLink: Attribute AliasToAliasToBoolean is false", (boolean)test3.getAliasToAliasToBoolean());
    }

    @TestBase.STI(value=9)
    public void testBooleanAliasToString() throws XPSException {
        BooleanAliasTest.assertFalse((String)"Attribute AliasToBooleanString must be false", (boolean)gMainTest.getAliasToBooleanString());
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BooleanAliasTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(BooleanAliasTest.class);
    }
}

