/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest;

import com.ca.siteminder.rpc.output.PrintFormatter;
import com.ca.siteminder.sdk.adminapi.Config;
import com.ca.siteminder.sdk.adminapi.ConnectionHelper;
import com.ca.siteminder.sdk.adminapi.DataDictionary;
import com.ca.siteminder.sdk.adminapi.DirectoryManager;
import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.RpcRegistry;
import com.ca.siteminder.sdk.adminapi.Security;
import com.ca.siteminder.sdk.adminapi.Server;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.STIHarness;
import com.ca.siteminder.sdk.adminapitest.STIUtil;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import netegrity.siteminder.javaagent.AgentAPI;

public class SetupConnection
extends TestSetup {
    public static Session session = null;
    public static PrintFormatter formatter;
    static PrintWriter out;
    RpcRegistry reg;
    public static PolicyData policyData;
    public static Security security;
    public static DataDictionary dictionary;
    public static Config configXPS;
    public static Config configSM;
    public static Config configEPM;
    public static long random;
    public static final boolean smSuccess = true;
    public static final String BUNDLE_NAME = "clienttest.properties";
    public static Map<String, String> properties;
    public static ObjectBuilder builder;
    private TestBase testBaseInst;
    public static List<XPSObject> toDelete;

    public SetupConnection(TestSuite testSuite) {
        super((Test)testSuite);
    }

    public SetupConnection(Class<? extends TestBase> clazz) {
        super((Test)new TestSuite(clazz.getSimpleName()));
        try {
            this.testBaseInst = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        TestSuite testSuite = (TestSuite)this.getTest();
        TestBase.buildSuite(clazz, testSuite);
    }

    protected void setUp() throws Exception {
        out = new PrintWriter(System.out);
        toDelete = new LinkedList<XPSObject>();
        this.init();
        this.testBaseInst.setUpSuite();
    }

    protected void tearDown() {
        this.testBaseInst.tearDownSuite();
        Collections.reverse(toDelete);
        ListIterator<XPSObject> listIterator = toDelete.listIterator();
        while (listIterator.hasNext()) {
            XPSObject xPSObject = listIterator.next();
            if ((xPSObject = policyData.fetchObject(xPSObject.getXid(), true)) == null) continue;
            try {
                policyData.deleteObject(xPSObject);
            }
            catch (XPSException xPSException) {}
        }
        session.disconnect();
        session.getConnection().unInit();
        session = null;
    }

    public static void createObject(XPSObject xPSObject) {
        STIUtil.createObject(session, policyData, xPSObject);
        toDelete.add(xPSObject);
    }

    public static void updateObject(XPSObject xPSObject) {
        STIUtil.updateObject(session, policyData, xPSObject);
    }

    public static void deleteObject(XPSObject xPSObject) {
        toDelete.remove(xPSObject);
        STIUtil.deleteObject(session, policyData, xPSObject);
    }

    protected void init() throws Exception {
        formatter = new PrintFormatter(out).structured();
        ConnectionHelper connectionHelper = new ConnectionHelper();
        session = new Session();
        properties = connectionHelper.propertiesToMap(new String[]{"sti.cfg", BUNDLE_NAME});
        if (STIHarness.cfg == null) {
            AgentAPI agentAPI = connectionHelper.connect(properties);
            String string = connectionHelper.PMAPI_login();
            Map map = connectionHelper.toMap();
            session.setContext(map);
            session.setConnection(agentAPI);
            session.setSessionTicket(string);
        } else {
            AgentAPI agentAPI = connectionHelper.connect(STIHarness.cfg.ps_ip);
            String string = connectionHelper.PMAPI_login(STIHarness.cfg.admin, STIHarness.cfg.pwd);
            session.setConnection(agentAPI);
            session.setSessionTicket(string);
        }
        session.connect();
        this.reg = RpcRegistry.get();
        policyData = session.getPolicyData();
        dictionary = session.getDictionary();
        security = session.getSecurity();
        configXPS = session.getConfig("CA", "XPS");
        configSM = session.getConfig("CA", "SM");
        configEPM = session.getConfig("CA", "EPM");
        builder = new ObjectBuilder();
    }

    public static <T extends XPSObject> T refetchObject(XPSObject xPSObject, IClass<T> iClass) {
        XPSObject xPSObject2 = policyData.fetchObject(xPSObject.getXid(), true);
        return (T)(xPSObject2 != null ? xPSObject2.castTo(iClass.getJavaClass()) : null);
    }

    public static <T extends XPSObject> T fetchByName(IClass<T> iClass, String string) {
        return SetupConnection.fetchByAttr(iClass, "Name", string);
    }

    public static <T extends XPSObject> T fetchByName(IClass<T> iClass, XPSObject xPSObject, String string) {
        return SetupConnection.fetchByAttr(iClass, xPSObject, "Name", string);
    }

    public static <T extends XPSObject> T fetchByAttr(IClass<T> iClass, String string, String string2) {
        IAttribute iAttribute = iClass.getAttribute(string);
        if (iAttribute == null) {
            throw new XPSException("class.attribute.wrong", new Object[]{iClass.getName(), string});
        }
        return SetupConnection.fetchByAttr(iClass, iAttribute, string2);
    }

    public static <T extends XPSObject> T fetchByAttr(IClass<T> iClass, IAttribute iAttribute, String string) {
        Filter filter = new Filter(iAttribute, Clause.Operator.EQUAL, (Object)string);
        List list = policyData.search(iClass, filter);
        if (list.size() != 1) {
            throw new XPSException("fetchByAttr", new Object[]{iClass.getName(), string, list.size()});
        }
        return (T)((XPSObject)list.get(0));
    }

    public static <T extends XPSObject> T fetchByAttr(IClass<T> iClass, XPSObject xPSObject, String string, String string2) {
        IAttribute iAttribute = iClass.getAttribute(string);
        if (iAttribute == null) {
            throw new XPSException("class.attribute.wrong", new Object[]{iClass.getName(), string});
        }
        Filter filter = new Filter(iAttribute, Clause.Operator.EQUAL, (Object)string2);
        filter.AND(new Filter((IAttribute)XPSObject.PARENT, Clause.Operator.EQUAL, (Object)xPSObject));
        List list = policyData.search(iClass, filter);
        if (list.size() != 1) {
            throw new XPSException("fetchByAttr", new Object[]{iClass.getName(), string2, list.size()});
        }
        return (T)((XPSObject)list.get(0));
    }

    public static void println(String string) {
        out.println(string);
        out.flush();
    }

    public static void format(String string, Object ... objectArray) {
        out.format(string, objectArray);
        out.flush();
    }

    public static PolicyData getPolicyData() {
        return session.getPolicyData();
    }

    public static Server getServer() {
        return session.getServer();
    }

    public static DirectoryManager getDirectoryManager() {
        return session.getDirectoryManager();
    }

    public static Security getSecurity() {
        return session.getSecurity();
    }

    public static DataDictionary getDictionary() {
        return session.getDictionary();
    }

    public static Config getConfigXPS() {
        return session.getConfig("CA", "XPS");
    }

    static {
        random = System.currentTimeMillis();
    }
}

