/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest;

import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import java.util.List;
import junit.framework.TestCase;

public class STIUtil
extends TestCase {
    public static void createObject(Session session, PolicyData policyData, XPSObject xPSObject) {
        policyData.createObject(xPSObject);
    }

    public static void updateObject(Session session, PolicyData policyData, XPSObject xPSObject) {
        policyData.updateObject(xPSObject);
    }

    public static void deleteObject(Session session, PolicyData policyData, XPSObject xPSObject) {
        policyData.deleteObject(xPSObject);
    }

    static void assertMessageContains(String string, String string2, String string3) {
        if (string2 == null) {
            if (string3 != null) {
                STIUtil.fail((String)(string + " Exception message must be null"));
            }
        } else {
            if (string3 == null) {
                STIUtil.fail((String)(string + " Exception message is null"));
            }
            if (!string3.contains(string2)) {
                STIUtil.fail((String)(string + " Exception message '" + string3 + "' must contain '" + string2 + "'"));
            }
        }
    }

    public static void failCreate(PolicyData policyData, XPSObject xPSObject, String string) {
        try {
            policyData.createObject(xPSObject);
            STIUtil.fail((String)("failCreate " + xPSObject.getClass().getSimpleName() + " created"));
        }
        catch (ServerException serverException) {
            String string2 = serverException.getMsg();
            STIUtil.assertMessageContains("failCreate", string, string2);
        }
    }

    public static void failUpdate(PolicyData policyData, XPSObject xPSObject, String string) {
        try {
            policyData.updateObject(xPSObject);
            STIUtil.fail((String)("failUpdate " + xPSObject.getClass().getSimpleName() + " updated"));
        }
        catch (ServerException serverException) {
            String string2 = serverException.getMsg();
            STIUtil.assertMessageContains("failUpdate", string, string2);
        }
    }

    public static void failDelete(PolicyData policyData, XPSObject xPSObject, String string) {
        try {
            policyData.deleteObject(xPSObject);
            STIUtil.fail((String)("failDelete " + xPSObject.getClass().getSimpleName() + " deleted"));
        }
        catch (ServerException serverException) {
            String string2 = serverException.getMsg();
            STIUtil.assertMessageContains("failDalete", string, string2);
        }
    }

    public static <T extends XPSObject> void failSearchByNameOrNoObjectReturned(PolicyData policyData, DDClass<T> dDClass, String string, String string2) {
        block2: {
            try {
                STIUtil.failSearchByName(policyData, dDClass, string, string2);
            }
            catch (XPSException xPSException) {
                if (xPSException.getTag() == "fetchByName") break block2;
                throw xPSException;
            }
        }
    }

    public static <T extends XPSObject> void failSearchByName(PolicyData policyData, DDClass<T> dDClass, String string, String string2) {
        try {
            T t = STIUtil.fetchByName(policyData, dDClass, string);
            STIUtil.fail((String)("failSearchByName - error: searched " + dDClass.getName() + " with name=" + string + " found object: " + t));
        }
        catch (XPSException xPSException) {
            // empty catch block
        }
    }

    public static <T extends XPSObject> T refetchObject(PolicyData policyData, XPSObject xPSObject, IClass<T> iClass) {
        XPSObject xPSObject2 = policyData.fetchObject(xPSObject.getXid(), true);
        return (T)(xPSObject2 != null ? xPSObject2.castTo(iClass.getJavaClass()) : null);
    }

    public static <T extends XPSObject> T fetchByName(PolicyData policyData, IClass<T> iClass, String string) {
        IAttribute iAttribute = iClass.getAttribute("Name");
        if (iAttribute == null) {
            throw new XPSException("class.attribute.wrong", new Object[]{iClass.getName(), "Name"});
        }
        Filter filter = new Filter(iAttribute, Clause.Operator.EQUAL, (Object)string);
        List list = policyData.search(iClass, filter);
        if (list.size() != 1) {
            throw new XPSException("fetchByName", new Object[]{iClass.getName(), string, list.size()});
        }
        return (T)((XPSObject)list.get(0));
    }
}

