/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest;

import com.ca.siteminder.sdk.adminapitest.AssertionSkip;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;

class STIListener
implements TestListener {
    int count = 0;
    int nTests;
    String name;
    Status ok;
    int success = 0;
    int failure = 0;
    String currentSuite;

    STIListener(Test test) {
        this.nTests = test.countTestCases();
        this.println("running test " + test.toString());
        this.println("1.." + this.nTests);
    }

    void println(String string) {
        System.out.println(string);
        System.out.flush();
    }

    void errorln(String string) {
        System.err.println(string);
        System.err.flush();
    }

    private void addError1(Test test, Throwable throwable) {
        String string = throwable.toString();
        boolean bl = throwable instanceof AssertionSkip;
        this.ok = bl ? Status.SKIP : Status.NOT_OK;
        this.println(string);
        throwable.printStackTrace();
        if (test instanceof SetupConnection) {
            SetupConnection setupConnection = (SetupConnection)test;
            int n = test.countTestCases();
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    this.println("ok #skipped");
                }
            } else {
                this.failure += n;
            }
            this.count += n;
        }
    }

    public void addError(Test test, Throwable throwable) {
        this.addError1(test, throwable);
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.addError1(test, (Throwable)assertionFailedError);
    }

    public void startTest(Test test) {
        String string = test.getClass().getSimpleName();
        if (!string.equals(this.currentSuite)) {
            System.out.println("starting " + string);
            this.currentSuite = string;
        }
        this.ok = Status.OK;
        ++this.count;
    }

    public void endTest(Test test) {
        String string;
        if (this.ok == Status.OK) {
            ++this.success;
            string = "ok";
        } else if (this.ok == Status.NOT_OK) {
            ++this.failure;
            string = "not ok";
        } else {
            string = "ok #skipped";
        }
        this.println(string + " " + this.count + " " + test);
        if (this.count == this.nTests) {
            this.printTotals();
        }
    }

    public void printTotals() {
        this.println("total " + this.nTests + "; success " + this.success + "; failure " + this.failure + "; skipped " + (this.nTests - this.success - this.failure));
    }

    static enum Status {
        OK,
        NOT_OK,
        SKIP;

    }
}

